/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Hashtable;
import java.util.Map;
import javajs.awt.Font;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.T3;
import org.jmol.export.UseTable;
import org.jmol.export.__CartesianExporter;
import org.jmol.util.Geodesic;
import org.jmol.viewer.Viewer;

public class _VrmlExporter
extends __CartesianExporter {
    protected UseTable useTable;
    private Map<String, Boolean> htSpheresRendered = new Hashtable<String, Boolean>();
    private T3[] plateVertices;
    private int[][] plateIndices;
    private short[] plateColixes;
    protected P3 tempQ1 = new P3();
    protected P3 tempQ2 = new P3();
    protected P3 tempQ3 = new P3();
    private int[][] oneFace;
    private P3[] threeVertices;
    protected float fontSize;
    protected String fontFace;
    protected String fontStyle;
    protected String fontChild;

    public _VrmlExporter() {
        this.useTable = new UseTable("USE ");
        this.commentChar = "# ";
        this.canCapCylinders = true;
        this.solidOnly = true;
    }

    @Override
    protected void output(T3 t3) {
        this.output(_VrmlExporter.round(t3));
    }

    @Override
    protected void outputHeader() {
        this.output("#VRML V2.0 utf8 Generated by Jmol " + Viewer.getJmolVersion() + "\n");
        this.output("WorldInfo { \n");
        this.output(" title " + PT.esc(this.vwr.ms.modelSetName) + "\n");
        this.output(" info [ \"Generated by Jmol " + Viewer.getJmolVersion() + " \", \n");
        this.output("  \"http://www.jmol.org \", \n");
        this.output("  \"Creation date: " + this.getExportDate() + " \" ]\n");
        this.output("} \n");
        this.output("NavigationInfo { type \"EXAMINE\" } \n");
        this.output("Background { skyColor [" + this.rgbFractionalFromColix(this.backgroundColix) + "] } \n");
        float f = this.getViewpoint();
        this.output("Viewpoint{fieldOfView " + f);
        this.output(" position ");
        this.cameraPosition.scale(this.exportScale);
        this.output(this.cameraPosition);
        this.output(" orientation ");
        this.output(this.tempP1);
        this.output(" " + -this.viewpoint.angle);
        this.output("\n jump TRUE description \"v1\"\n}\n\n");
        this.output(this.getJmolPerspective());
        this.outputInitialTransform();
        this.output("\n");
    }

    protected void outputInitialTransform() {
        this.pushMatrix();
        this.outputAttr("scale", this.exportScale, this.exportScale, this.exportScale);
        this.outputCloseTag();
        this.outputChildStart();
        this.pushMatrix();
        this.tempP1.setT(this.center);
        this.tempP1.scale(-1.0f);
        this.outputAttrPt("translation", this.tempP1);
        this.outputCloseTag();
        this.outputChildStart();
    }

    protected float getViewpoint() {
        this.viewpoint.setM(this.vwr.tm.matrixRotate);
        this.tempP1.set(this.viewpoint.x, this.viewpoint.y, this.viewpoint.angle == 0.0f ? 1.0f : this.viewpoint.z);
        return (float)((double)this.apertureAngle * Math.PI / 180.0);
    }

    @Override
    protected void outputFooter() {
        this.useTable = null;
        this.output("\n]}\n");
        this.output("]}");
    }

    protected void outputAppearance(short s, boolean bl) {
        String string = this.getDef(String.valueOf(bl ? "T" : "") + s);
        this.output("appearance ");
        if (string.charAt(0) == '_') {
            String string2 = this.rgbFractionalFromColix(s);
            this.output(" DEF " + string + " Appearance{material Material{diffuseColor ");
            if (bl) {
                this.output(" 0 0 0 specularColor 0 0 0 ambientIntensity 0.0 shininess 0.0 emissiveColor " + string2 + " }}");
            } else {
                this.output(String.valueOf(string2) + " transparency " + _VrmlExporter.translucencyFractionalFromColix(s) + "}}");
            }
            return;
        }
        this.output(string);
    }

    protected void pushMatrix() {
        this.output("Transform{");
    }

    protected void popMatrix() {
        this.output("}\n");
    }

    protected void outputAttrPt(String string, T3 t3) {
        this.output(" " + string + " " + t3.x + " " + t3.y + " " + t3.z);
    }

    protected void outputAttr(String string, float f, float f2, float f3) {
        this.output(" " + string + " " + _VrmlExporter.round(f) + " " + _VrmlExporter.round(f2) + " " + _VrmlExporter.round(f3));
    }

    protected void outputRotation(A4 a4) {
        this.output(" rotation " + a4.x + " " + a4.y + " " + a4.z + " " + a4.angle);
    }

    protected void outputTransRot(P3 p3, P3 p32, int n, int n2, int n3) {
        this.tempV1.ave(p32, p3);
        this.outputAttrPt("translation", this.tempV1);
        this.tempV1.sub(p3);
        this.tempV1.normalize();
        this.tempV2.set(n, n2, n3);
        this.tempV2.add(this.tempV1);
        this.outputRotation(A4.newVA(this.tempV2, (float)Math.PI));
    }

    protected void outputQuaternionFrame(P3 p3, P3 p32, P3 p33, P3 p34, float f, float f2, float f3) {
        this.tempQ1.setT(p32);
        this.tempQ2.setT(p33);
        A4 a4 = Quat.getQuaternionFrame(p3, this.tempQ1, this.tempQ2).toAxisAngle4f();
        if (!Float.isNaN(a4.x)) {
            this.tempQ1.set(a4.x, a4.y, a4.z);
            this.outputRotation(a4);
        }
        float f4 = p32.distance(p3) * f;
        float f5 = p33.distance(p3) * f2;
        float f6 = p34.distance(p3) * f3;
        this.outputAttr("scale", f4, f5, f6);
    }

    protected void outputChildShapeStart() {
        this.outputChildStart();
        this.outputShapeStart();
    }

    protected void outputChildStart() {
        this.output(" children[");
    }

    protected void outputShapeStart() {
        this.output(" Shape{geometry ");
    }

    protected void outputDefChildFaceSet(String string) {
        if (string != null) {
            this.output("DEF " + string + " ");
        }
        this.outputFaceSetStart();
    }

    protected void outputFaceSetStart() {
        this.output("IndexedFaceSet {");
    }

    protected void outputFaceSetClose() {
        this.output("}\n");
    }

    protected void outputUseChildClose(String string) {
        this.output(string);
    }

    protected void outputChildShapeClose() {
        this.outputShapeClose();
        this.outputChildClose();
    }

    protected void outputChildClose() {
        this.output("]");
    }

    protected void outputShapeClose() {
        this.output("}");
    }

    protected void outputCloseTag() {
    }

    @Override
    protected void outputCircle(P3 p3, P3 p32, float f, short s, boolean bl) {
        if (bl) {
            this.pushMatrix();
            this.tempV1.ave(p3, p32);
            this.outputAttr("translation", this.tempV1.x, this.tempV1.y, this.tempV1.z);
            this.output(" children [ Billboard{axisOfRotation 0 0 0 children [ Transform{rotation 1 0 0 1.5708");
            float f2 = p3.distance(p32);
            this.outputAttr("scale", f, f2, f);
            this.outputCylinderChildScaled(s, (byte)2);
            this.output("}] }]\n");
            this.popMatrix();
            return;
        }
        String string = this.getDef("C" + s + "_" + f);
        this.pushMatrix();
        this.outputTransRot(p3, p32, 0, 0, 1);
        this.outputAttr("scale", f, f, f);
        this.output(" children [");
        if (string.charAt(0) == '_') {
            this.output("DEF " + string);
            this.output(" Billboard{axisOfRotation 0 0 0 children [ Transform{children[");
            this.output(" Shape{");
            this.output("geometry Extrusion{beginCap FALSE convex FALSE endCap FALSE creaseAngle 1.57");
            this.output(" crossSection [");
            float f3 = (float)Math.PI / 180;
            float f4 = 0.02f / f;
            int n = 0;
            while (n <= 360) {
                this.output(String.valueOf(_VrmlExporter.round(Math.cos((float)n * f3) * (double)f4)) + " ");
                this.output(String.valueOf(_VrmlExporter.round(Math.sin((float)n * f3) * (double)f4)) + " ");
                n += 10;
            }
            this.output("] spine [");
            n = 0;
            while (n <= 360) {
                this.output(String.valueOf(_VrmlExporter.round(Math.cos((float)n * f3))) + " ");
                this.output(String.valueOf(_VrmlExporter.round(Math.sin((float)n * f3))) + " 0 ");
                n += 10;
            }
            this.output("]");
            this.output("}");
            this.outputAppearance(s, false);
            this.output("}");
            this.output("]} ]}");
        } else {
            this.output(string);
        }
        this.output("]");
        this.popMatrix();
    }

    @Override
    protected void outputCone(P3 p3, P3 p32, float f, short s) {
        float f2 = p3.distance(p32);
        this.pushMatrix();
        this.outputTransRot(p3, p32, 0, 1, 0);
        this.outputAttr("scale", f, f2, f);
        this.outputCloseTag();
        this.outputChildShapeStart();
        String string = this.getDef("c");
        if (string.charAt(0) == '_') {
            this.outputDefChildFaceSet(string);
            this.outputConeGeometry(true);
            this.outputFaceSetClose();
        } else {
            this.outputUseChildClose(string);
        }
        this.outputAppearance(s, false);
        this.outputChildShapeClose();
        this.popMatrix();
    }

    private void outputConeGeometry(boolean bl) {
        int n = 10;
        int n2 = 360 / n;
        int n3 = n2 + (bl ? 2 : 1);
        int[][] nArray = AU.newInt2(n2 * (bl ? 2 : 1));
        int n4 = 0;
        int n5 = 0;
        while (n4 < n2) {
            nArray[n5++] = new int[]{n4, (n4 + n2 - 1) % n2, n2};
            if (bl) {
                nArray[n5++] = new int[]{n4, (n4 + 1) % n2, n2 + 1};
            }
            ++n4;
        }
        T3[] t3Array = new P3[n3];
        n5 = 0;
        while (n5 < n2) {
            float f = (float)Math.cos((double)(n5 * n) / 180.0 * Math.PI);
            float f2 = (float)Math.sin((double)(n5 * n) / 180.0 * Math.PI);
            t3Array[n5] = P3.new3(f, -0.5f, f2);
            ++n5;
        }
        t3Array[n2++] = P3.new3(0.0f, 0.5f, 0.0f);
        if (bl) {
            t3Array[n2++] = P3.new3(0.0f, -0.5f, 0.0f);
        }
        this.outputGeometry(t3Array, null, null, nArray, null, n3, nArray.length, null, 3, null, null, null);
    }

    @Override
    protected boolean outputCylinder(P3 p3, P3 p32, P3 p33, short s, byte by, float f, P3 p34, P3 p35, boolean bl) {
        float f2 = p32.distance(p33);
        if (f < 0.01f || f2 == 0.0f) {
            return false;
        }
        this.pushMatrix();
        if (p34 == null) {
            this.outputTransRot(p32, p33, 0, 1, 0);
            this.outputAttr("scale", f, f2, f);
        } else {
            this.outputAttrPt("translation", p3);
            this.outputQuaternionFrame(p3, p35, p32, p34, 2.0f, 2.0f, 2.0f);
            p32.set(0.0f, 0.0f, -0.5f);
            p33.set(0.0f, 0.0f, 0.5f);
        }
        this.outputCloseTag();
        this.outputCylinderChildScaled(s, by);
        this.popMatrix();
        if (f > 0.1f) {
            switch (by) {
                case 3: {
                    this.outputSphere(p32, f * 1.01f, s, bl);
                }
                case 4: 
                case 5: {
                    this.outputSphere(p33, f * 1.01f, s, bl);
                    break;
                }
            }
        }
        return true;
    }

    protected void outputCylinderChildScaled(short s, byte by) {
        this.outputChildShapeStart();
        String string = this.getDef("C_" + by);
        if (string.charAt(0) == '_') {
            this.outputDefChildFaceSet(string);
            this.outputCylinderGeometry(by);
            this.outputFaceSetClose();
        } else {
            this.outputUseChildClose(string);
        }
        this.outputAppearance(s, false);
        this.outputChildShapeClose();
    }

    private void outputCylinderGeometry(int n) {
        float f;
        float f2;
        int n2 = 10;
        int n3 = 360 / n2;
        int n4 = n3 * 2;
        boolean bl = false;
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n4 += 2;
                bl = true;
            }
        }
        int[][] nArray = AU.newInt2(n3 * (bl ? 4 : 2));
        int n5 = 0;
        int n6 = 0;
        while (n5 < n3) {
            nArray[n6++] = new int[]{n5, (n5 + 1) % n3, n5 + n3};
            nArray[n6++] = new int[]{(n5 + 1) % n3, (n5 + 1) % n3 + n3, n5 + n3};
            if (bl) {
                nArray[n6++] = new int[]{n5, (n5 + n3 - 1) % n3, n4 - 2};
                nArray[n6++] = new int[]{n5 + n3, (n5 + n3 + 1) % n3 + n3, n4 - 1};
            }
            ++n5;
        }
        T3[] t3Array = new P3[n4];
        n6 = 0;
        while (n6 < n3) {
            f2 = (float)Math.cos((double)(n6 * n2) / 180.0 * Math.PI);
            f = (float)Math.sin((double)(n6 * n2) / 180.0 * Math.PI);
            t3Array[n6] = P3.new3(f2, 0.5f, f);
            ++n6;
        }
        n6 = 0;
        while (n6 < n3) {
            f2 = (float)Math.cos(((double)n6 + 0.5) * (double)n2 / 180.0 * Math.PI);
            f = (float)Math.sin(((double)n6 + 0.5) * (double)n2 / 180.0 * Math.PI);
            t3Array[n6 + n3] = P3.new3(f2, -0.5f, f);
            ++n6;
        }
        if (bl) {
            t3Array[n4 - 2] = P3.new3(0.0f, 0.5f, 0.0f);
            t3Array[n4 - 1] = P3.new3(0.0f, -0.5f, 0.0f);
        }
        this.outputGeometry(t3Array, null, null, nArray, null, n4, nArray.length, null, 3, null, null, null);
    }

    @Override
    protected void outputSphere(P3 p3, float f, short s, boolean bl) {
        String string = String.valueOf(_VrmlExporter.round(p3)) + (bl ? " " + (int)(f * 100.0f) : "");
        if (this.htSpheresRendered.get(string) != null) {
            return;
        }
        this.htSpheresRendered.put(string, Boolean.TRUE);
        this.outputSphereChildScaled(p3, f, null, s);
    }

    @Override
    protected void outputEllipsoid(P3 p3, P3[] p3Array, short s) {
        this.outputSphereChildScaled(p3, 1.0f, p3Array, s);
    }

    private void outputSphereChildScaled(P3 p3, float f, P3[] p3Array, short s) {
        this.pushMatrix();
        this.outputAttrPt("translation", p3);
        if (p3Array == null) {
            this.outputAttr("scale", f, f, f);
        } else {
            this.outputQuaternionFrame(p3, p3Array[1], p3Array[3], p3Array[5], 1.0f, 1.0f, 1.0f);
        }
        this.outputCloseTag();
        this.outputChildShapeStart();
        String string = this.getDef("S");
        if (string.charAt(0) == '_') {
            this.outputDefChildFaceSet(string);
            this.outputSphereGeometry();
            this.outputFaceSetClose();
        } else {
            this.outputUseChildClose(string);
        }
        this.outputAppearance(s, false);
        this.outputChildShapeClose();
        this.popMatrix();
    }

    private void outputSphereGeometry() {
        T3[] t3Array = Geodesic.getVertexVectors();
        int n = 162;
        short[] sArray = Geodesic.getFaceVertexes(2);
        int n2 = sArray.length / 3;
        int[][] nArray = new int[n2][3];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int n5 = 0;
            while (n5 < 3) {
                nArray[n3][n5] = sArray[n4++];
                ++n5;
            }
            ++n3;
        }
        this.outputGeometry(t3Array, null, null, nArray, null, n, n2, null, 3, null, null, null);
    }

    @Override
    protected void outputSolidPlate(P3 p3, P3 p32, P3 p33, short s) {
        int n;
        if (this.plateVertices == null) {
            this.plateVertices = new P3[6];
            n = 0;
            while (n < 6) {
                this.plateVertices[n] = new P3();
                ++n;
            }
            int[][] nArrayArray = new int[8][];
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            nArrayArray[0] = nArray;
            nArrayArray[1] = new int[]{5, 4, 3};
            int[] nArray2 = new int[3];
            nArray2[1] = 3;
            nArray2[2] = 1;
            nArrayArray[2] = nArray2;
            nArrayArray[3] = new int[]{1, 3, 4};
            nArrayArray[4] = new int[]{1, 4, 2};
            nArrayArray[5] = new int[]{2, 4, 5};
            int[] nArray3 = new int[3];
            nArray3[0] = 2;
            nArray3[1] = 5;
            nArrayArray[6] = nArray3;
            int[] nArray4 = new int[3];
            nArray4[1] = 5;
            nArray4[2] = 3;
            nArrayArray[7] = nArray4;
            this.plateIndices = nArrayArray;
        }
        Measure.calcNormalizedNormal(p3, p32, p33, this.tempV1, this.tempV2);
        this.tempV1.scale(0.2f);
        this.plateVertices[0].setT(p3);
        this.plateVertices[1].setT(p32);
        this.plateVertices[2].setT(p33);
        n = 0;
        while (n < 3) {
            this.plateVertices[n].add(this.tempV1);
            ++n;
        }
        this.tempV1.scale(-2.0f);
        n = 3;
        while (n < 6) {
            this.plateVertices[n].add2(this.plateVertices[n - 3], this.tempV1);
            ++n;
        }
        this.outputSurface(this.plateVertices, null, null, this.plateIndices, this.plateColixes, 6, 8, 8, null, 3, s, null, null, null);
    }

    @Override
    protected void outputSurface(T3[] t3Array, T3[] t3Array2, short[] sArray, int[][] nArray, short[] sArray2, int n, int n2, int n3, BS bS, int n4, short s, Lst<Short> lst, Map<Short, Integer> map, P3 p3) {
        this.outputShapeStart();
        this.outputDefChildFaceSet(null);
        this.outputGeometry(t3Array, t3Array2, sArray, nArray, sArray2, n, n2, bS, n4, lst, map, p3);
        this.outputFaceSetClose();
        this.outputAppearance(s, false);
        this.outputShapeClose();
    }

    protected void outputGeometry(T3[] t3Array, T3[] t3Array2, short[] sArray, int[][] nArray, short[] sArray2, int n, int n2, BS bS, int n3, Lst<Short> lst, Map<Short, Integer> map, P3 p3) {
        if (sArray2 == null) {
            this.output("  creaseAngle 0.5  \n");
        } else {
            this.output(" colorPerVertex FALSE\n");
        }
        this.output("coord Coordinate {\npoint [\n");
        this.outputVertices(t3Array, n, p3);
        this.output("   ]\n");
        this.output("  }\n");
        this.output("  coordIndex [\n");
        int[] nArray2 = new int[n];
        this.getCoordinateMap(t3Array, nArray2, null);
        this.outputIndices(nArray, nArray2, n2, bS, n3);
        this.output("  ]\n");
        if (t3Array2 != null) {
            Lst<String> lst2 = new Lst<String>();
            nArray2 = this.getNormalMap(t3Array2, n, null, lst2);
            this.output("  solid FALSE\n  normalPerVertex TRUE\n   normal Normal {\n  vector [\n");
            this.outputNormals(lst2);
            this.output("   ]\n");
            this.output("  }\n");
            this.output("  normalIndex [\n");
            this.outputIndices(nArray, nArray2, n2, bS, n3);
            this.output("  ]\n");
        }
        nArray2 = null;
        if (lst != null) {
            this.output("  color Color { color [\n");
            this.outputColors(lst);
            this.output("  ] } \n");
            this.output("  colorIndex [\n");
            this.outputColorIndices(nArray, n2, bS, n3, map, sArray, sArray2);
            this.output("  ]\n");
        }
    }

    @Override
    protected void outputFace(int[] nArray, int[] nArray2, int n) {
        this.output(String.valueOf(nArray2[nArray[0]]) + " " + nArray2[nArray[1]] + " " + nArray2[nArray[2]] + " -1\n");
        if (n == 4 && nArray.length == 4) {
            this.output(String.valueOf(nArray2[nArray[0]]) + " " + nArray2[nArray[2]] + " " + nArray2[nArray[3]] + " -1\n");
        }
    }

    protected void outputNormals(Lst<String> lst) {
        int n = lst.size();
        int n2 = 0;
        while (n2 < n) {
            this.output((String)lst.get(n2));
            ++n2;
        }
    }

    protected void outputColors(Lst<Short> lst) {
        int n = lst.size();
        int n2 = 0;
        while (n2 < n) {
            String string = this.rgbFractionalFromColix((Short)lst.get(n2));
            this.output(" ");
            this.output(string);
            this.output("\n");
            ++n2;
        }
    }

    protected void outputColorIndices(int[][] nArray, int n, BS bS, int n2, Map<Short, Integer> map, short[] sArray, short[] sArray2) {
        int n3;
        boolean bl = bS == null;
        int n4 = n3 = bl ? n - 1 : bS.nextSetBit(0);
        while (n4 >= 0) {
            if (sArray2 == null) {
                this.output(map.get(sArray[nArray[n4][0]]) + " " + map.get(sArray[nArray[n4][1]]) + " " + map.get(sArray[nArray[n4][2]]) + " -1\n");
                if (n2 == 4 && nArray[n4].length == 4) {
                    this.output(map.get(sArray[nArray[n4][0]]) + " " + map.get(sArray[nArray[n4][2]]) + " " + map.get(sArray[nArray[n4][3]]) + " -1\n");
                }
            } else {
                this.output(map.get(sArray2[n4]) + "\n");
            }
            int n5 = n4 = bl ? n4 - 1 : bS.nextSetBit(n4 + 1);
        }
    }

    @Override
    protected void outputTriangle(T3 t3, T3 t32, T3 t33, short s) {
        this.output("Shape{geometry IndexedFaceSet{ ");
        this.outputTriangleGeometry(t3, t32, t33, s);
        this.output("}\n");
        this.outputAppearance(s, false);
        this.output("}\n");
    }

    private void outputTriangleGeometry(T3 t3, T3 t32, T3 t33, short s) {
        if (this.oneFace == null) {
            int[][] nArrayArray = new int[1][];
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            nArrayArray[0] = nArray;
            this.oneFace = nArrayArray;
            this.threeVertices = new P3[]{this.tempP1, this.tempP2, this.tempP3};
        }
        this.threeVertices[0].setT(t3);
        this.threeVertices[1].setT(t32);
        this.threeVertices[2].setT(t33);
        this.outputGeometry(this.threeVertices, null, null, this.oneFace, null, 3, 1, null, 3, null, null, null);
    }

    @Override
    protected void outputTextPixel(P3 p3, int n) {
    }

    @Override
    void plotText(int n, int n2, int n3, short s, String string, Font font) {
        this.pushMatrix();
        this.tempP3.set(n, n2, this.fixScreenZ(n3));
        this.tm.unTransformPoint(this.tempP3, this.tempP1);
        this.outputAttrPt("translation", this.tempP1);
        this.setFont(s, string, font);
        this.outputChildStart();
        if (this.fontChild.charAt(0) == '_') {
            this.output("DEF " + this.fontChild + " Billboard{");
            this.outputAttr("axisOfRotation", 0.0f, 0.0f, 0.0f);
            this.outputChildStart();
            this.pushMatrix();
            this.outputChildShapeStart();
            this.output("Text{fontStyle ");
            String string2 = this.getDef("F" + this.fontFace + this.fontStyle);
            if (string2.charAt(0) == '_') {
                this.output("DEF " + string2 + " FontStyle{size " + this.fontSize + " family \"" + this.fontFace + "\" style \"" + this.fontStyle + "\"}");
            } else {
                this.output(string2);
            }
            this.output(" string " + PT.esc(string) + "}");
            this.outputAppearance(s, true);
            this.outputChildShapeClose();
            this.popMatrix();
            this.outputChildClose();
            this.output("}");
        } else {
            this.output(this.fontChild);
        }
        this.outputChildClose();
        this.popMatrix();
    }

    private void setFont(short s, String string, Font font) {
        this.fontStyle = font.fontStyle.toUpperCase();
        this.fontFace = font.fontFace.toUpperCase();
        this.fontFace = this.fontFace.equals("MONOSPACED") ? "TYPEWRITER" : (this.fontFace.equals("SERIF") ? "SERIF" : "Arial");
        this.fontSize = font.fontSize * 0.015f;
        this.fontChild = this.getDef("T" + s + this.fontFace + this.fontStyle + this.fontSize + "_" + string);
    }

    protected String getDef(String string) {
        return this.useTable == null ? "_" : this.useTable.getDef(string);
    }
}

