/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.javadoc;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTagValue;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class JavaDocUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.javadoc.JavaDocUtil");
    @NonNls
    private static final Pattern ourTypePattern = Pattern.compile("[ ]+[^ ^\\[^\\]]");

    @Nullable
    public static PsiClass resolveClassInTagValue(@Nullable PsiDocTagValue value) {
        PsiElement target;
        PsiElement refElement;
        if (value == null) {
            return null;
        }
        PsiElement refHolder = value.getFirstChild();
        if (refHolder != null && (refElement = refHolder.getFirstChild()) instanceof PsiJavaCodeReferenceElement && (target = ((PsiJavaCodeReferenceElement)refElement).resolve()) instanceof PsiClass) {
            return (PsiClass)target;
        }
        return null;
    }

    public static boolean isInsidePackageInfo(@Nullable PsiDocComment containingComment) {
        return containingComment != null && containingComment.getOwner() == null && containingComment.getParent() instanceof PsiJavaFile;
    }
}

