/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.io.IOException;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.SimpleBindings;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.script.GeneralScriptException;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.script.expression.ReplaceableConstDoubleValueSource;

class ExpressionSearchScript
implements SearchScript.LeafFactory {
    final Expression exprScript;
    final SimpleBindings bindings;
    final DoubleValuesSource source;
    final ReplaceableConstDoubleValueSource specialValue;
    final boolean needsScores;
    Scorer scorer;
    int docid;

    ExpressionSearchScript(Expression e, SimpleBindings b, ReplaceableConstDoubleValueSource v, boolean needsScores) {
        this.exprScript = e;
        this.bindings = b;
        this.source = this.exprScript.getDoubleValuesSource((Bindings)this.bindings);
        this.specialValue = v;
        this.needsScores = needsScores;
    }

    public boolean needs_score() {
        return this.needsScores;
    }

    public SearchScript newInstance(final LeafReaderContext leaf) throws IOException {
        return new SearchScript(null, null, null){
            DoubleValues values;
            {
                super(arg0, arg1, arg2);
                this.values = ExpressionSearchScript.this.source.getValues(leaf, new DoubleValues(){

                    public double doubleValue() throws IOException {
                        return this.getScore();
                    }

                    public boolean advanceExact(int doc) throws IOException {
                        return true;
                    }
                });
            }

            public Object run() {
                return this.runAsDouble();
            }

            public long runAsLong() {
                return (long)this.runAsDouble();
            }

            public double runAsDouble() {
                try {
                    return this.values.doubleValue();
                }
                catch (Exception exception) {
                    throw new GeneralScriptException("Error evaluating " + ExpressionSearchScript.this.exprScript, (Throwable)exception);
                }
            }

            public void setDocument(int d) {
                try {
                    this.values.advanceExact(d);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can't advance to doc using " + ExpressionSearchScript.this.exprScript, e);
                }
            }

            public void setNextAggregationValue(Object value) {
                if (ExpressionSearchScript.this.specialValue != null) {
                    if (value instanceof Number) {
                        ExpressionSearchScript.this.specialValue.setValue(((Number)value).doubleValue());
                    } else {
                        throw new GeneralScriptException("Cannot use expression with text variable using " + ExpressionSearchScript.this.exprScript);
                    }
                }
            }

            public void setNextVar(String name, Object value) {
            }
        };
    }
}

