// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `Locator.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package Ice;

/**
 * The Ice locator registry interface. This interface is used by
 * servers to register adapter endpoints with the locator.
 *
 * <p class="Note"> The {@link LocatorRegistry} interface is intended to be used
 * by Ice internals and by locator implementations. Regular user
 * code should not attempt to use any functionality of this interface
 * directly.
 *
 **/
public interface _LocatorRegistryOperations
{
    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param cb The callback object for the operation.
     * @param id The adapter id.
     *
     * @param proxy The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @param current The Current object for the invocation.
     * @throws AdapterNotFoundException Raised if the adapter cannot
     * be found, or if the locator only allows
     * registered adapters to set their active proxy and the
     * adapter is not registered with the locator.
     *
     * @throws AdapterAlreadyActiveException Raised if an adapter with the same
     * id is already active.
     *
     **/
    void setAdapterDirectProxy_async(AMD_LocatorRegistry_setAdapterDirectProxy cb, String id, Ice.ObjectPrx proxy, Current current)
        throws AdapterAlreadyActiveException,
               AdapterNotFoundException;

    /**
     * Set the adapter endpoints with the locator registry.
     *
     * @param cb The callback object for the operation.
     * @param adapterId The adapter id.
     *
     * @param replicaGroupId The replica group id.
     *
     * @param p The adapter proxy (a dummy direct proxy created
     * by the adapter). The direct proxy contains the adapter
     * endpoints.
     *
     * @param current The Current object for the invocation.
     * @throws AdapterNotFoundException Raised if the adapter cannot
     * be found, or if the locator only allows registered adapters to
     * set their active proxy and the adapter is not registered with
     * the locator.
     *
     * @throws AdapterAlreadyActiveException Raised if an adapter with the same
     * id is already active.
     *
     * @throws InvalidReplicaGroupIdException Raised if the given
     * replica group doesn't match the one registered with the
     * locator registry for this object adapter.
     *
     **/
    void setReplicatedAdapterDirectProxy_async(AMD_LocatorRegistry_setReplicatedAdapterDirectProxy cb, String adapterId, String replicaGroupId, Ice.ObjectPrx p, Current current)
        throws AdapterAlreadyActiveException,
               AdapterNotFoundException,
               InvalidReplicaGroupIdException;

    /**
     * Set the process proxy for a server.
     *
     * @param cb The callback object for the operation.
     * @param id The server id.
     *
     * @param proxy The process proxy.
     *
     * @param current The Current object for the invocation.
     * @throws ServerNotFoundException Raised if the server cannot
     * be found.
     *
     **/
    void setServerProcessProxy_async(AMD_LocatorRegistry_setServerProcessProxy cb, String id, ProcessPrx proxy, Current current)
        throws ServerNotFoundException;
}
