/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc;

import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NameDefinition
implements OfficeConstants {
    private String name;
    private String definition;
    private String baseCellAddress;
    private boolean rangeType = false;
    private boolean expressionType = false;

    public NameDefinition() {
    }

    public NameDefinition(Node root) {
        this.readNode(root);
    }

    public NameDefinition(String name, String definition, String baseCellAddress, boolean rangeType, boolean expressionType) {
        this.name = name;
        this.definition = definition;
        this.baseCellAddress = baseCellAddress;
        this.rangeType = rangeType;
        this.expressionType = expressionType;
    }

    private String getName() {
        return this.name;
    }

    public void setDefinition(String newDefinition) {
        this.definition = newDefinition;
    }

    private String getDefinition() {
        return this.definition;
    }

    private String getBaseCellAddress() {
        return this.baseCellAddress;
    }

    private boolean isExpressionType() {
        return this.expressionType;
    }

    private boolean isRangeType() {
        return this.rangeType;
    }

    public void writeNode(Document doc, Node root) {
        if (this.isRangeType()) {
            Debug.log(4, "Found Range Name : " + this.getName());
            Element namedRangeElement = doc.createElement("table:named-range");
            namedRangeElement.setAttribute("table:name", this.getName());
            namedRangeElement.setAttribute("table:base-cell-address", this.getBaseCellAddress());
            namedRangeElement.setAttribute("table:cell-range-address", this.getDefinition());
            root.appendChild(namedRangeElement);
        } else if (this.isExpressionType()) {
            Debug.log(4, "Found Expression Name : " + this.getName());
            Element namedExpressionElement = doc.createElement("table:named-expression");
            namedExpressionElement.setAttribute("table:name", this.getName());
            namedExpressionElement.setAttribute("table:base-cell-address", this.getBaseCellAddress());
            namedExpressionElement.setAttribute("table:expression", this.getDefinition());
            root.appendChild(namedExpressionElement);
        } else {
            Debug.log(4, "Unknown Name Definition : " + this.getName());
        }
    }

    private void readNode(Node root) {
        String nodeName = root.getNodeName();
        NamedNodeMap cellAtt = root.getAttributes();
        if (nodeName.equals("table:named-range")) {
            Node tableNameNode = cellAtt.getNamedItem("table:name");
            Node tableBaseCellAddress = cellAtt.getNamedItem("table:base-cell-address");
            Node tableCellRangeAddress = cellAtt.getNamedItem("table:cell-range-address");
            Debug.log(4, "Named-range : " + tableNameNode.getNodeValue());
            this.name = tableNameNode.getNodeValue();
            this.definition = tableCellRangeAddress.getNodeValue();
            this.baseCellAddress = tableBaseCellAddress.getNodeValue();
            this.expressionType = true;
            this.rangeType = false;
        } else if (nodeName.equals("table:named-expression")) {
            Node tableNameNode = cellAtt.getNamedItem("table:name");
            Node tableBaseCellAddress = cellAtt.getNamedItem("table:base-cell-address");
            Node tableExpression = cellAtt.getNamedItem("table:expression");
            Debug.log(4, "Named-expression: " + tableNameNode.getNodeValue());
            this.name = tableNameNode.getNodeValue();
            this.definition = tableExpression.getNodeValue();
            this.baseCellAddress = tableBaseCellAddress.getNodeValue();
            this.expressionType = false;
            this.rangeType = true;
        } else {
            Debug.log(4, "<OTHERS " + XmlUtil.getNodeInfo(root) + " />");
        }
    }
}

