/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.features;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.filters.TextFilter;
import org.netbeans.lib.profiler.results.jdbc.JdbcCCTProvider;
import org.netbeans.lib.profiler.ui.swing.TextArea;
import org.netbeans.modules.profiler.v2.features.Bundle;
import org.netbeans.modules.profiler.v2.features.FeatureMode;
import org.netbeans.modules.profiler.v2.ui.SettingsPanel;
import org.openide.util.NbPreferences;

class SQLFeatureModes {
    SQLFeatureModes() {
    }

    static abstract class FilteredQueriesMode
    extends SQLMode {
        private static final String QUERIES_FILTER_FLAG = "QUERIES_FILTER_FLAG";
        private static final int MIN_ROWS = 1;
        private static final int MAX_ROWS = 15;
        private static final int DEFAULT_ROWS = 3;
        private static final int MIN_COLUMNS = 10;
        private static final int MAX_COLUMNS = 100;
        private static final int DEFAULT_COLUMNS = 50;
        private JComponent ui;
        private TextArea filterArea;

        FilteredQueriesMode() {
        }

        @Override
        String getID() {
            return "FilteredQueriesMode";
        }

        @Override
        String getName() {
            return Bundle.SQLFeatureModes_filteredQueries();
        }

        @Override
        void configureSettings(ProfilingSettings profilingSettings) {
            super.configureSettings(profilingSettings);
            String string = FilteredQueriesMode.getFlatValues(this.readFlag(QUERIES_FILTER_FLAG, "").split("\\n"));
            profilingSettings.setInstrumentationFilter((GenericFilter)new TextFilter(string, 10, false));
        }

        @Override
        void confirmSettings() {
            if (this.ui != null && this.filterArea != null) {
                assert (SwingUtilities.isEventDispatchThread());
                String string = this.filterArea.showsHint() ? "" : this.filterArea.getText().trim();
                this.storeFlag(QUERIES_FILTER_FLAG, string.isEmpty() ? null : string);
            }
        }

        @Override
        boolean pendingChanges() {
            if (this.ui != null) {
                String string;
                assert (SwingUtilities.isEventDispatchThread());
                String string2 = string = this.filterArea.showsHint() ? "" : this.filterArea.getText().trim();
                if (!string.equals(this.readFlag(QUERIES_FILTER_FLAG, ""))) {
                    return true;
                }
            }
            return false;
        }

        @Override
        boolean currentSettingsValid() {
            assert (SwingUtilities.isEventDispatchThread());
            return !(this.ui != null ? this.filterArea.showsHint() || this.filterArea.getText().trim().isEmpty() : this.readFlag(QUERIES_FILTER_FLAG, "").isEmpty());
        }

        private static String getFlatValues(String[] stringArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i].trim();
                if (i != stringArray.length - 1 && !string.endsWith(",")) {
                    string = string + ",";
                }
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }

        @Override
        JComponent getUI() {
            if (this.ui == null) {
                JPanel jPanel = new JPanel(new GridBagLayout());
                jPanel.setOpaque(false);
                SettingsPanel settingsPanel = new SettingsPanel();
                settingsPanel.add(new JLabel(Bundle.SQLFeatureModes_queryContains()));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 5);
                gridBagConstraints.anchor = 18;
                jPanel.add((Component)settingsPanel, gridBagConstraints);
                final JScrollPane[] jScrollPaneArray = new JScrollPane[1];
                this.filterArea = new TextArea(this.readFlag(QUERIES_FILTER_FLAG, "")){

                    protected void changed() {
                        FilteredQueriesMode.this.settingsChanged();
                    }

                    protected boolean changeSize(boolean bl, boolean bl2) {
                        if (bl) {
                            int n = FilteredQueriesMode.this.readRows();
                            n = bl2 ? Math.min(n + 1, 15) : Math.max(n - 1, 1);
                            FilteredQueriesMode.this.storeRows(n);
                        } else {
                            int n = FilteredQueriesMode.this.readColumns();
                            n = bl2 ? Math.min(n + 3, 100) : Math.max(n - 3, 10);
                            FilteredQueriesMode.this.storeColumns(n);
                        }
                        this.layoutImpl();
                        return true;
                    }

                    protected boolean resetSize() {
                        FilteredQueriesMode.this.storeRows(3);
                        FilteredQueriesMode.this.storeColumns(50);
                        this.layoutImpl();
                        return true;
                    }

                    private void layoutImpl() {
                        this.setRows(FilteredQueriesMode.this.readRows());
                        this.setColumns(FilteredQueriesMode.this.readColumns());
                        jScrollPaneArray[0].setPreferredSize(null);
                        jScrollPaneArray[0].setPreferredSize(jScrollPaneArray[0].getPreferredSize());
                        jScrollPaneArray[0].setMinimumSize(jScrollPaneArray[0].getPreferredSize());
                        JRootPane jRootPane = SwingUtilities.getRootPane(jScrollPaneArray[0]);
                        jRootPane.doLayout();
                        jRootPane.repaint();
                        this.setColumns(0);
                    }

                    protected void customizePopup(JPopupMenu jPopupMenu) {
                        jPopupMenu.addSeparator();
                        jPopupMenu.add(this.createResizeMenu());
                    }

                    public Point getToolTipLocation(MouseEvent mouseEvent) {
                        Container container = this.getParent().getParent();
                        return SwingUtilities.convertPoint(container, 0, container.getHeight(), (Component)((Object)this));
                    }
                };
                this.filterArea.setFont(new Font("Monospaced", 0, this.filterArea.getFont().getSize()));
                this.filterArea.setRows(this.readRows());
                this.filterArea.setColumns(this.readColumns());
                jScrollPaneArray[0] = new JScrollPane((Component)this.filterArea);
                jScrollPaneArray[0].setPreferredSize(jScrollPaneArray[0].getPreferredSize());
                jScrollPaneArray[0].setMinimumSize(jScrollPaneArray[0].getPreferredSize());
                this.filterArea.setColumns(0);
                this.filterArea.setHint(Bundle.SQLFeatureModes_filterHint());
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 3;
                gridBagConstraints.insets = new Insets(0, 0, 0, 5);
                gridBagConstraints.anchor = 18;
                jPanel.add((Component)jScrollPaneArray[0], gridBagConstraints);
                this.ui = jPanel;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FilteredQueriesMode.this.settingsChanged();
                    }
                });
            }
            return this.ui;
        }

        private int readRows() {
            return NbPreferences.forModule(SQLFeatureModes.class).getInt("SQLFeatureModes.rows", 3);
        }

        private void storeRows(int n) {
            NbPreferences.forModule(SQLFeatureModes.class).putInt("SQLFeatureModes.rows", n);
        }

        private int readColumns() {
            return NbPreferences.forModule(SQLFeatureModes.class).getInt("SQLFeatureModes.columns", 50);
        }

        private void storeColumns(int n) {
            NbPreferences.forModule(SQLFeatureModes.class).putInt("SQLFeatureModes.columns", n);
        }
    }

    static abstract class AllQueriesMode
    extends SQLMode {
        AllQueriesMode() {
        }

        @Override
        String getID() {
            return "AllQueriesMode";
        }

        @Override
        String getName() {
            return Bundle.SQLFeatureModes_allQueries();
        }

        @Override
        void configureSettings(ProfilingSettings profilingSettings) {
            super.configureSettings(profilingSettings);
            profilingSettings.setInstrumentationFilter((GenericFilter)new TextFilter());
        }

        @Override
        void confirmSettings() {
        }

        @Override
        boolean pendingChanges() {
            return false;
        }

        @Override
        boolean currentSettingsValid() {
            return true;
        }

        @Override
        JComponent getUI() {
            return null;
        }
    }

    private static abstract class SQLMode
    extends FeatureMode {
        private static final String[] JDBC_MARKER_CLASSES = new String[]{JdbcCCTProvider.DRIVER_INTERFACE, JdbcCCTProvider.CONNECTION_INTERFACE, JdbcCCTProvider.STATEMENT_INTERFACE, JdbcCCTProvider.PREPARED_STATEMENT_INTERFACE, JdbcCCTProvider.CALLABLE_STATEMENT_INTERFACE};

        private SQLMode() {
        }

        @Override
        void configureSettings(ProfilingSettings profilingSettings) {
            profilingSettings.setProfilingType(256);
            profilingSettings.setCPUProfilingType(0);
            ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = new ClientUtils.SourceCodeSelection[JDBC_MARKER_CLASSES.length];
            for (int i = 0; i < JDBC_MARKER_CLASSES.length; ++i) {
                sourceCodeSelectionArray[i] = new ClientUtils.SourceCodeSelection(JDBC_MARKER_CLASSES[i], "*", null);
                sourceCodeSelectionArray[i].setMarkerMethod(true);
            }
            profilingSettings.addRootMethods(sourceCodeSelectionArray);
        }
    }
}

