/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.api;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class GestureSubmitter {
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.profiler");

    public static void logProfileApp(Lookup.Provider provider, ProfilingSettings profilingSettings) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        GestureSubmitter.fillProjectParam(provider, arrayList);
        GestureSubmitter.fillParamsForProfiling(profilingSettings, arrayList);
        GestureSubmitter.logUsage("PROFILE_APP", arrayList);
    }

    public static void logAttachApp(Lookup.Provider provider, ProfilingSettings profilingSettings, AttachSettings attachSettings) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        GestureSubmitter.fillProjectParam(provider, arrayList);
        GestureSubmitter.fillParamsForProfiling(profilingSettings, arrayList);
        GestureSubmitter.fillParamsForAttach(attachSettings, arrayList);
        GestureSubmitter.logUsage("ATTACH_APP", arrayList);
    }

    public static void logAttachExternal(ProfilingSettings profilingSettings, AttachSettings attachSettings) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        GestureSubmitter.fillParamsForProfiling(profilingSettings, arrayList);
        GestureSubmitter.fillParamsForAttach(attachSettings, arrayList);
        GestureSubmitter.logUsage("ATTACH_EXT", arrayList);
    }

    private static void fillProjectParam(Lookup.Provider provider, List<Object> list) {
        String string = "";
        if (provider != null) {
            string = provider.getClass().getName();
        }
        list.add(0, string);
    }

    private static void fillParamsForAttach(AttachSettings attachSettings, List<Object> list) {
        list.add(attachSettings.isDirect() ? "ATTACH_DIRECT" : "ATTACH_DYNAMIC");
        list.add(attachSettings.isRemote() ? "ATTACH_REMOTE" : "ATTACH_LOCAL");
    }

    private static void fillParamsForProfiling(ProfilingSettings profilingSettings, List<Object> list) {
        switch (profilingSettings.getProfilingType()) {
            case 8: {
                list.add("TYPE_CPU_ENTIRE");
                break;
            }
            case 16: {
                list.add("TYPE_CPU_PART");
                break;
            }
            case 256: {
                list.add("TYPE_CPU_JDBC");
                break;
            }
            case 64: {
                list.add("TYPE_CPU_SAMPLING");
                break;
            }
            case 32: {
                list.add("TYPE_CPU_STOPWATCH");
                break;
            }
            case 2: {
                list.add("TYPE_MEM_ALLOC");
                break;
            }
            case 4: {
                list.add("TYPE_MEM_LIVENESS");
                break;
            }
            case 128: {
                list.add("TYPE_MEM_SAMPLING");
                break;
            }
            case 1: {
                list.add("TYPE_MONITOR");
            }
        }
        if (profilingSettings.getThreadsMonitoringEnabled()) {
            list.add("TYPE_THREADS");
        }
        if (profilingSettings.getLockContentionMonitoringEnabled()) {
            list.add("TYPE_LOCKS");
        }
    }

    private static void logUsage(String string, List<Object> list) {
        LogRecord logRecord = new LogRecord(Level.INFO, "USG_PROFILER_" + string);
        logRecord.setResourceBundle(NbBundle.getBundle(GestureSubmitter.class));
        logRecord.setResourceBundleName(GestureSubmitter.class.getPackage().getName() + ".Bundle");
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setParameters(list.toArray(new Object[0]));
        USG_LOGGER.log(logRecord);
    }
}

