/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.data.Config;
import esmska.data.History;
import esmska.data.Icons;
import esmska.data.event.AbstractDocumentListener;
import esmska.data.event.ValuedEventSupport;
import esmska.data.event.ValuedListener;
import esmska.gui.ClipboardPopupMenu;
import esmska.gui.ThemeManager;
import esmska.utils.L10N;
import esmska.utils.RuntimeUtils;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import org.openide.awt.Mnemonics;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTableCellRenderer;

public class HistoryFrame
extends JFrame {
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static final Logger logger = Logger.getLogger(HistoryFrame.class.getName());
    private static final Config config = Config.getInstance();
    private DateFormat df = DateFormat.getDateTimeInstance(3, 2);
    private History history = History.getInstance();
    private HistoryTableModel historyTableModel = new HistoryTableModel();
    private TableRowSorter<HistoryTableModel> historyTableSorter = new TableRowSorter<HistoryTableModel>(this.historyTableModel);
    private HistoryRowFilter historyTableFilter = new HistoryRowFilter();
    private Action deleteAction = new DeleteAction();
    private Action resendAction = new ResendAction();
    private History.Record selectedHistory;
    private ValuedEventSupport<Events, History.Record> valuedSupport = new ValuedEventSupport(this);
    private JButton clearButton;
    private JButton closeButton;
    private JLabel dateLabel;
    private JButton deleteButton;
    private JLabel gatewayLabel;
    private JTable historyTable;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JLabel nameLabel;
    private JLabel numberLabel;
    private JButton resendButton;
    private JTextField searchField;
    private JLabel searchLabel;
    private JLabel senderNameLabel;
    private JLabel senderNumberLabel;
    private JTextArea textArea;

    public void addValuedListener(ValuedListener<Events, History.Record> valuedListener) {
        this.valuedSupport.addValuedListener(valuedListener);
    }

    public void removeValuedListener(ValuedListener<Events, History.Record> valuedListener) {
        this.valuedSupport.removeValuedListener(valuedListener);
    }

    public HistoryFrame() {
        this.initComponents();
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(Icons.get("history-16.png").getImage());
        images.add(Icons.get("history-32.png").getImage());
        images.add(Icons.get("history-48.png").getImage());
        this.setIconImages(images);
        String command = "close";
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), command);
        this.getRootPane().getActionMap().put(command, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryFrame.this.closeButtonActionPerformed(e);
            }
        });
        if (!config.getLookAndFeel().equals((Object)ThemeManager.LAF.SUBSTANCE)) {
            ClipboardPopupMenu.register(this.searchField);
            ClipboardPopupMenu.register(this.textArea);
        }
        if (this.historyTableModel.getRowCount() > 0) {
            this.historyTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.history.addActionListener(new HistoryActionListener());
    }

    private void initComponents() {
        this.deleteButton = new JButton();
        this.resendButton = new JButton();
        this.closeButton = new JButton();
        this.searchField = new JTextField();
        this.searchLabel = new JLabel();
        this.clearButton = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.historyTable = new JTable();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.dateLabel = new JLabel();
        this.nameLabel = new JLabel();
        this.numberLabel = new JLabel();
        this.gatewayLabel = new JLabel();
        this.senderNumberLabel = new JLabel();
        this.senderNameLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.textArea = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.setTitle(l10n.getString("HistoryFrame.title"));
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                HistoryFrame.this.formWindowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
            }
        });
        this.deleteButton.setAction(this.deleteAction);
        this.resendButton.setAction(this.resendAction);
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/close-22.png")));
        Mnemonics.setLocalizedText(this.closeButton, l10n.getString("Close_"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryFrame.this.closeButtonActionPerformed(evt);
            }
        });
        this.searchField.setColumns(15);
        this.searchField.setToolTipText(l10n.getString("HistoryFrame.searchField.toolTipText"));
        this.searchField.getDocument().addDocumentListener(new AbstractDocumentListener(){

            @Override
            public void onUpdate(DocumentEvent e) {
                HistoryFrame.this.historyTableFilter.requestUpdate();
            }
        });
        this.searchField.putClientProperty("JTextField.variant", "search");
        String command = "clear";
        this.searchField.getInputMap().put(KeyStroke.getKeyStroke(27, 0), command);
        this.searchField.getActionMap().put(command, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryFrame.this.searchField.setText(null);
            }
        });
        command = "focus search field";
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), command);
        this.getRootPane().getActionMap().put(command, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryFrame.this.searchField.requestFocusInWindow();
                HistoryFrame.this.searchFieldFocusGained(null);
            }
        });
        this.searchField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                HistoryFrame.this.searchFieldFocusGained(evt);
            }
        });
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                HistoryFrame.this.searchFieldKeyPressed(evt);
            }
        });
        this.searchLabel.setLabelFor(this.searchField);
        Mnemonics.setLocalizedText(this.searchLabel, l10n.getString("HistoryFrame.searchLabel.text"));
        this.searchLabel.setToolTipText(this.searchField.getToolTipText());
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/clear-22.png")));
        this.clearButton.setMnemonic('r');
        this.clearButton.setToolTipText(l10n.getString("HistoryFrame.clearButton.toolTipText"));
        this.clearButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        if (RuntimeUtils.isMac() && config.getLookAndFeel().equals((Object)ThemeManager.LAF.SYSTEM)) {
            this.clearButton.setVisible(false);
        }
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryFrame.this.clearButtonActionPerformed(evt);
            }
        });
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jSplitPane1.setContinuousLayout(true);
        this.historyTable.setModel(this.historyTableModel);
        this.historyTable.setDefaultRenderer(Date.class, new TableDateRenderer());
        this.historyTable.getSelectionModel().addListSelectionListener(new HistoryTableListener());
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.DESCENDING));
        this.historyTableSorter.setSortKeys(sortKeys);
        this.historyTable.setRowSorter(this.historyTableSorter);
        this.historyTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                HistoryFrame.this.historyTableMouseClicked(evt);
            }
        });
        this.historyTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                HistoryFrame.this.historyTableKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.historyTable);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        Mnemonics.setLocalizedText(this.jLabel2, l10n.getString("HistoryFrame.jLabel2.text"));
        Mnemonics.setLocalizedText(this.jLabel1, l10n.getString("HistoryFrame.jLabel1.text"));
        Mnemonics.setLocalizedText(this.jLabel3, l10n.getString("HistoryFrame.jLabel3.text"));
        Mnemonics.setLocalizedText(this.jLabel4, l10n.getString("HistoryFrame.jLabel4.text"));
        Mnemonics.setLocalizedText(this.jLabel5, l10n.getString("HistoryFrame.jLabel5.text"));
        Mnemonics.setLocalizedText(this.jLabel6, l10n.getString("HistoryFrame.jLabel6.text"));
        Mnemonics.setLocalizedText(this.dateLabel, "    ");
        this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(this.nameLabel.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText(this.nameLabel, "    ");
        Mnemonics.setLocalizedText(this.numberLabel, "    ");
        Mnemonics.setLocalizedText(this.gatewayLabel, "    ");
        Mnemonics.setLocalizedText(this.senderNumberLabel, "    ");
        Mnemonics.setLocalizedText(this.senderNameLabel, "    ");
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.textArea);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gatewayLabel)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dateLabel)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameLabel)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.numberLabel)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.senderNumberLabel)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.senderNameLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane2, -1, 396, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, this.jLabel1, this.jLabel2, this.jLabel3, this.jLabel4, this.jLabel5, this.jLabel6);
        jPanel1Layout.linkSize(0, this.dateLabel, this.gatewayLabel, this.nameLabel, this.numberLabel, this.senderNameLabel, this.senderNumberLabel);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.dateLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.nameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.numberLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.gatewayLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.senderNumberLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.senderNameLabel))).addComponent(this.jScrollPane2, -1, 120, Short.MAX_VALUE));
        this.jSplitPane1.setRightComponent(this.jPanel1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jSplitPane1, -1, 533, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.closeButton).addComponent(this.resendButton).addComponent(this.deleteButton))).addGroup(layout.createSequentialGroup().addComponent(this.searchLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearButton))).addContainerGap()));
        layout.linkSize(0, this.closeButton, this.deleteButton, this.resendButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchField, -2, -1, -2).addComponent(this.searchLabel)).addComponent(this.clearButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.resendButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 336, Short.MAX_VALUE).addComponent(this.closeButton)).addComponent(this.jSplitPane1, -1, 444, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(1, this.closeButton, this.deleteButton, this.resendButton);
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void historyTableMouseClicked(MouseEvent evt) {
        if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() >= 2) {
            this.resendButton.doClick(0);
        }
    }

    private void historyTableKeyPressed(KeyEvent evt) {
        switch (evt.getKeyCode()) {
            case 10: {
                evt.consume();
                this.resendButton.doClick(0);
                break;
            }
            case 127: {
                this.deleteButton.doClick(0);
            }
        }
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.searchField.setText(null);
        this.searchField.requestFocusInWindow();
    }

    private void searchFieldFocusGained(FocusEvent evt) {
        this.searchField.selectAll();
    }

    private void searchFieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 40 || evt.getKeyCode() == 38) {
            this.historyTable.requestFocusInWindow();
            this.historyTable.dispatchEvent(evt);
        }
    }

    private void formWindowGainedFocus(WindowEvent evt) {
        this.historyTable.requestFocusInWindow();
    }

    private class HistoryRowFilter
    extends RowFilter<HistoryTableModel, Integer> {
        private Timer timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryFrame.this.historyTableSorter.setRowFilter(HistoryRowFilter.this);
                if (HistoryFrame.this.historyTable.getRowCount() > 0) {
                    HistoryFrame.this.historyTable.changeSelection(0, 0, false, false);
                    HistoryFrame.this.historyTable.scrollRectToVisible(HistoryFrame.this.historyTable.getCellRect(0, 0, true));
                }
            }
        });

        public HistoryRowFilter() {
            this.timer.setRepeats(false);
        }

        @Override
        public boolean include(RowFilter.Entry<? extends HistoryTableModel, ? extends Integer> entry) {
            History.Record record = HistoryFrame.this.history.getRecord(entry.getIdentifier());
            String pattern = HistoryFrame.this.searchField.getText().toLowerCase();
            if (record.getText() != null && record.getText().toLowerCase().contains(pattern)) {
                return true;
            }
            if (record.getNumber() != null && record.getNumber().toLowerCase().contains(pattern)) {
                return true;
            }
            if (record.getName() != null && record.getName().toLowerCase().contains(pattern)) {
                return true;
            }
            return record.getDate() != null && HistoryFrame.this.df.format(record.getDate()).toLowerCase().contains(pattern);
        }

        public void requestUpdate() {
            this.timer.restart();
        }
    }

    private class TableDateRenderer
    extends SubstanceDefaultTableCellRenderer {
        private final ImageIcon icon = Icons.get("message-16.png");

        private TableDateRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel label = (JLabel)comp;
            label.setText(HistoryFrame.this.df.format(value));
            label.setIcon(this.icon);
            return label;
        }
    }

    private class HistoryTableListener
    implements ListSelectionListener {
        private HistoryTableListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int index = HistoryFrame.this.historyTable.getSelectedRow();
            boolean selected = index >= 0;
            HistoryFrame.this.deleteAction.setEnabled(selected);
            HistoryFrame.this.resendAction.setEnabled(selected);
            History.Record record = null;
            if (selected) {
                index = HistoryFrame.this.historyTable.getRowSorter().convertRowIndexToModel(index);
                record = HistoryFrame.this.history.getRecord(index);
            }
            HistoryFrame.this.dateLabel.setText(selected ? HistoryFrame.this.df.format(record.getDate()) : null);
            HistoryFrame.this.nameLabel.setText(selected ? record.getName() : null);
            HistoryFrame.this.numberLabel.setText(selected ? record.getNumber() : null);
            HistoryFrame.this.gatewayLabel.setText(selected ? record.getGateway() : null);
            HistoryFrame.this.senderNameLabel.setText(selected ? record.getSenderName() : null);
            HistoryFrame.this.senderNumberLabel.setText(selected ? record.getSenderNumber() : null);
            HistoryFrame.this.textArea.setText(selected ? record.getText() : null);
            HistoryFrame.this.textArea.setCaretPosition(0);
            HistoryFrame.this.selectedHistory = record;
        }
    }

    private class HistoryTableModel
    extends AbstractTableModel {
        private HistoryTableModel() {
        }

        @Override
        public int getRowCount() {
            return HistoryFrame.this.history.getRecords().size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            History.Record record = HistoryFrame.this.history.getRecord(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return record.getDate();
                }
                case 1: {
                    String name = record.getName();
                    return name != null && !name.equals("") ? name : record.getNumber();
                }
                case 2: {
                    return record.getText().replaceAll("\n+", " ");
                }
            }
            logger.warning("Index out of bounds!");
            return null;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return l10n.getString("Date");
                }
                case 1: {
                    return l10n.getString("Recipient");
                }
                case 2: {
                    return l10n.getString("Text");
                }
            }
            logger.warning("Index out of bounds!");
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Date.class;
                }
                case 1: 
                case 2: {
                    return String.class;
                }
            }
            logger.warning("Index out of bounds!");
            return Object.class;
        }
    }

    private class HistoryActionListener
    implements ActionListener {
        private HistoryActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HistoryFrame.this.historyTableModel.fireTableDataChanged();
            HistoryFrame.this.historyTable.getSelectionModel().clearSelection();
        }
    }

    private class ResendAction
    extends AbstractAction {
        public ResendAction() {
            L10N.setLocalizedText(this, l10n.getString("Forward_"));
            this.putValue("SwingLargeIconKey", Icons.get("send-22.png"));
            this.putValue("ShortDescription", l10n.getString("HistoryFrame.resend_message"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (HistoryFrame.this.selectedHistory == null) {
                return;
            }
            logger.fine("Forwarding message from history: " + HistoryFrame.this.selectedHistory);
            HistoryFrame.this.valuedSupport.fireEventOccured(Events.RESEND_SMS, HistoryFrame.this.selectedHistory);
            HistoryFrame.this.closeButton.doClick(0);
        }
    }

    private class DeleteAction
    extends AbstractAction {
        private final String deleteOption = HistoryFrame.access$1300().getString("Delete");
        private final String cancelOption = HistoryFrame.access$1300().getString("Cancel");
        private final Object[] options = RuntimeUtils.sortDialogOptions(this.cancelOption, this.deleteOption);
        private final String message = HistoryFrame.access$1300().getString("HistoryFrame.remove_selected");

        public DeleteAction() {
            L10N.setLocalizedText(this, l10n.getString("Delete_"));
            this.putValue("SwingLargeIconKey", Icons.get("delete-22.png"));
            this.putValue("ShortDescription", l10n.getString("Delete_selected_messages_from_history"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HistoryFrame.this.historyTable.requestFocusInWindow();
            int[] rows = HistoryFrame.this.historyTable.getSelectedRows();
            if (rows.length <= 0) {
                return;
            }
            ArrayList<History.Record> histToDelete = new ArrayList<History.Record>();
            for (int i : rows) {
                i = HistoryFrame.this.historyTable.getRowSorter().convertRowIndexToModel(i);
                histToDelete.add(HistoryFrame.this.history.getRecord(i));
            }
            JOptionPane pane = new JOptionPane(this.message, 2, -1, null, this.options, this.deleteOption);
            JDialog dialog = pane.createDialog(HistoryFrame.this, null);
            dialog.setResizable(true);
            RuntimeUtils.setDocumentModalDialog(dialog);
            dialog.pack();
            dialog.setVisible(true);
            if (!this.deleteOption.equals(pane.getValue())) {
                return;
            }
            HistoryFrame.this.history.removeRecords(histToDelete);
            HistoryFrame.this.historyTableModel.fireTableDataChanged();
            HistoryFrame.this.historyTable.getSelectionModel().clearSelection();
        }
    }

    public static enum Events {
        RESEND_SMS;

    }
}

