/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.filters.library;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.gephi.desktop.filters.library.SavedQueryNodeDefaultAction;
import org.gephi.filters.api.FilterController;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.api.Query;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SavedQueryNode
extends AbstractNode {
    private Query query;

    public SavedQueryNode(Query query) {
        super(Children.LEAF);
        this.query = query;
        this.setDisplayName(this.getQueryName(query));
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new RemoveAction()};
    }

    public Action getPreferredAction() {
        return SavedQueryNodeDefaultAction.instance;
    }

    public Query getQuery() {
        return this.query;
    }

    private String getQueryName(Query query) {
        String res = query.getName();
        if (query.getPropertiesCount() > 0) {
            res = res + "(";
            for (int i = 0; i < query.getPropertiesCount(); ++i) {
                res = res + "'" + query.getPropertyValue(i).toString() + "'";
                res = res + (i + 1 < query.getPropertiesCount() ? "," : "");
            }
        }
        if (query.getChildren() != null) {
            res = query.getPropertiesCount() == 0 ? res + "(" : res + ",";
            for (Query child : query.getChildren()) {
                res = res + this.getQueryName(child);
                res = res + ",";
            }
            if (res.endsWith(",")) {
                res = res.substring(0, res.length() - 1);
            }
        }
        res = res + ")";
        return res;
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            super(NbBundle.getMessage(SavedQueryNode.class, (String)"SavedQueryNode.actions.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterController filterController = (FilterController)Lookup.getDefault().lookup(FilterController.class);
            FilterLibrary filterLibrary = filterController.getModel().getLibrary();
            filterLibrary.deleteQuery(SavedQueryNode.this.query);
        }
    }
}

