/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.impl;

import java.util.ArrayList;
import java.util.List;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceProvider;
import org.gephi.project.impl.ProjectImpl;
import org.gephi.workspace.impl.WorkspaceImpl;

public class WorkspaceProviderImpl
implements WorkspaceProvider {
    private transient WorkspaceImpl currentWorkspace;
    private final transient ProjectImpl project;
    private final transient List<Workspace> workspaces;

    public WorkspaceProviderImpl(ProjectImpl project) {
        this.project = project;
        this.workspaces = new ArrayList<Workspace>();
    }

    public synchronized WorkspaceImpl newWorkspace() {
        WorkspaceImpl workspace = new WorkspaceImpl(this.project, this.project.nextWorkspaceId());
        this.workspaces.add(workspace);
        return workspace;
    }

    public synchronized WorkspaceImpl newWorkspace(int id) {
        WorkspaceImpl workspace = new WorkspaceImpl(this.project, id);
        this.workspaces.add(workspace);
        return workspace;
    }

    public synchronized void addWorkspace(Workspace workspace) {
        this.workspaces.add(workspace);
    }

    public synchronized void removeWorkspace(Workspace workspace) {
        this.workspaces.remove(workspace);
    }

    public synchronized Workspace getPrecedingWorkspace(Workspace workspace) {
        Workspace[] ws = this.getWorkspaces();
        int index = -1;
        for (int i = 0; i < ws.length; ++i) {
            if (ws[i] != workspace) continue;
            index = i;
        }
        if (index != -1 && index >= 1) {
            return ws[index - 1];
        }
        if (index == 0 && ws.length > 1) {
            return ws[1];
        }
        return null;
    }

    @Override
    public synchronized WorkspaceImpl getCurrentWorkspace() {
        return this.currentWorkspace;
    }

    @Override
    public synchronized Workspace[] getWorkspaces() {
        return this.workspaces.toArray(new Workspace[0]);
    }

    @Override
    public synchronized Workspace getWorkspace(int id) {
        for (Workspace w : this.workspaces) {
            if (w.getId() != id) continue;
            return w;
        }
        return null;
    }

    public synchronized void setCurrentWorkspace(Workspace currentWorkspace) {
        this.currentWorkspace = (WorkspaceImpl)currentWorkspace;
    }

    @Override
    public synchronized boolean hasCurrentWorkspace() {
        return this.currentWorkspace != null;
    }
}

