/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.appearance;

import org.gephi.appearance.RankingImpl;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;

public class DegreeRankingImpl
extends RankingImpl {
    private final Graph graph;

    public DegreeRankingImpl(Graph graph) {
        this.graph = graph;
    }

    @Override
    public Number getValue(Element element, Graph gr) {
        return gr.getDegree((Node)element);
    }

    @Override
    protected void refresh() {
        if (this.graph.getNodeCount() > 0) {
            int minV = Integer.MAX_VALUE;
            int maxV = Integer.MIN_VALUE;
            for (Node n : this.graph.getNodes()) {
                int degree = this.graph.getDegree(n);
                minV = Math.min(degree, minV);
                maxV = Math.max(degree, maxV);
            }
            this.min = minV;
            this.max = maxV;
        }
    }
}

