/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.api;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Iterator;
import org.gephi.io.importer.api.Issue;
import org.openide.util.Exceptions;

public final class Report {
    private Issue.Level exceptionLevel = Issue.Level.CRITICAL;
    private final File file;
    private Writer writer;
    private boolean empty = true;

    public Report() {
        File f = null;
        try {
            f = File.createTempFile("tempreport", Long.toString(System.nanoTime()));
            f.deleteOnExit();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            this.file = f;
        }
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void clean() {
        if (this.file.exists()) {
            this.file.delete();
        }
    }

    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
                this.writer = null;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public synchronized void log(String message) {
        try {
            if (this.writer == null) {
                this.writer = new Writer(this.file);
            }
            this.writer.append(new ReportEntry(message));
            this.empty = false;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized void append(Report report) {
        if (report.writer != null) {
            report.close();
        }
        try (Reader r = null;){
            if (this.writer == null) {
                this.writer = new Writer(this.file);
            }
            r = new Reader(report.file);
            while (r.hasNext()) {
                ReportEntry re = r.next();
                this.writer.append(re);
                this.empty = false;
            }
        }
    }

    public synchronized void logIssue(Issue issue) {
        try {
            if (this.writer == null) {
                this.writer = new Writer(this.file);
            }
            this.writer.append(new ReportEntry(issue));
            this.empty = false;
            if (issue.getLevel().toInteger() >= this.exceptionLevel.toInteger()) {
                this.writer.close();
                if (issue.getThrowable() != null) {
                    throw new RuntimeException(issue.getMessage(), issue.getThrowable());
                }
                throw new RuntimeException(issue.getMessage());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized Iterator<Issue> getIssues(int limit) {
        if (this.writer != null) {
            this.close();
        }
        Reader reader = null;
        try {
            reader = new Reader(this.file);
            return new IssueIterator(reader, limit);
        }
        catch (IOException ex) {
            if (reader != null) {
                reader.close();
            }
            throw new RuntimeException(ex);
        }
    }

    public synchronized String getText() {
        if (this.writer != null) {
            this.close();
        }
        StringBuilder builder = new StringBuilder();
        Reader r = null;
        try {
            r = new Reader(this.file);
            while (r.hasNext()) {
                ReportEntry re = r.next();
                if (re.level != null) continue;
                builder.append(re.message);
                builder.append("\n");
            }
        }
        catch (IOException ex) {
            if (r != null) {
                r.close();
            }
            throw new RuntimeException(ex);
        }
        return builder.toString();
    }

    public Issue.Level getExceptionLevel() {
        return this.exceptionLevel;
    }

    public void setExceptionLevel(Issue.Level exceptionLevel) {
        this.exceptionLevel = exceptionLevel;
    }

    private static class IssueIterator
    implements Iterator<Issue> {
        private final Reader itr;
        private ReportEntry next;
        private final int limit;
        private int count;

        public IssueIterator(Reader itr, int limit) {
            this.itr = itr;
            this.limit = limit;
        }

        @Override
        public boolean hasNext() {
            while (this.itr.hasNext()) {
                this.next = this.itr.next();
                if (this.next.level == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public Issue next() {
            Issue res = new Issue(this.next.message, this.next.level);
            if (++this.count == this.limit) {
                this.itr.close();
            }
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Reader
    implements Iterator<ReportEntry> {
        private final BufferedReader reader;
        private String pointer;
        private boolean closed;

        public Reader(File file) throws IOException {
            FileReader fileReader = new FileReader(file);
            this.reader = new LineNumberReader(fileReader);
        }

        @Override
        public boolean hasNext() {
            if (this.closed) {
                return false;
            }
            try {
                this.pointer = this.reader.readLine();
                if (this.pointer != null) {
                    return true;
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            try {
                this.reader.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return false;
        }

        @Override
        public ReportEntry next() {
            if (this.pointer.startsWith(";")) {
                return new ReportEntry(this.pointer.substring(1, this.pointer.length()));
            }
            int index = this.pointer.indexOf(";");
            if (index == -1) {
                return new ReportEntry(this.pointer);
            }
            String levelStr = this.pointer.substring(0, index);
            String message = this.pointer.substring(index + 1);
            return new ReportEntry(new Issue(message, Issue.Level.valueOf(levelStr)));
        }

        public void close() {
            try {
                this.reader.close();
            }
            catch (IOException ex2) {
                throw new RuntimeException(ex2);
            }
            this.pointer = null;
            this.closed = true;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Writer {
        private final BufferedWriter writer;

        public Writer(File file) throws IOException {
            FileWriter fileWriter = new FileWriter(file, true);
            this.writer = new BufferedWriter(fileWriter);
        }

        public void append(ReportEntry entry) throws IOException {
            Issue.Level level = entry.level;
            if (level != null) {
                this.writer.append(level.toString());
            }
            this.writer.append(";");
            this.writer.append(entry.message);
            this.writer.append("\n");
        }

        public void close() throws IOException {
            this.writer.flush();
            this.writer.close();
        }
    }

    private static class ReportEntry {
        private final Issue.Level level;
        private final String message;

        public ReportEntry(Issue issue) {
            this.level = issue.getLevel();
            this.message = issue.getMessage();
        }

        public ReportEntry(String message) {
            this.message = message;
            this.level = null;
        }
    }
}

