/*
 * Decompiled with CFR 0.152.
 */
package com.getsentry.raven.connection;

import com.getsentry.raven.connection.ConnectionException;
import com.getsentry.raven.time.Clock;
import com.getsentry.raven.time.SystemClock;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class LockdownManager {
    public static final long DEFAULT_MAX_LOCKDOWN_TIME = TimeUnit.MINUTES.toMillis(5L);
    public static final long DEFAULT_BASE_LOCKDOWN_TIME = TimeUnit.SECONDS.toMillis(1L);
    private long maxLockdownTime = DEFAULT_MAX_LOCKDOWN_TIME;
    private long baseLockdownTime = DEFAULT_BASE_LOCKDOWN_TIME;
    private long lockdownTime = 0L;
    private Date lockdownStartTime = null;
    private final Clock clock;

    public LockdownManager() {
        this(new SystemClock());
    }

    public LockdownManager(Clock clock) {
        this.clock = clock;
    }

    public synchronized boolean isLockedDown() {
        return this.lockdownStartTime != null && this.clock.millis() - this.lockdownStartTime.getTime() < this.lockdownTime;
    }

    public synchronized void resetState() {
        this.lockdownTime = 0L;
        this.lockdownStartTime = null;
    }

    public synchronized void setState(ConnectionException connectionException) {
        if (this.isLockedDown()) {
            return;
        }
        this.lockdownTime = connectionException != null && connectionException.getRecommendedLockdownTime() != null ? connectionException.getRecommendedLockdownTime() : (this.lockdownTime != 0L ? (this.lockdownTime *= 2L) : this.baseLockdownTime);
        this.lockdownTime = Math.min(this.maxLockdownTime, this.lockdownTime);
        this.lockdownStartTime = this.clock.date();
    }

    public synchronized void setBaseLockdownTime(long baseLockdownTime) {
        this.baseLockdownTime = baseLockdownTime;
    }

    public synchronized void setMaxLockdownTime(long maxLockdownTime) {
        this.maxLockdownTime = maxLockdownTime;
    }
}

