/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Random;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ObjectSupport;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"OpenSSL::BN"}, include={"Comparable"})
public class BN
extends RubyObject {
    private static final long serialVersionUID = -5660938062191525498L;
    private static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static final int DEFAULT_CERTAINTY = 100;
    private static final ObjectAllocator BN_ALLOCATOR = new ObjectAllocator(){

        public BN allocate(Ruby runtime, RubyClass klass) {
            return new BN(runtime, klass);
        }
    };
    private volatile BigInteger value;
    private static Random random;
    private static SecureRandom secureRandom;

    public static BN newBN(Ruby runtime, BigInteger value2) {
        return BN.newInstance(runtime, value2);
    }

    static BN newInstance(Ruby runtime, BigInteger value2) {
        return new BN(runtime, value2 != null ? value2 : BigInteger.ZERO);
    }

    static void createBN(Ruby runtime, RubyModule OpenSSL2, RubyClass OpenSSLError) {
        OpenSSL2.defineClassUnder("BNError", OpenSSLError, OpenSSLError.getAllocator());
        RubyClass BN2 = OpenSSL2.defineClassUnder("BN", runtime.getObject(), BN_ALLOCATOR);
        BN2.includeModule((IRubyObject)runtime.getModule("Comparable"));
        BN2.defineAnnotatedMethods(BN.class);
    }

    private BN(Ruby runtime, RubyClass clazz) {
        super(runtime, clazz);
        this.value = BigInteger.ZERO;
    }

    protected BN(Ruby runtime, BigInteger value2) {
        super(runtime, (RubyClass)runtime.getModule("OpenSSL").getConstantAt("BN"));
        this.value = value2;
    }

    public final BigInteger getValue() {
        return this.value;
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject[] args) {
        Ruby runtime = context2.runtime;
        if (this.value != BigInteger.ZERO) {
            throw BN.newBNError(runtime, "illegal initialization");
        }
        int argc = Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)1, (int)2);
        int base = argc == 2 ? RubyNumeric.num2int((IRubyObject)args[1]) : 10;
        RubyString str = args[0].asString();
        switch (base) {
            case 0: {
                this.value = BN.initBigIntegerMPI(runtime, str);
                break;
            }
            case 2: {
                this.value = new BigInteger(1, str.getBytes());
                break;
            }
            case 10: 
            case 16: {
                this.value = BN.initBigIntegerBase(runtime, str, base);
                break;
            }
            default: {
                throw runtime.newArgumentError("illegal radix: " + base);
            }
        }
        return this;
    }

    private static BigInteger initBigIntegerMPI(Ruby runtime, RubyString str) {
        int signum;
        ByteList byteList = str.getByteList();
        int off = byteList.getBegin();
        byte[] b = byteList.getUnsafeBytes();
        long len = ((long)b[off] & 0xFFL) << 24 | (long)((b[off + 1] & 0xFF) << 16) | (long)((b[off + 2] & 0xFF) << 8) | (long)(b[off + 3] & 0xFF);
        byte[] bytes = new byte[(int)len];
        System.arraycopy(b, off + 4, bytes, 0, bytes.length);
        if ((bytes[0] & 0x80) == 128) {
            signum = -1;
            bytes[0] = (byte)(bytes[0] & 0x7F);
        } else {
            signum = 1;
        }
        return new BigInteger(signum, bytes);
    }

    private static BigInteger initBigIntegerBase(Ruby runtime, RubyString str, int base) {
        try {
            return new BigInteger(str.toString(), base);
        }
        catch (NumberFormatException e) {
            throw runtime.newArgumentError("value " + str + " is not legal for radix " + base);
        }
    }

    public IRubyObject initialize_copy(IRubyObject that) {
        super.initialize_copy(that);
        if (this != that) {
            this.value = ((BN)that).value;
        }
        return this;
    }

    @JRubyMethod(name={"copy"})
    public IRubyObject copy(IRubyObject other) {
        if (this != other) {
            this.value = BN.asBigInteger(other);
        }
        return this;
    }

    @Deprecated
    public RubyString to_s(IRubyObject[] args) {
        int argc = Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)0, (int)1);
        return this.to_s(argc == 1 ? RubyNumeric.num2int((IRubyObject)args[0]) : 10);
    }

    @JRubyMethod(name={"to_s"})
    public RubyString to_s() {
        return this.to_s(10);
    }

    @JRubyMethod(name={"to_s"})
    public RubyString to_s(IRubyObject base) {
        return this.to_s(RubyNumeric.num2int((IRubyObject)base));
    }

    private RubyString to_s(int base) {
        Ruby runtime = this.getRuntime();
        switch (base) {
            case 0: {
                boolean need0;
                byte[] bytes = this.value.abs().toByteArray();
                int offset = 0;
                if (bytes[0] == 0) {
                    offset = 1;
                }
                int length = bytes.length - offset;
                boolean negative = BigInteger.ZERO.compareTo(this.value) > 0;
                boolean bl = need0 = !negative && (bytes[offset] & 0x80) != 0;
                if (negative) {
                    int n = offset;
                    bytes[n] = (byte)(bytes[n] | 0x80);
                } else if (need0) {
                    ++length;
                }
                byte[] data = new byte[5 + length];
                data[0] = (byte)(0xFF & length >> 24);
                data[1] = (byte)(0xFF & length >> 16);
                data[2] = (byte)(0xFF & length >> 8);
                data[3] = (byte)(0xFF & length >> 0);
                if (need0) {
                    data[4] = 0;
                    System.arraycopy(bytes, offset, data, 5, length - 1);
                } else {
                    System.arraycopy(bytes, offset, data, 4, length);
                }
                return runtime.newString(new ByteList(data, 0, 4 + length, false));
            }
            case 2: {
                byte[] bytes = this.value.abs().toByteArray();
                if (bytes[0] == 0) {
                    return runtime.newString(new ByteList(bytes, 1, bytes.length - 1, false));
                }
                return runtime.newString(new ByteList(bytes, false));
            }
            case 10: {
                return runtime.newString(this.value.toString(10));
            }
            case 16: {
                String hex = this.value.toString(16);
                int len = hex.length();
                ByteList val = new ByteList(len + 1);
                if (this.value.signum() == 1 && len % 2 != 0) {
                    val.append(48);
                }
                for (int i2 = 0; i2 < len; ++i2) {
                    val.append((int)Character.toUpperCase(hex.charAt(i2)));
                }
                return runtime.newString(val);
            }
        }
        throw runtime.newArgumentError("illegal radix: " + base);
    }

    public String toString() {
        return this.to_s().toString();
    }

    public String toString(int base) {
        return this.to_s(base).toString();
    }

    @JRubyMethod
    public IRubyObject inspect() {
        return ObjectSupport.inspect((RubyBasicObject)this, Collections.EMPTY_LIST);
    }

    public boolean equals(Object other) {
        return other instanceof BN ? this.value.equals(((BN)((Object)other)).value) : false;
    }

    public int hashCode() {
        return 997 * this.value.hashCode();
    }

    @JRubyMethod(name={"hash"})
    public RubyInteger hash(ThreadContext context2) {
        return context2.runtime.newFixnum(this.hashCode());
    }

    @JRubyMethod(name={"to_i"})
    public RubyInteger to_i() {
        if (this.value.compareTo(MAX_LONG) > 0 || this.value.compareTo(MIN_LONG) < 0) {
            return RubyBignum.newBignum((Ruby)this.getRuntime(), (BigInteger)this.value);
        }
        return RubyFixnum.newFixnum((Ruby)this.getRuntime(), (long)this.value.longValue());
    }

    @JRubyMethod(name={"to_bn"})
    public BN to_bn() {
        return this;
    }

    @JRubyMethod(name={"coerce"})
    public IRubyObject coerce(IRubyObject other) {
        Object self;
        Ruby runtime = this.getRuntime();
        if (other instanceof RubyString) {
            self = runtime.newString(this.value.toString());
        } else if (other instanceof RubyInteger) {
            self = this.to_i();
        } else if (other instanceof BN) {
            self = this;
        } else {
            throw runtime.newTypeError("don't know how to coerce to " + other.getMetaClass().getName());
        }
        return runtime.newArray(other, (IRubyObject)self);
    }

    @JRubyMethod(name={"zero?"})
    public RubyBoolean zero_p(ThreadContext context2) {
        return context2.runtime.newBoolean(this.value.equals(BigInteger.ZERO));
    }

    @JRubyMethod(name={"one?"})
    public RubyBoolean one_p(ThreadContext context2) {
        return context2.runtime.newBoolean(this.value.equals(BigInteger.ONE));
    }

    @JRubyMethod(name={"odd?"})
    public RubyBoolean odd_p(ThreadContext context2) {
        return context2.runtime.newBoolean(this.value.testBit(0));
    }

    @JRubyMethod(name={"cmp", "<=>"})
    public IRubyObject cmp(ThreadContext context2, IRubyObject other) {
        return context2.runtime.newFixnum(this.value.compareTo(BN.asBigInteger(other)));
    }

    @JRubyMethod(name={"ucmp"})
    public IRubyObject ucmp(ThreadContext context2, IRubyObject other) {
        return context2.runtime.newFixnum(this.value.abs().compareTo(BN.asBigInteger(other).abs()));
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject eql_p(ThreadContext context2, IRubyObject other) {
        return context2.runtime.newBoolean(this.eql(other));
    }

    public boolean eql(IRubyObject other) {
        return this.equals(other);
    }

    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context2, IRubyObject other) {
        return context2.runtime.newBoolean(this.value.equals(BN.asBigInteger(other)));
    }

    @JRubyMethod(name={"sqr"})
    public BN sqr(ThreadContext context2) {
        return BN.newBN(context2.runtime, this.value.pow(2));
    }

    @JRubyMethod(name={"~"})
    public BN not(ThreadContext context2) {
        return BN.newBN(context2.runtime, this.value.not());
    }

    @JRubyMethod(name={"+"})
    public BN add(ThreadContext context2, IRubyObject other) {
        return BN.newBN(context2.runtime, this.value.add(BN.asBigInteger(other)));
    }

    @JRubyMethod(name={"-"})
    public BN sub(ThreadContext context2, IRubyObject other) {
        return BN.newBN(context2.runtime, this.value.subtract(BN.asBigInteger(other)));
    }

    @JRubyMethod(name={"*"})
    public BN mul(ThreadContext context2, IRubyObject other) {
        return BN.newBN(context2.runtime, this.value.multiply(BN.asBigInteger(other)));
    }

    @JRubyMethod(name={"%"})
    public BN mod(ThreadContext context2, IRubyObject other) {
        try {
            return BN.newBN(context2.runtime, this.value.mod(BN.asBigInteger(other)));
        }
        catch (ArithmeticException e) {
            throw context2.runtime.newZeroDivisionError();
        }
    }

    @JRubyMethod(name={"/"})
    public IRubyObject div(ThreadContext context2, IRubyObject other) {
        Ruby runtime = context2.runtime;
        try {
            BigInteger[] result = this.value.divideAndRemainder(BN.asBigInteger(other));
            return runtime.newArray((IRubyObject)BN.newBN(runtime, result[0]), (IRubyObject)BN.newBN(runtime, result[1]));
        }
        catch (ArithmeticException e) {
            throw runtime.newZeroDivisionError();
        }
    }

    @JRubyMethod(name={"&"})
    public BN and(ThreadContext context2, IRubyObject other) {
        return BN.newBN(context2.runtime, this.value.and(BN.asBigInteger(other)));
    }

    @JRubyMethod(name={"|"})
    public BN or(ThreadContext context2, IRubyObject other) {
        return BN.newBN(context2.runtime, this.value.or(BN.asBigInteger(other)));
    }

    @JRubyMethod(name={"^"})
    public BN xor(ThreadContext context2, IRubyObject other) {
        return BN.newBN(context2.runtime, this.value.xor(BN.asBigInteger(other)));
    }

    @JRubyMethod(name={"**"})
    public BN exp(ThreadContext context2, IRubyObject other) {
        int exp2 = -1;
        if (other instanceof RubyInteger) {
            long val = ((RubyInteger)other).getLongValue();
            if (val >= 0L && val <= Integer.MAX_VALUE) {
                exp2 = (int)val;
            } else if (other instanceof RubyBignum) {
                throw BN.newBNError(context2.runtime, "invalid exponent");
            }
        }
        if (exp2 == -1) {
            if (!(other instanceof BN)) {
                throw context2.runtime.newTypeError("Cannot convert into " + other.getMetaClass().getName());
            }
            BigInteger val = ((BN)other).value;
            if (val.compareTo(BigInteger.ZERO) < 0 || val.compareTo(MAX_INT) > 0) {
                throw BN.newBNError(context2.runtime, "invalid exponent");
            }
            exp2 = val.intValue();
        }
        try {
            return BN.newBN(context2.runtime, this.value.pow(exp2));
        }
        catch (ArithmeticException e) {
            throw BN.newBNError(context2.runtime, "invalid exponent");
        }
    }

    @JRubyMethod(name={"gcd"})
    public BN gcd(ThreadContext context2, IRubyObject other) {
        return BN.newBN(context2.runtime, this.value.gcd(BN.asBigInteger(other)));
    }

    @JRubyMethod(name={"mod_sqr"})
    public BN mod_sqr(ThreadContext context2, IRubyObject other) {
        try {
            return BN.newBN(context2.runtime, this.value.modPow(TWO, BN.asBigInteger(other)));
        }
        catch (ArithmeticException e) {
            throw context2.runtime.newZeroDivisionError();
        }
    }

    @JRubyMethod(name={"mod_inverse"})
    public BN mod_inverse(ThreadContext context2, IRubyObject other) {
        try {
            return BN.newBN(context2.runtime, this.value.modInverse(BN.asBigInteger(other)));
        }
        catch (ArithmeticException e) {
            throw context2.runtime.newZeroDivisionError();
        }
    }

    @JRubyMethod(name={"mod_add"})
    public BN mod_add(ThreadContext context2, IRubyObject other, IRubyObject mod2) {
        try {
            return BN.newBN(context2.runtime, this.value.add(BN.asBigInteger(other)).mod(BN.asBigInteger(mod2)));
        }
        catch (ArithmeticException e) {
            throw context2.runtime.newZeroDivisionError();
        }
    }

    @JRubyMethod(name={"mod_sub"})
    public BN mod_sub(ThreadContext context2, IRubyObject other, IRubyObject mod2) {
        try {
            return BN.newBN(context2.runtime, this.value.subtract(BN.asBigInteger(other)).mod(BN.asBigInteger(mod2)));
        }
        catch (ArithmeticException e) {
            throw context2.runtime.newZeroDivisionError();
        }
    }

    @JRubyMethod(name={"mod_mul"})
    public BN mod_mul(ThreadContext context2, IRubyObject other, IRubyObject mod2) {
        try {
            return BN.newBN(context2.runtime, this.value.multiply(BN.asBigInteger(other)).mod(BN.asBigInteger(mod2)));
        }
        catch (ArithmeticException e) {
            throw context2.runtime.newZeroDivisionError();
        }
    }

    @JRubyMethod(name={"mod_exp"})
    public BN mod_exp(ThreadContext context2, IRubyObject other, IRubyObject mod2) {
        try {
            return BN.newBN(context2.runtime, this.value.modPow(BN.asBigInteger(other), BN.asBigInteger(mod2)));
        }
        catch (ArithmeticException e) {
            throw context2.runtime.newZeroDivisionError();
        }
    }

    @JRubyMethod(name={"set_bit!"})
    public synchronized IRubyObject set_bit(IRubyObject n) {
        int pos = RubyNumeric.num2int((IRubyObject)n);
        BigInteger oldValue = this.value;
        try {
            this.value = oldValue.signum() >= 0 ? oldValue.setBit(pos) : oldValue.abs().setBit(pos).negate();
        }
        catch (ArithmeticException e) {
            throw BN.newBNError(this.getRuntime(), "invalid pos");
        }
        return this;
    }

    @JRubyMethod(name={"clear_bit!"})
    public synchronized IRubyObject clear_bit(IRubyObject n) {
        int pos = RubyNumeric.num2int((IRubyObject)n);
        BigInteger oldValue = this.value;
        try {
            this.value = oldValue.signum() >= 0 ? oldValue.clearBit(pos) : oldValue.abs().clearBit(pos).negate();
        }
        catch (ArithmeticException e) {
            throw BN.newBNError(this.getRuntime(), "invalid pos");
        }
        return this;
    }

    @JRubyMethod(name={"mask_bits!"})
    public synchronized IRubyObject mask_bits(IRubyObject n) {
        int pos = RubyNumeric.num2int((IRubyObject)n);
        if (pos < 0) {
            throw BN.newBNError(this.getRuntime(), "invalid pos");
        }
        BigInteger oldValue = this.value;
        if (oldValue.signum() >= 0) {
            if (oldValue.bitLength() < pos) {
                throw BN.newBNError(this.getRuntime(), "invalid pos");
            }
            this.value = oldValue.mod(TWO.pow(pos));
        } else {
            BigInteger absValue = oldValue.abs();
            if (absValue.bitLength() < pos) {
                throw BN.newBNError(this.getRuntime(), "invalid pos");
            }
            this.value = absValue.mod(TWO.pow(pos)).negate();
        }
        return this;
    }

    @JRubyMethod(name={"bit_set?"})
    public RubyBoolean bit_set_p(ThreadContext context2, IRubyObject n) {
        int pos = RubyNumeric.num2int((IRubyObject)n);
        BigInteger val = this.value;
        try {
            if (val.signum() >= 0) {
                return context2.runtime.newBoolean(val.testBit(pos));
            }
            return context2.runtime.newBoolean(val.abs().testBit(pos));
        }
        catch (ArithmeticException e) {
            throw BN.newBNError(context2.runtime, "invalid pos");
        }
    }

    @JRubyMethod(name={"<<"})
    public BN lshift(ThreadContext context2, IRubyObject n) {
        int nbits = RubyNumeric.num2int((IRubyObject)n);
        BigInteger val = this.value;
        if (val.signum() >= 0) {
            return BN.newBN(context2.runtime, val.shiftLeft(nbits));
        }
        return BN.newBN(context2.runtime, val.abs().shiftLeft(nbits).negate());
    }

    @JRubyMethod(name={">>"})
    public BN rshift(ThreadContext context2, IRubyObject n) {
        int nbits = RubyNumeric.num2int((IRubyObject)n);
        BigInteger val = this.value;
        if (val.signum() >= 0) {
            return BN.newBN(context2.runtime, val.shiftRight(nbits));
        }
        return BN.newBN(context2.runtime, val.abs().shiftRight(nbits).negate());
    }

    @JRubyMethod(name={"num_bits"})
    public RubyFixnum num_bits(ThreadContext context2) {
        return context2.runtime.newFixnum(this.value.abs().bitLength());
    }

    @JRubyMethod(name={"num_bytes"})
    public RubyFixnum num_bytes(ThreadContext context2) {
        return context2.runtime.newFixnum((this.value.abs().bitLength() + 7) / 8);
    }

    @JRubyMethod(name={"num_bits_set"})
    public RubyFixnum num_bits_set(ThreadContext context2) {
        return context2.runtime.newFixnum(this.value.abs().bitCount());
    }

    @JRubyMethod(name={"prime?"}, rest=true)
    public IRubyObject prime_p(IRubyObject[] args) {
        Ruby runtime = this.getRuntime();
        int argc = Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)0, (int)1);
        if (this.value.signum() < 0) {
            return runtime.getFalse();
        }
        int certainty = argc == 0 ? 100 : RubyNumeric.fix2int((IRubyObject)args[0]);
        return runtime.newBoolean(this.value.isProbablePrime(certainty));
    }

    @JRubyMethod(name={"prime_fasttest?"}, rest=true)
    public IRubyObject prime_fasttest_p(IRubyObject[] args) {
        Ruby runtime = this.getRuntime();
        int argc = Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)0, (int)2);
        if (this.value.signum() < 0) {
            return runtime.getFalse();
        }
        int certainty = argc == 0 ? 100 : RubyNumeric.fix2int((IRubyObject)args[0]);
        return runtime.newBoolean(this.value.isProbablePrime(certainty));
    }

    @JRubyMethod(name={"generate_prime"}, meta=true, rest=true)
    public static IRubyObject generate_prime(IRubyObject recv, IRubyObject[] args) {
        BigInteger rem;
        Ruby runtime = recv.getRuntime();
        int argc = Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)1, (int)4);
        int bits = RubyNumeric.num2int((IRubyObject)args[0]);
        boolean safe = argc > 1 ? args[1] != runtime.getFalse() : true;
        BigInteger add2 = argc > 2 ? BN.asBigInteger(args[2]) : null;
        BigInteger bigInteger = rem = argc > 3 ? BN.asBigInteger(args[3]) : null;
        if (bits < 3) {
            if (safe) {
                throw runtime.newArgumentError("bits < 3");
            }
            if (bits < 2) {
                throw runtime.newArgumentError("bits < 2");
            }
        }
        return BN.newBN(runtime, BN.generatePrime(bits, safe, add2, rem));
    }

    public static BigInteger generatePrime(int bits, boolean safe, BigInteger add2, BigInteger rem) {
        BigInteger p;
        if (add2 != null && rem == null) {
            rem = BigInteger.ONE;
        }
        int qbits = bits - 1;
        SecureRandom secureRandom = BN.getSecureRandom();
        do {
            if (safe) {
                BigInteger q;
                while (!(p = (q = new BigInteger(qbits, 2, secureRandom)).shiftLeft(1).setBit(0)).isProbablePrime(100) || !q.isProbablePrime(100)) {
                }
                continue;
            }
            p = BigInteger.probablePrime(bits, secureRandom);
        } while (add2 != null && !p.mod(add2).equals(rem));
        return p;
    }

    public static BigInteger generatePrime(int bits, boolean safe) {
        return BN.generatePrime(bits, safe, null, null);
    }

    @JRubyMethod(name={"rand"}, meta=true, rest=true)
    public static IRubyObject rand(IRubyObject recv, IRubyObject[] args) {
        return BN.getRandomBN(recv.getRuntime(), args, BN.getSecureRandom());
    }

    @JRubyMethod(name={"pseudo_rand"}, meta=true, rest=true)
    public static IRubyObject pseudo_rand(IRubyObject recv, IRubyObject[] args) {
        return BN.getRandomBN(recv.getRuntime(), args, BN.getRandom());
    }

    public static BN getRandomBN(Ruby runtime, IRubyObject[] args, Random random) {
        BigInteger value2;
        boolean bottom;
        int top;
        int argc = Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)1, (int)3);
        int bits = RubyNumeric.num2int((IRubyObject)args[0]);
        if (argc > 1) {
            top = RubyNumeric.fix2int((IRubyObject)args[1]);
            bottom = argc == 3 ? args[2].isTrue() : false;
        } else {
            top = 0;
            bottom = false;
        }
        try {
            value2 = BN.getRandomBI(bits, top, bottom, random);
        }
        catch (IllegalArgumentException e) {
            throw runtime.newArgumentError(e.getMessage());
        }
        return BN.newBN(runtime, value2);
    }

    public static BigInteger getRandomBI(int bits, int top, boolean bottom, Random random) {
        if (bits <= 0) {
            if (bits == 0) {
                return BigInteger.ZERO;
            }
            throw new IllegalArgumentException("Illegal bit length");
        }
        if (top < -1 || top > 1) {
            throw new IllegalArgumentException("Illegal top value");
        }
        int bytes = (bits + 7) / 8;
        int bit = (bits - 1) % 8;
        int mask = 255 << bit + 1;
        byte[] buf = new byte[bytes];
        random.nextBytes(buf);
        if (top >= 0) {
            if (top == 0) {
                buf[0] = (byte)(buf[0] | 1 << bit);
            } else if (bit == 0) {
                buf[0] = 1;
                buf[1] = (byte)(buf[1] | 0x80);
            } else {
                buf[0] = (byte)(buf[0] | 3 << bit - 1);
            }
        }
        buf[0] = (byte)(buf[0] & ~mask);
        if (bottom) {
            int n = bytes - 1;
            buf[n] = (byte)(buf[n] | 1);
        }
        return new BigInteger(1, buf);
    }

    @JRubyMethod(name={"rand_range"}, meta=true)
    public static IRubyObject rand_range(IRubyObject recv, IRubyObject arg) {
        return BN.randomValueInRange(recv.getRuntime(), BN.asBigInteger(arg), BN.getSecureRandom());
    }

    @JRubyMethod(name={"pseudo_rand_range"}, meta=true)
    public static IRubyObject pseudo_rand_range(IRubyObject recv, IRubyObject arg) {
        return BN.randomValueInRange(recv.getRuntime(), BN.asBigInteger(arg), BN.getRandom());
    }

    private static BN randomValueInRange(Ruby runtime, BigInteger limit, Random random) {
        BigInteger value2;
        try {
            value2 = BN.randomIntegerInRange(limit, random);
        }
        catch (IllegalArgumentException e) {
            throw BN.newBNError(runtime, e.getMessage());
        }
        return BN.newInstance(runtime, value2);
    }

    public static BigInteger randomIntegerInRange(BigInteger limit, Random random) {
        BigInteger value2;
        if (limit.signum() < 0) {
            throw new IllegalArgumentException("illegal range: " + limit);
        }
        int bits = limit.bitLength();
        while ((value2 = new BigInteger(bits, random)).compareTo(limit) >= 0) {
        }
        return value2;
    }

    private static Random getRandom() {
        Random rnd = random;
        if (rnd != null) {
            return rnd;
        }
        random = new Random();
        return random;
    }

    private static SecureRandom getSecureRandom() {
        SecureRandom rnd = secureRandom;
        if (rnd != null) {
            return rnd;
        }
        secureRandom = new SecureRandom();
        return secureRandom;
    }

    public static RaiseException newBNError(Ruby runtime, String message) {
        return new RaiseException(runtime, runtime.getModule("OpenSSL").getClass("BNError"), message, true);
    }

    public static BigInteger asBigInteger(IRubyObject arg) {
        if (arg.isNil()) {
            return null;
        }
        if (arg instanceof RubyInteger) {
            return ((RubyInteger)arg).getBigIntegerValue();
        }
        if (arg instanceof BN) {
            return ((BN)arg).value;
        }
        throw arg.getRuntime().newTypeError("Cannot convert into OpenSSL::BN");
    }

    public static BigInteger asBigInteger(BN arg) {
        return arg.isNil() ? null : arg.value;
    }

    @Deprecated
    public static BigInteger getBigInteger(IRubyObject arg) {
        return BN.asBigInteger(arg);
    }

    public Object toJava(Class target) {
        if (target.isAssignableFrom(BigInteger.class) || target == Number.class) {
            return this.value;
        }
        if (target == Long.class || target == Long.TYPE) {
            return this.value.longValue();
        }
        if (target == Integer.class || target == Integer.TYPE) {
            return this.value.intValue();
        }
        if (target == Double.class || target == Double.TYPE) {
            return this.value.doubleValue();
        }
        if (target == Float.class || target == Float.TYPE) {
            return Float.valueOf(this.value.floatValue());
        }
        return super.toJava(target);
    }
}

