/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.util.Hashtable;
import org.bouncycastle.tls.AbstractTlsClient;
import org.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import org.bouncycastle.tls.DefaultTlsSRPConfigVerifier;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsKeyExchangeFactory;
import org.bouncycastle.tls.TlsSRPConfigVerifier;
import org.bouncycastle.tls.TlsSRPUtils;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.util.Arrays;

public class SRPTlsClient
extends AbstractTlsClient {
    public static final int[] BASE_CIPHER_SUITES = new int[]{49182};
    protected TlsSRPConfigVerifier srpConfigVerifier;
    protected byte[] identity;
    protected byte[] password;
    protected int[] supportedCipherSuites;

    public SRPTlsClient(TlsCrypto tlsCrypto, byte[] byArray, byte[] byArray2) {
        this(tlsCrypto, new DefaultTlsKeyExchangeFactory(), new DefaultTlsSRPConfigVerifier(), byArray, byArray2);
    }

    public SRPTlsClient(TlsCrypto tlsCrypto, TlsKeyExchangeFactory tlsKeyExchangeFactory, TlsSRPConfigVerifier tlsSRPConfigVerifier, byte[] byArray, byte[] byArray2) {
        super(tlsCrypto, tlsKeyExchangeFactory);
        this.srpConfigVerifier = tlsSRPConfigVerifier;
        this.identity = Arrays.clone((byte[])byArray);
        this.password = Arrays.clone((byte[])byArray2);
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(tlsCrypto, BASE_CIPHER_SUITES);
    }

    protected boolean requireSRPServerExtension() {
        return false;
    }

    public int[] getCipherSuites() {
        return Arrays.clone((int[])this.supportedCipherSuites);
    }

    public Hashtable getClientExtensions() throws IOException {
        Hashtable hashtable = TlsExtensionsUtils.ensureExtensionsInitialised(super.getClientExtensions());
        TlsSRPUtils.addSRPExtension(hashtable, this.identity);
        return hashtable;
    }

    public void processServerExtensions(Hashtable hashtable) throws IOException {
        if (!TlsUtils.hasExpectedEmptyExtensionData(hashtable, TlsSRPUtils.EXT_SRP, (short)47) && this.requireSRPServerExtension()) {
            throw new TlsFatalAlert(47);
        }
        super.processServerExtensions(hashtable);
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        int n = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n) {
            case 21: 
            case 22: 
            case 23: {
                return this.createSRPKeyExchange(n);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createSRPKeyExchange(int n) throws IOException {
        return this.keyExchangeFactory.createSRPKeyExchangeClient(n, this.supportedSignatureAlgorithms, this.srpConfigVerifier, this.identity, this.password);
    }
}

