/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimapGwtSerializationDependencies;
import com.google.common.collect.Platform;
import java.util.Set;

public final class HashMultimap<K, V>
extends HashMultimapGwtSerializationDependencies<K, V> {
    transient int expectedValuesPerKey = 2;

    public static <K, V> HashMultimap<K, V> create() {
        return new HashMultimap<K, V>();
    }

    private HashMultimap() {
        this(12, 2);
    }

    private HashMultimap(int expectedKeys, int expectedValuesPerKey) {
        super(Platform.newHashMapWithExpectedSize(expectedKeys));
        Preconditions.checkArgument(expectedValuesPerKey >= 0);
        this.expectedValuesPerKey = expectedValuesPerKey;
    }

    @Override
    Set<V> createCollection() {
        return Platform.newHashSetWithExpectedSize(this.expectedValuesPerKey);
    }
}

