/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BlockUtils {
    public static <T extends PsiStatement> T expandSingleStatementToBlockStatement(@NotNull T statement2) {
        if (statement2 == null) {
            BlockUtils.$$$reportNull$$$0(0);
        }
        if (statement2 instanceof PsiBlockStatement) {
            return statement2;
        }
        PsiBlockStatement blockStatement = (PsiBlockStatement)JavaPsiFacade.getElementFactory(statement2.getProject()).createStatementFromText("{\n}", statement2);
        blockStatement.getCodeBlock().add(statement2);
        PsiBlockStatement result2 = (PsiBlockStatement)statement2.replace(blockStatement);
        PsiElement sibling = result2.getNextSibling();
        if (sibling instanceof PsiWhiteSpace && PsiUtil.isJavaToken(sibling.getNextSibling(), JavaTokenType.ELSE_KEYWORD)) {
            sibling.delete();
        }
        return (T)result2.getCodeBlock().getStatements()[0];
    }

    public static void unwrapTryBlock(PsiTryStatement tryStatement) {
        PsiElement last2;
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return;
        }
        PsiElement parent2 = tryStatement.getParent();
        boolean singleStatement = false;
        if (parent2 instanceof PsiStatement) {
            PsiStatement[] statements = tryBlock.getStatements();
            if (statements.length == 1 && !(statements[0] instanceof PsiDeclarationStatement)) {
                singleStatement = true;
            } else {
                tryStatement = BlockUtils.expandSingleStatementToBlockStatement(tryStatement);
            }
        } else if (parent2 instanceof PsiCodeBlock) {
            if (BlockUtils.containsConflictingDeclarations(tryBlock, (PsiCodeBlock)parent2)) {
                tryStatement = BlockUtils.expandSingleStatementToBlockStatement(tryStatement);
            }
        } else {
            return;
        }
        tryBlock = tryStatement.getTryBlock();
        assert (tryBlock != null);
        PsiElement first2 = singleStatement ? BlockUtils.skip(tryBlock.getFirstBodyElement(), true) : tryBlock.getFirstBodyElement();
        PsiElement psiElement = last2 = singleStatement ? BlockUtils.skip(tryBlock.getLastBodyElement(), false) : tryBlock.getLastBodyElement();
        assert (first2 != null && last2 != null);
        tryStatement.getParent().addRangeBefore(first2, last2, tryStatement);
        tryStatement.delete();
    }

    private static PsiElement skip(PsiElement element, boolean forward) {
        if (!(element instanceof PsiWhiteSpace)) {
            return element;
        }
        return forward ? element.getNextSibling() : element.getPrevSibling();
    }

    public static boolean containsConflictingDeclarations(PsiCodeBlock block, PsiCodeBlock parentBlock) {
        PsiStatement[] statements = block.getStatements();
        if (statements.length == 0) {
            return false;
        }
        int endOffset = block.getTextRange().getEndOffset();
        List affectedBlocks = SyntaxTraverser.psiTraverser(parentBlock).filter(PsiCodeBlock.class).filter(cb -> cb.getTextRange().getEndOffset() > endOffset).addAllTo(new SmartList());
        Project project = block.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        for (PsiStatement statement2 : statements) {
            PsiElement[] variables;
            if (!(statement2 instanceof PsiDeclarationStatement)) continue;
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)statement2;
            for (PsiElement variable2 : variables = declaration.getDeclaredElements()) {
                PsiLocalVariable localVariable;
                String variableName;
                if (!(variable2 instanceof PsiLocalVariable) || (variableName = (localVariable = (PsiLocalVariable)variable2).getName()) == null) continue;
                for (PsiCodeBlock codeBlock : affectedBlocks) {
                    PsiVariable target = resolveHelper.resolveAccessibleReferencedVariable(variableName, codeBlock);
                    if (target instanceof PsiLocalVariable) {
                        return true;
                    }
                    if (!(target instanceof PsiField)) continue;
                    for (PsiCodeBlock affectedBlock : affectedBlocks) {
                        if (SyntaxTraverser.psiTraverser(affectedBlock).filter(PsiReferenceExpression.class).filter(ref -> ref.resolve() == target).isEmpty()) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/BlockUtils", "expandSingleStatementToBlockStatement"));
    }
}

