/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.PsiMethodReferenceCompatibilityConstraint;
import com.intellij.psi.impl.source.tree.java.PsiMethodReferenceExpressionImpl;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.ClassCandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReferenceResolver
implements ResolveCache.PolyVariantContextResolver<PsiMethodReferenceExpressionImpl> {
    @NotNull
    public JavaResolveResult[] resolve(final @NotNull PsiMethodReferenceExpressionImpl reference, @NotNull PsiFile containingFile, boolean incompleteCode) {
        if (reference == null) {
            MethodReferenceResolver.$$$reportNull$$$0(0);
        }
        if (containingFile == null) {
            MethodReferenceResolver.$$$reportNull$$$0(1);
        }
        final PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(reference);
        final PsiClass containingClass = qualifierResolveResult.getContainingClass();
        PsiSubstitutor substitutor2 = qualifierResolveResult.getSubstitutor();
        if (containingClass != null) {
            PsiElement element = reference.getReferenceNameElement();
            boolean isConstructor = reference.isConstructor();
            if (element instanceof PsiIdentifier || isConstructor) {
                if (isConstructor && !MethodReferenceResolver.canBeConstructed(containingClass)) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        MethodReferenceResolver.$$$reportNull$$$0(2);
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                final PsiType functionalInterfaceType = MethodReferenceResolver.getInterfaceType(reference);
                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
                final PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
                PsiSubstitutor functionalInterfaceSubstitutor = interfaceMethod != null ? LambdaUtil.getSubstitutor(interfaceMethod, resolveResult) : null;
                final MethodSignature signature = interfaceMethod != null ? interfaceMethod.getSignature(functionalInterfaceSubstitutor) : null;
                final PsiType interfaceMethodReturnType = LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType);
                if (isConstructor && containingClass.getConstructors().length == 0) {
                    JavaResolveResult[] javaResolveResultArray;
                    if (interfaceMethod != null) {
                        PsiClassType returnType2 = MethodReferenceResolver.composeReturnType(containingClass, substitutor2);
                        InferenceSession session = new InferenceSession(containingClass.getTypeParameters(), substitutor2, reference.getManager(), null);
                        if (!session.isProperType(session.substituteWithInferenceVariables(returnType2)) || !session.isProperType(interfaceMethodReturnType)) {
                            session.registerReturnTypeConstraints(returnType2, interfaceMethodReturnType, reference);
                            substitutor2 = session.infer();
                        }
                    }
                    ClassCandidateInfo candidateInfo = null;
                    boolean isArray = PsiEquivalenceUtil.areElementsEquivalent(containingClass, JavaPsiFacade.getElementFactory(reference.getProject()).getArrayClass(PsiUtil.getLanguageLevel(reference)));
                    if (signature == null || !isArray && (containingClass.getContainingClass() == null || !MethodReferenceResolver.isLocatedInStaticContext(containingClass, reference)) && signature.getParameterTypes().length == 0 || isArray && MethodReferenceResolver.arrayCreationSignature(signature)) {
                        candidateInfo = new ClassCandidateInfo(containingClass, substitutor2);
                    }
                    if (candidateInfo == null) {
                        javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
                    } else {
                        JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
                        javaResolveResultArray = javaResolveResultArray2;
                        javaResolveResultArray2[0] = candidateInfo;
                    }
                    if (javaResolveResultArray == null) {
                        MethodReferenceResolver.$$$reportNull$$$0(3);
                    }
                    return javaResolveResultArray;
                }
                PsiConflictResolver conflictResolver = this.createResolver(reference, qualifierResolveResult, interfaceMethod, signature);
                MethodCandidatesProcessor processor2 = new MethodCandidatesProcessor(reference, containingFile, new PsiConflictResolver[]{conflictResolver}, new SmartList()){

                    @Override
                    protected boolean acceptVarargs() {
                        return true;
                    }

                    @Override
                    protected MethodCandidateInfo createCandidateInfo(final @NotNull PsiMethod method, final @NotNull PsiSubstitutor substitutor2, boolean staticProblem, boolean accessible, final boolean varargs) {
                        if (method == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (substitutor2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        PsiExpressionList argumentList2 = this.getArgumentList();
                        PsiType[] typeParameters2 = reference.getTypeParameters();
                        return new MethodCandidateInfo(method, substitutor2, !accessible, staticProblem, argumentList2, this.myCurrentFileContext, argumentList2 != null ? argumentList2.getExpressionTypes() : null, method.hasTypeParameters() && typeParameters2.length > 0 ? typeParameters2 : null, this.getLanguageLevel()){

                            @Override
                            public boolean isVarargs() {
                                return varargs;
                            }

                            @Override
                            @NotNull
                            public PsiSubstitutor inferTypeArguments(@NotNull ParameterTypeInferencePolicy policy, boolean includeReturnConstraint) {
                                if (policy == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                PsiSubstitutor psiSubstitutor = this.inferTypeArguments(includeReturnConstraint);
                                if (psiSubstitutor == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                return psiSubstitutor;
                            }

                            private PsiSubstitutor inferTypeArguments(boolean includeReturnConstraint) {
                                if (interfaceMethod == null) {
                                    return substitutor2;
                                }
                                InferenceSession session = new InferenceSession(method.getTypeParameters(), substitutor2, reference.getManager(), reference);
                                session.initThrowsConstraints(method);
                                PsiSubstitutor psiSubstitutor = session.collectApplicabilityConstraints(reference, this, functionalInterfaceType);
                                if (psiSubstitutor != null) {
                                    return psiSubstitutor;
                                }
                                if (!session.repeatInferencePhases()) {
                                    List<String> errorMessages = session.getIncompatibleErrorMessages();
                                    if (errorMessages != null) {
                                        this.setApplicabilityError(StringUtil.join(errorMessages, "\n"));
                                    }
                                    return substitutor2;
                                }
                                if (includeReturnConstraint && !PsiType.VOID.equals(interfaceMethodReturnType) && interfaceMethodReturnType != null) {
                                    PsiType returnType2;
                                    PsiSubstitutor subst = PsiMethodReferenceCompatibilityConstraint.getSubstitutor(signature, qualifierResolveResult, method, containingClass, reference);
                                    PsiType psiType = returnType2 = method.isConstructor() ? MethodReferenceResolver.composeReturnType(containingClass, subst) : subst.substitute(method.getReturnType());
                                    if (returnType2 != null) {
                                        session.registerReturnTypeConstraints(returnType2, interfaceMethodReturnType, reference);
                                    }
                                }
                                return session.infer(method.getParameterList().getParameters(), null, null);
                            }

                            @Override
                            public boolean isApplicable() {
                                boolean hasReceiver;
                                if (signature == null) {
                                    return false;
                                }
                                if (this.getInferenceErrorMessageAssumeAlreadyComputed() != null) {
                                    return false;
                                }
                                PsiType[] argTypes = signature.getParameterTypes();
                                return MethodReferenceConflictResolver.isApplicableByFirstSearch(this, argTypes, hasReceiver = PsiMethodReferenceUtil.isSecondSearchPossible(argTypes, qualifierResolveResult, reference), reference, interfaceMethod.isVarArgs(), interfaceMethod) != null;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                RuntimeException runtimeException;
                                Object[] objectArray;
                                Object[] objectArray2;
                                int n2;
                                String string;
                                switch (n) {
                                    default: {
                                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                        break;
                                    }
                                    case 1: {
                                        string = "@NotNull method %s.%s must not return null";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        n2 = 3;
                                        break;
                                    }
                                    case 1: {
                                        n2 = 2;
                                        break;
                                    }
                                }
                                Object[] objectArray3 = new Object[n2];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "policy";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$1$1";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$1$1";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "inferTypeArguments";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray;
                                        objectArray[2] = "inferTypeArguments";
                                        break;
                                    }
                                    case 1: {
                                        break;
                                    }
                                }
                                String string2 = String.format(string, objectArray);
                                switch (n) {
                                    default: {
                                        runtimeException = new IllegalArgumentException(string2);
                                        break;
                                    }
                                    case 1: {
                                        runtimeException = new IllegalStateException(string2);
                                        break;
                                    }
                                }
                                throw runtimeException;
                            }
                        };
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "method";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "substitutor";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$1";
                        objectArray[2] = "createCandidateInfo";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                processor2.setIsConstructor(isConstructor);
                processor2.setName(isConstructor ? containingClass.getName() : element.getText());
                PsiExpression expression2 = reference.getQualifierExpression();
                if (expression2 == null || !(expression2.getType() instanceof PsiArrayType)) {
                    processor2.setAccessClass(containingClass);
                }
                if (qualifierResolveResult.isReferenceTypeQualified() && MethodReferenceResolver.isLocatedInStaticContext(containingClass, reference)) {
                    processor2.handleEvent(JavaScopeProcessorEvent.START_STATIC, null);
                }
                ResolveState state2 = ResolveState.initial().put(PsiSubstitutor.KEY, substitutor2);
                containingClass.processDeclarations(processor2, state2, reference, reference);
                JavaResolveResult[] javaResolveResultArray = processor2.getResult();
                if (javaResolveResultArray == null) {
                    MethodReferenceResolver.$$$reportNull$$$0(4);
                }
                return javaResolveResultArray;
            }
        }
        if (JavaResolveResult.EMPTY_ARRAY == null) {
            MethodReferenceResolver.$$$reportNull$$$0(5);
        }
        return JavaResolveResult.EMPTY_ARRAY;
    }

    public static boolean canBeConstructed(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            MethodReferenceResolver.$$$reportNull$$$0(6);
        }
        return !psiClass.isEnum() && !psiClass.hasModifierProperty("abstract") && !(psiClass instanceof PsiTypeParameter);
    }

    private static boolean isLocatedInStaticContext(PsiClass containingClass, PsiMethodReferenceExpression reference) {
        PsiClass gContainingClass = containingClass.getContainingClass();
        if (gContainingClass == null || !containingClass.hasModifierProperty("static")) {
            PsiClass aClass2 = null;
            if (PsiTreeUtil.isAncestor(gContainingClass != null ? gContainingClass : containingClass, reference, false)) {
                PsiClass psiClass = aClass2 = gContainingClass != null ? gContainingClass : containingClass;
            }
            if (PsiUtil.getEnclosingStaticElement(reference, aClass2) != null) {
                return true;
            }
        }
        return false;
    }

    private static PsiType getInterfaceType(PsiMethodReferenceExpression reference) {
        return reference.getFunctionalInterfaceType();
    }

    protected PsiConflictResolver createResolver(PsiMethodReferenceExpressionImpl referenceExpression, PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, PsiMethod interfaceMethod, MethodSignature signature) {
        return new MethodReferenceConflictResolver(referenceExpression, qualifierResolveResult, signature, interfaceMethod);
    }

    private static PsiClassType composeReturnType(PsiClass containingClass, PsiSubstitutor substitutor2) {
        boolean isRawSubst = PsiUtil.isRawSubstitutor(containingClass, substitutor2);
        return JavaPsiFacade.getElementFactory(containingClass.getProject()).createType(containingClass, isRawSubst ? PsiSubstitutor.EMPTY : substitutor2);
    }

    private static boolean arrayCreationSignature(MethodSignature signature) {
        PsiType[] parameterTypes = signature.getParameterTypes();
        return parameterTypes.length == 1 && parameterTypes[0] != null && TypeConversionUtil.isAssignable(PsiType.INT, parameterTypes[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canBeConstructed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MethodReferenceConflictResolver
    extends JavaMethodsConflictResolver {
        private final MethodSignature mySignature;
        private final PsiMethod myInterfaceMethod;
        private final PsiMethodReferenceExpressionImpl myReferenceExpression;
        private final PsiMethodReferenceUtil.QualifierResolveResult myQualifierResolveResult;
        private final boolean myFunctionalMethodVarArgs;

        private MethodReferenceConflictResolver(PsiMethodReferenceExpressionImpl referenceExpression, PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, @Nullable MethodSignature signature, PsiMethod interfaceMethod) {
            super(referenceExpression, signature != null ? signature.getParameterTypes() : PsiType.EMPTY_ARRAY, PsiUtil.getLanguageLevel(referenceExpression));
            this.myReferenceExpression = referenceExpression;
            this.myQualifierResolveResult = qualifierResolveResult;
            this.myFunctionalMethodVarArgs = interfaceMethod != null && interfaceMethod.isVarArgs();
            this.mySignature = signature;
            this.myInterfaceMethod = interfaceMethod;
        }

        @Override
        protected int getPertinentApplicabilityLevel(@NotNull MethodCandidateInfo conflict) {
            if (conflict == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(0);
            }
            return conflict.isVarargs() ? 2 : 3;
        }

        @Override
        @Nullable
        protected CandidateInfo guardedOverloadResolution(@NotNull List<CandidateInfo> conflicts) {
            CandidateInfo candidateInfo;
            if (conflicts == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(1);
            }
            if (this.mySignature == null) {
                return null;
            }
            if (conflicts.isEmpty()) {
                return null;
            }
            if (conflicts.size() == 1) {
                return conflicts.get(0);
            }
            this.checkSameSignatures(conflicts);
            if (conflicts.size() == 1) {
                return conflicts.get(0);
            }
            MethodReferenceConflictResolver.checkAccessStaticLevels(conflicts, true);
            if (conflicts.size() == 1) {
                return conflicts.get(0);
            }
            PsiType[] argTypes = this.mySignature.getParameterTypes();
            boolean hasReceiver = PsiMethodReferenceUtil.isSecondSearchPossible(argTypes, this.myQualifierResolveResult, this.myReferenceExpression);
            ArrayList<CandidateInfo> firstCandidates = new ArrayList<CandidateInfo>();
            ArrayList<CandidateInfo> secondCandidates = new ArrayList<CandidateInfo>();
            for (CandidateInfo conflict : conflicts) {
                Boolean applicableByFirstSearch;
                if (!(conflict instanceof MethodCandidateInfo) || (applicableByFirstSearch = MethodReferenceConflictResolver.isApplicableByFirstSearch(conflict, argTypes, hasReceiver, this.myReferenceExpression, this.myFunctionalMethodVarArgs, this.myInterfaceMethod)) == null) continue;
                (applicableByFirstSearch != false ? firstCandidates : secondCandidates).add(conflict);
            }
            if (this.myQualifierResolveResult.isReferenceTypeQualified() && this.myReferenceExpression.getReferenceNameElement() instanceof PsiIdentifier) {
                candidateInfo = MethodReferenceConflictResolver.filterStaticCorrectCandidates(firstCandidates, secondCandidates, true);
                if (candidateInfo != null) {
                    return candidateInfo;
                }
                candidateInfo = MethodReferenceConflictResolver.filterStaticCorrectCandidates(secondCandidates, firstCandidates, false);
                if (candidateInfo != null) {
                    return candidateInfo;
                }
            }
            if ((candidateInfo = this.resolveConflicts(firstCandidates, secondCandidates, 3)) != null) {
                return candidateInfo;
            }
            candidateInfo = this.resolveConflicts(firstCandidates, secondCandidates, 2);
            if (candidateInfo != null) {
                return candidateInfo;
            }
            if (firstCandidates.isEmpty() && secondCandidates.isEmpty()) {
                return null;
            }
            conflicts.clear();
            firstCandidates.addAll(secondCandidates);
            conflicts.addAll(firstCandidates);
            return null;
        }

        private static Boolean isApplicableByFirstSearch(CandidateInfo conflict, PsiType[] functionalInterfaceParamTypes, boolean hasReceiver, PsiMethodReferenceExpression referenceExpression, boolean functionalMethodVarArgs, PsiMethod interfaceMethod) {
            PsiMethod psiMethod = ((MethodCandidateInfo)conflict).getElement();
            PsiSubstitutor substitutor2 = ((MethodCandidateInfo)conflict).getSubstitutor(false);
            if (((MethodCandidateInfo)conflict).getInferenceErrorMessage() != null) {
                return null;
            }
            PsiType[] parameterTypes = psiMethod.getSignature(substitutor2).getParameterTypes();
            boolean varargs = ((MethodCandidateInfo)conflict).isVarargs();
            if (varargs && (!psiMethod.isVarArgs() || functionalMethodVarArgs)) {
                return null;
            }
            if ((varargs || functionalInterfaceParamTypes.length == parameterTypes.length) && MethodReferenceConflictResolver.isCorrectAssignment(parameterTypes, functionalInterfaceParamTypes, interfaceMethod, varargs, referenceExpression, conflict, 0)) {
                return true;
            }
            if (hasReceiver && (varargs || functionalInterfaceParamTypes.length == parameterTypes.length + 1) && MethodReferenceConflictResolver.isCorrectAssignment(parameterTypes, functionalInterfaceParamTypes, interfaceMethod, varargs, referenceExpression, conflict, 1)) {
                return false;
            }
            return null;
        }

        private static boolean isCorrectAssignment(PsiType[] parameterTypes, PsiType[] functionalInterfaceParamTypes, PsiMethod interfaceMethod, boolean varargs, PsiMethodReferenceExpression referenceExpression, CandidateInfo conflict, int offset2) {
            int min = Math.min(parameterTypes.length, functionalInterfaceParamTypes.length - offset2);
            for (int i = 0; i < min; ++i) {
                PsiType argType = PsiUtil.captureToplevelWildcards(functionalInterfaceParamTypes[i + offset2], interfaceMethod.getParameterList().getParameters()[i]);
                PsiType parameterType = parameterTypes[i];
                if (varargs && i == parameterTypes.length - 1) {
                    if (TypeConversionUtil.isAssignable(parameterType, argType) || TypeConversionUtil.isAssignable(((PsiArrayType)parameterType).getComponentType(), argType)) continue;
                    MethodReferenceConflictResolver.reportParameterConflict(referenceExpression, conflict, argType, parameterType);
                    return false;
                }
                if (TypeConversionUtil.isAssignable(parameterType, argType)) continue;
                MethodReferenceConflictResolver.reportParameterConflict(referenceExpression, conflict, argType, parameterType);
                return false;
            }
            return !varargs || parameterTypes.length - 1 <= functionalInterfaceParamTypes.length - offset2;
        }

        private static void reportParameterConflict(PsiMethodReferenceExpression referenceExpression, CandidateInfo conflict, PsiType argType, PsiType parameterType) {
            if (conflict instanceof MethodCandidateInfo) {
                ((MethodCandidateInfo)conflict).setApplicabilityError("Invalid " + (referenceExpression.isConstructor() ? "constructor" : "method") + " reference: " + argType.getPresentableText() + " cannot be converted to " + parameterType.getPresentableText());
            }
        }

        private CandidateInfo resolveConflicts(List<CandidateInfo> firstCandidates, List<CandidateInfo> secondCandidates, int applicabilityLevel) {
            int firstApplicability = this.checkApplicability(firstCandidates);
            this.checkSpecifics(firstCandidates, applicabilityLevel, this.myLanguageLevel);
            int secondApplicability = this.checkApplicability(secondCandidates);
            this.checkSpecifics(secondCandidates, applicabilityLevel, this.myLanguageLevel);
            if (firstApplicability < secondApplicability) {
                return secondCandidates.size() == 1 ? secondCandidates.get(0) : null;
            }
            if (secondApplicability < firstApplicability) {
                return firstCandidates.size() == 1 ? firstCandidates.get(0) : null;
            }
            return firstCandidates.size() + secondCandidates.size() == 1 ? (firstCandidates.isEmpty() ? secondCandidates.get(0) : firstCandidates.get(0)) : null;
        }

        @Override
        protected boolean nonComparable(@NotNull CandidateInfo method, @NotNull CandidateInfo conflict, boolean fixedArity) {
            if (method == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(2);
            }
            if (conflict == null) {
                MethodReferenceConflictResolver.$$$reportNull$$$0(3);
            }
            if (method == conflict) {
                return true;
            }
            PsiElement psiElement = method.getElement();
            PsiElement conflictElement = conflict.getElement();
            return psiElement instanceof PsiMethod && conflictElement instanceof PsiMethod && fixedArity && ((PsiMethod)psiElement).getParameterList().getParametersCount() != ((PsiMethod)conflictElement).getParameterList().getParametersCount();
        }

        private static CandidateInfo filterStaticCorrectCandidates(List<CandidateInfo> firstCandidates, List<CandidateInfo> secondCandidates, boolean shouldBeStatic) {
            boolean isStatic;
            CandidateInfo candidateInfo;
            PsiElement element;
            if (firstCandidates.size() == 1 && (element = (candidateInfo = firstCandidates.get(0)).getElement()) instanceof PsiMethod && shouldBeStatic == (isStatic = ((PsiMethod)element).hasModifierProperty("static"))) {
                for (CandidateInfo secondCandidate : secondCandidates) {
                    boolean oppositeStatic;
                    PsiElement psiElement = secondCandidate.getElement();
                    if (!(psiElement instanceof PsiMethod) || shouldBeStatic == (oppositeStatic = ((PsiMethod)psiElement).hasModifierProperty("static"))) continue;
                    return null;
                }
                return candidateInfo;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conflict";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conflicts";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$MethodReferenceConflictResolver";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPertinentApplicabilityLevel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "guardedOverloadResolution";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nonComparable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

