/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.io.ResourceHandle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public abstract class FileAccessorCache<K, T>
implements EqualityPolicy<K> {
    private final SLRUMap<K, Handle<T>> myCache;
    private final List<T> myElementsToBeDisposed = new ArrayList<T>();
    private final Object myCacheLock = new Object();
    private final Object myUpdateLock = new Object();

    public FileAccessorCache(int protectedQueueSize, int probationalQueueSize) {
        this.myCache = new SLRUMap<K, Handle<T>>(protectedQueueSize, probationalQueueSize, this){

            @Override
            protected final void onDropFromCache(K key, Handle<T> value) {
                value.release();
            }
        };
    }

    protected abstract T createAccessor(K var1) throws IOException;

    protected abstract void disposeAccessor(T var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final Handle<T> get(K key) {
        Handle<T> cached = this.getIfCached(key);
        if (cached != null) {
            Handle<T> handle = cached;
            if (handle != null) return handle;
            FileAccessorCache.$$$reportNull$$$0(0);
            return handle;
        }
        Object object = this.myUpdateLock;
        // MONITORENTER : object
        cached = this.getIfCached(key);
        if (cached != null) {
            Handle<T> handle = cached;
            // MONITOREXIT : object
            if (handle != null) return handle;
            FileAccessorCache.$$$reportNull$$$0(1);
            return handle;
        }
        Handle<T> handle = this.createHandle(key);
        // MONITOREXIT : object
        if (handle != null) return handle;
        FileAccessorCache.$$$reportNull$$$0(2);
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Handle<T> createHandle(K key) {
        Handle<T> handle;
        try {
            Handle<T> cached = new Handle<T>(this.createAccessor(key), this);
            cached.allocate();
            Object object = this.myCacheLock;
            synchronized (object) {
                this.myCache.put(key, cached);
            }
            this.disposeInvalidAccessors();
            handle = cached;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (handle == null) {
            FileAccessorCache.$$$reportNull$$$0(3);
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeInvalidAccessors() {
        ArrayList<T> fileAccessorsToBeDisposed;
        Iterator iterator2 = this.myCacheLock;
        synchronized (iterator2) {
            if (this.myElementsToBeDisposed.isEmpty()) {
                return;
            }
            fileAccessorsToBeDisposed = new ArrayList<T>(this.myElementsToBeDisposed);
            this.myElementsToBeDisposed.clear();
        }
        for (Object t : fileAccessorsToBeDisposed) {
            try {
                this.disposeAccessor(t);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handle<T> getIfCached(K key) {
        Object object = this.myCacheLock;
        synchronized (object) {
            Handle<T> value = this.myCache.get(key);
            if (value != null) {
                value.allocate();
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key) {
        try {
            Object object = this.myCacheLock;
            synchronized (object) {
                boolean bl = this.myCache.remove(key);
                return bl;
            }
        }
        finally {
            Object object = this.myUpdateLock;
            synchronized (object) {
                this.disposeInvalidAccessors();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object;
        try {
            object = this.myCacheLock;
            synchronized (object) {
                this.myCache.clear();
            }
        }
        finally {
            object = this.myUpdateLock;
            synchronized (object) {
                this.disposeInvalidAccessors();
            }
        }
    }

    @Override
    public int getHashCode(K value) {
        return value.hashCode();
    }

    @Override
    public boolean isEqual(K val1, K val2) {
        return val1.equals(val2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/io/FileAccessorCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createHandle";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static final class Handle<T>
    extends ResourceHandle<T> {
        private final FileAccessorCache<?, T> myOwner;
        private final T myResource;
        private final AtomicInteger myRefCount = new AtomicInteger(1);

        public Handle(T fileAccessor, FileAccessorCache<?, T> owner) {
            this.myResource = fileAccessor;
            this.myOwner = owner;
        }

        public void allocate() {
            this.myRefCount.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void release() {
            if (this.myRefCount.decrementAndGet() == 0) {
                Object object = ((FileAccessorCache)this.myOwner).myCacheLock;
                synchronized (object) {
                    ((FileAccessorCache)this.myOwner).myElementsToBeDisposed.add(this.myResource);
                }
            }
        }

        @Override
        public void close() {
            this.release();
        }

        @Override
        public T get() {
            return this.myResource;
        }
    }
}

