/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.ArrayAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.DefaultAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.QualifiedExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

public final class AccessTranslationUtils {
    private AccessTranslationUtils() {
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull KtExpression referenceExpression, @NotNull TranslationContext context) {
        return AccessTranslationUtils.getAccessTranslator(referenceExpression, context, false);
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull KtExpression referenceExpression, @NotNull TranslationContext context, boolean forceOrderOfEvaluation) {
        referenceExpression = KtPsiUtil.deparenthesize(referenceExpression);
        assert (referenceExpression != null);
        if (referenceExpression instanceof KtQualifiedExpression) {
            return QualifiedExpressionTranslator.getAccessTranslator((KtQualifiedExpression)referenceExpression, context, forceOrderOfEvaluation);
        }
        if (referenceExpression instanceof KtSimpleNameExpression) {
            return ReferenceTranslator.getAccessTranslator((KtSimpleNameExpression)referenceExpression, context);
        }
        if (referenceExpression instanceof KtArrayAccessExpression) {
            return AccessTranslationUtils.getArrayAccessTranslator((KtArrayAccessExpression)referenceExpression, context, forceOrderOfEvaluation);
        }
        return new DefaultAccessTranslator(referenceExpression, context);
    }

    @NotNull
    private static AccessTranslator getArrayAccessTranslator(@NotNull KtArrayAccessExpression expression2, @NotNull TranslationContext context, boolean forceOrderOfEvaluation) {
        TranslationContext accessArrayContext;
        if (forceOrderOfEvaluation) {
            LinkedHashMap<KtExpression, JsExpression> indexesMap = new LinkedHashMap<KtExpression, JsExpression>();
            for (KtExpression indexExpression : expression2.getIndexExpressions()) {
                JsExpression jsIndexExpression = context.cacheExpressionIfNeeded(Translation.translateAsExpression(indexExpression, context));
                indexesMap.put(indexExpression, jsIndexExpression);
            }
            accessArrayContext = context.innerContextWithAliasesForExpressions(indexesMap);
        } else {
            accessArrayContext = context;
        }
        return ArrayAccessTranslator.newInstance(expression2, accessArrayContext);
    }

    @NotNull
    public static JsExpression translateAsGet(@NotNull KtExpression expression2, @NotNull TranslationContext context) {
        return AccessTranslationUtils.getAccessTranslator(expression2, context).translateAsGet();
    }
}

