/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KtCallExpression
extends KtExpressionImpl
implements KtCallElement,
KtReferenceExpression {
    public KtCallExpression(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        return visitor2.visitCallExpression(this, data);
    }

    @Override
    @Nullable
    public KtExpression getCalleeExpression() {
        return this.findChildByClass(KtExpression.class);
    }

    @Override
    @Nullable
    public KtValueArgumentList getValueArgumentList() {
        return (KtValueArgumentList)this.findChildByType(KtNodeTypes.VALUE_ARGUMENT_LIST);
    }

    @Override
    @Nullable
    public KtTypeArgumentList getTypeArgumentList() {
        return (KtTypeArgumentList)this.findChildByType(KtNodeTypes.TYPE_ARGUMENT_LIST);
    }

    @Override
    @NotNull
    public List<KtLambdaArgument> getLambdaArguments() {
        return this.findChildrenByType(KtNodeTypes.LAMBDA_ARGUMENT);
    }

    @NotNull
    public List<KtValueArgument> getValueArguments() {
        KtValueArgumentList list2 = this.getValueArgumentList();
        List<KtValueArgument> valueArgumentsInParentheses = list2 != null ? list2.getArguments() : Collections.emptyList();
        List<KtLambdaArgument> functionLiteralArguments = this.getLambdaArguments();
        if (functionLiteralArguments.isEmpty()) {
            return valueArgumentsInParentheses;
        }
        ArrayList<KtValueArgument> allValueArguments2 = Lists.newArrayList();
        allValueArguments2.addAll(valueArgumentsInParentheses);
        allValueArguments2.addAll(functionLiteralArguments);
        return allValueArguments2;
    }

    @Override
    @NotNull
    public List<KtTypeProjection> getTypeArguments() {
        KtTypeArgumentList list2 = this.getTypeArgumentList();
        return list2 != null ? list2.getArguments() : Collections.emptyList();
    }
}

