/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script.util.resolvers;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.script.util.DependsOn;
import org.jetbrains.kotlin.script.util.Repository;
import org.jetbrains.kotlin.script.util.resolvers.BasicKt;
import org.jetbrains.kotlin.script.util.resolvers.Resolver;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0007j\b\u0012\u0004\u0012\u00020\u0004`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/script/util/resolvers/FlatLibDirectoryResolver;", "Lorg/jetbrains/kotlin/script/util/resolvers/Resolver;", "paths", "", "Ljava/io/File;", "([Ljava/io/File;)V", "localRepos", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "tryAddRepo", "", "annotation", "Lorg/jetbrains/kotlin/script/util/Repository;", "tryResolve", "", "dependsOn", "Lorg/jetbrains/kotlin/script/util/DependsOn;", "Companion", "kotlin-script-util"})
public final class FlatLibDirectoryResolver
implements Resolver {
    private final ArrayList<File> localRepos;
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public Iterable<File> tryResolve(@NotNull DependsOn dependsOn) {
        Intrinsics.checkParameterIsNotNull((Object)dependsOn, (String)"dependsOn");
        for (File path : this.localRepos) {
            Object res;
            Object object;
            Object object2 = dependsOn.value();
            Object p1 = object2;
            Object object3 = !StringsKt.isBlank((CharSequence)((CharSequence)p1)) ? object2 : null;
            if (object3 != null) {
                Object it = object2 = object3;
                object2 = new File(path, (String)it);
                object = ((File)(it = object2)).exists() && (((File)it).isFile() || ((File)it).isDirectory()) ? object2 : null;
            } else {
                object = null;
            }
            if ((res = object) == null) continue;
            return CollectionsKt.listOf(res);
        }
        return null;
    }

    @Override
    public boolean tryAddRepo(@NotNull Repository annotation) {
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        String string = annotation.url();
        Object it2 = string;
        CharSequence charSequence = (CharSequence)it2;
        String string2 = !StringsKt.isBlank((CharSequence)charSequence) ? string : null;
        if (string2 == null) {
            string = annotation.value();
            it2 = string;
            charSequence = (CharSequence)it2;
            string2 = !StringsKt.isBlank((CharSequence)charSequence) ? string : null;
        }
        if (string2 == null) {
            return false;
        }
        String urlStr = string2;
        Object object = BasicKt.toRepositoryUrlOrNull(urlStr);
        String dirFromUrl = object != null && (object = Intrinsics.areEqual((Object)((URL)(it = (it2 = object))).getProtocol(), (Object)"file") ? it2 : null) != null ? ((URL)object).getPath() : null;
        String string3 = dirFromUrl;
        if (string3 == null) {
            string3 = urlStr;
        }
        File file = BasicKt.toRepositoryFileOrNull(string3);
        if (file == null) {
            return false;
        }
        File repoDir = file;
        this.localRepos.add(repoDir);
        return true;
    }

    public FlatLibDirectoryResolver(File ... paths) {
        Intrinsics.checkParameterIsNotNull((Object)paths, (String)"paths");
        FlatLibDirectoryResolver flatLibDirectoryResolver = this;
        ArrayList arrayList = new ArrayList();
        flatLibDirectoryResolver.localRepos = arrayList;
        for (File path : paths) {
            if (path.exists() && path.isDirectory()) continue;
            throw (Throwable)new IllegalArgumentException("Invalid flat lib directory repository path '" + path + '\'');
        }
        CollectionsKt.addAll((Collection)this.localRepos, (Object[])paths);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/script/util/resolvers/FlatLibDirectoryResolver$Companion;", "", "()V", "tryCreate", "Lorg/jetbrains/kotlin/script/util/resolvers/FlatLibDirectoryResolver;", "annotation", "Lorg/jetbrains/kotlin/script/util/Repository;", "kotlin-script-util"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final FlatLibDirectoryResolver tryCreate(@NotNull Repository annotation) {
            Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
            Object object = annotation.value();
            String p1 = object;
            if (StringsKt.isBlank((CharSequence)p1)) return null;
            String string = object;
            Object object2 = string;
            if (string == null) return null;
            object = object2;
            p1 = object;
            object = new File(p1);
            Object it = object;
            if (!((File)it).exists()) return null;
            if (!((File)it).isDirectory()) return null;
            boolean bl = true;
            if (!bl) return null;
            Object object3 = object;
            object2 = object3;
            if (object3 == null) return null;
            it = object = object2;
            FlatLibDirectoryResolver flatLibDirectoryResolver = new FlatLibDirectoryResolver(new File[]{it});
            return flatLibDirectoryResolver;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

