/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.phrasetable;

import edu.berkeley.nlp.lm.StringWordIndexer;
import edu.berkeley.nlp.lm.WordIndexer;
import edu.berkeley.nlp.lm.map.HashNgramMap;
import edu.berkeley.nlp.lm.phrasetable.MosesPhraseTableReader;
import edu.berkeley.nlp.lm.phrasetable.MosesPhraseTableReaderCallback;
import edu.berkeley.nlp.lm.phrasetable.PhraseTableValueContainer;
import edu.berkeley.nlp.lm.util.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MosesPhraseTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final HashNgramMap<PhraseTableValueContainer.PhraseTableValues> map;
    private final WordIndexer<String> wordIndexer;

    public static MosesPhraseTable readFromFile(String file) {
        StringWordIndexer stringWordIndexer = new StringWordIndexer();
        MosesPhraseTableReaderCallback<String> callback = new MosesPhraseTableReaderCallback<String>(stringWordIndexer);
        new MosesPhraseTableReader<String>(file, stringWordIndexer).parse(callback);
        return new MosesPhraseTable(callback.getMap(), stringWordIndexer);
    }

    private MosesPhraseTable(HashNgramMap<PhraseTableValueContainer.PhraseTableValues> map, WordIndexer<String> wordIndexer) {
        this.map = map;
        this.wordIndexer = wordIndexer;
    }

    public List<TargetSideTranslation> getTranslations(int[] src, int startPos, int endPos) {
        long offsetForNgram = this.map.getOffsetForNgramInModel(src, startPos, endPos);
        if (offsetForNgram < 0L) {
            return Collections.emptyList();
        }
        PhraseTableValueContainer.TargetTranslationsValues scratch = new PhraseTableValueContainer.TargetTranslationsValues();
        this.map.getValues().getFromOffset(offsetForNgram, endPos - startPos - 1, scratch);
        ArrayList<TargetSideTranslation> ret = new ArrayList<TargetSideTranslation>();
        for (int i = 0; i < scratch.targetTranslationOffsets.length; ++i) {
            int sepIndex;
            PhraseTableValueContainer.FeaturePhraseTableValues features = new PhraseTableValueContainer.FeaturePhraseTableValues(null);
            long currOffset = scratch.targetTranslationOffsets[i];
            int currOrder = scratch.targetTranslationOrders[i];
            this.map.getValues().getFromOffset(currOffset, currOrder, features);
            if (features.features == null) {
                Logger.warn("Should probably fix");
                continue;
            }
            TargetSideTranslation tr = new TargetSideTranslation();
            tr.features = Arrays.copyOf(features.features, features.features.length);
            int[] srcAndTrg = this.map.getNgramForOffset(currOffset, currOrder);
            for (sepIndex = 0; sepIndex < srcAndTrg.length && srcAndTrg[sepIndex] != ((PhraseTableValueContainer)this.map.getValues()).getSeparatorWord(); ++sepIndex) {
            }
            tr.trgWords = Arrays.copyOfRange(srcAndTrg, sepIndex + 1, srcAndTrg.length);
            assert (tr.trgWords.length > 0);
            ret.add(tr);
        }
        return ret;
    }

    public WordIndexer<String> getWordIndexer() {
        return this.wordIndexer;
    }

    public static class TargetSideTranslation {
        public float[] features;
        public int[] trgWords;

        public String toString() {
            return Arrays.toString(this.trgWords) + " :: " + Arrays.toString(this.features);
        }
    }
}

