/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect.ngram;

import com.optimaize.langdetect.ngram.NgramFilter;

public class StandardNgramFilter
implements NgramFilter {
    private static final StandardNgramFilter INSTANCE = new StandardNgramFilter();

    public static NgramFilter getInstance() {
        return INSTANCE;
    }

    private StandardNgramFilter() {
    }

    @Override
    public boolean use(String ngram) {
        switch (ngram.length()) {
            case 1: {
                return ngram.charAt(0) != ' ';
            }
            case 2: {
                return true;
            }
            case 3: {
                return ngram.charAt(1) != ' ';
            }
            case 4: {
                return ngram.charAt(1) != ' ' && ngram.charAt(2) != ' ';
            }
        }
        throw new UnsupportedOperationException("Unsupported n-gram length: " + ngram.length());
    }
}

