/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.repository.extractors;

import com.google.common.base.Optional;
import java.io.InputStream;
import java.net.URI;
import org.protege.editor.owl.model.io.IOUtils;
import org.protege.editor.owl.model.repository.extractors.OntologyIdExtractor;
import org.protege.editor.owl.model.repository.extractors.RdfExtractorConsumer;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFConsumer;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class RdfXmlExtractor
implements OntologyIdExtractor {
    private final Logger logger = LoggerFactory.getLogger(RdfXmlExtractor.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<OWLOntologyID> getOntologyId(URI location) {
        RdfExtractorConsumer consumer = new RdfExtractorConsumer();
        RDFParser parser = new RDFParser();
        try (InputStream iStream = IOUtils.getInputStream(location, true, 30000);){
            InputSource is = new InputSource(iStream);
            is.setSystemId(location.toURL().toString());
            parser.parse(is, (RDFConsumer)consumer);
            Optional<OWLOntologyID> optional = consumer.getOntologyID();
            return optional;
        }
        catch (Throwable t) {
            this.logger.debug("Exception caught trying to extract ontology from rdf file at  " + location, t);
            return Optional.absent();
        }
    }
}

