/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.layout;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.io.File;
import java.net.URI;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.protege.editor.owl.ui.renderer.layout.Alignment;
import org.protege.editor.owl.ui.renderer.layout.BulletIcon;
import org.protege.editor.owl.ui.renderer.layout.FileLink;
import org.protege.editor.owl.ui.renderer.layout.HTTPLink;
import org.protege.editor.owl.ui.renderer.layout.Line;
import org.protege.editor.owl.ui.renderer.layout.Link;
import org.protege.editor.owl.ui.renderer.layout.LinkSpan;
import org.protege.editor.owl.ui.renderer.layout.PageObject;
import org.protege.editor.owl.ui.renderer.layout.Span;

public class Paragraph
extends PageObject {
    public static final int TAB_SIZE = 40;
    private AttributedString paragraphText;
    private String plainText;
    private boolean wrapText = true;
    private List<LinkSpan> linkSpans = new ArrayList<LinkSpan>();
    private Alignment alignment = Alignment.LEFT;
    private Icon icon;
    private Icon bulletIcon;
    private Set<LinkSpan> highlightedLinkSpan = new HashSet<LinkSpan>();

    public Paragraph(String paragraphText) {
        this(new AttributedString(paragraphText));
    }

    public Paragraph(String paragraphText, Link link) {
        this(new AttributedString(paragraphText), Arrays.asList(new LinkSpan(link, new Span(0, paragraphText.length()))));
    }

    public Paragraph(String paragraphText, List<LinkSpan> linkSpans) {
        this(new AttributedString(paragraphText), linkSpans);
    }

    private Paragraph(AttributedString paragraphText) {
        this(paragraphText, Collections.emptyList());
    }

    private Paragraph(AttributedString paragraphText, List<LinkSpan> linkSpans) {
        this.paragraphText = paragraphText;
        Font font = OWLRendererPreferences.getInstance().getFont();
        this.paragraphText.addAttribute(TextAttribute.FAMILY, font.getFamily());
        this.linkSpans.addAll(linkSpans);
        this.computePlainString();
        int fontSize = OWLRendererPreferences.getInstance().getFontSize();
        this.setSize(fontSize);
    }

    public void append(String text, Color foreground) {
        if (text.length() == 0) {
            throw new IllegalArgumentException("text must not be empty");
        }
        AttributedString replacementText = new AttributedString(this.plainText + text);
        replacementText.addAttributes(this.paragraphText.getIterator().getAttributes(), 0, this.plainText.length());
        AttributedCharacterIterator charIt = this.paragraphText.getIterator();
        while (charIt.current() != '\uffff') {
            replacementText.addAttributes(charIt.getAttributes(), charIt.getIndex(), charIt.getEndIndex() + 1);
            charIt.next();
        }
        replacementText.addAttribute(TextAttribute.FOREGROUND, foreground, this.plainText.length(), this.plainText.length() + text.length());
        this.paragraphText = replacementText;
        this.computePlainString();
        this.invalidateLayout();
    }

    public void append(Number number, Color foreground) {
        this.append(number.toString(), foreground);
    }

    private void computePlainString() {
        char ch;
        StringBuilder sb = new StringBuilder();
        AttributedCharacterIterator iterator = this.paragraphText.getIterator();
        while ((ch = iterator.current()) != '\uffff') {
            sb.append(ch);
            iterator.next();
        }
        this.plainText = sb.toString();
    }

    public boolean isBulletPoint() {
        return this.bulletIcon != null;
    }

    public void setBulletPoint(boolean bulletPoint) {
        this.bulletIcon = bulletPoint ? new BulletIcon() : null;
        this.invalidateLayout();
    }

    public void addLink(LinkSpan linkSpan) {
        this.linkSpans.add(linkSpan);
        this.invalidateLayout();
    }

    public void addLink(Link link) {
        this.linkSpans.add(new LinkSpan(link, new Span(0, this.plainText.length())));
    }

    public void addLink(URI uri) {
        this.addLink(new HTTPLink(uri));
    }

    public void addLink(File file) {
        this.addLink(new FileLink(file));
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void setBold(boolean b) {
        if (b) {
            this.paragraphText.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else {
            this.paragraphText.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
        }
    }

    public void setForeground(Color foreground) {
        this.paragraphText.addAttribute(TextAttribute.FOREGROUND, foreground);
    }

    public void setSize(int size) {
        this.paragraphText.addAttribute(TextAttribute.SIZE, size);
    }

    public void setStrikeThrough(boolean b) {
        this.paragraphText.addAttribute(TextAttribute.STRIKETHROUGH, b);
    }

    public void setStrikeThrough(int start, int end, boolean b) {
        this.paragraphText.addAttribute(TextAttribute.STRIKETHROUGH, b, start, end);
    }

    public int getLength() {
        return this.plainText.length();
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public boolean isWrapText() {
        return this.wrapText;
    }

    public void setWrapText(boolean wrapText) {
        this.wrapText = wrapText;
        this.invalidateLayout();
    }

    public void setTabCount(int tabCount) {
        this.setMarginLeft(tabCount * 40);
    }

    public void increaseTabCount() {
        int marginSize = this.getMarginLeft() + 40;
        this.setMarginLeft(marginSize);
    }

    public AttributedString getParagraphText() {
        return this.paragraphText;
    }

    public String getPlainText() {
        return this.plainText;
    }

    public List<LinkSpan> getLinkSpans() {
        return new ArrayList<LinkSpan>(this.linkSpans);
    }

    @Override
    public void layout(FontRenderContext fontRenderContext) {
        this.clear();
        AttributedString as = this.plainText.isEmpty() ? new AttributedString(" ") : new AttributedString(this.paragraphText.getIterator());
        this.highlightLinks(as);
        AttributedCharacterIterator iterator = as.getIterator();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(iterator, fontRenderContext);
        int iconIndent = this.getBulletWidth() + this.getIconWidth();
        int totalIndent = this.getInsetsLeft() + iconIndent;
        int contentWidth = this.getWidth() - this.getInsetsLeft() - this.getInsetsRight() - iconIndent;
        if (contentWidth > 0) {
            int textHeight;
            int lineOffset = this.getInsetsTop();
            while (lineBreakMeasurer.getPosition() < iterator.getEndIndex()) {
                int lineStart = lineBreakMeasurer.getPosition();
                int nextNewLineIndex = this.plainText.indexOf(10, lineStart + 1);
                int offsetLimit = nextNewLineIndex != -1 ? nextNewLineIndex : this.plainText.length();
                int nextOffset = nextNewLineIndex != -1 ? lineBreakMeasurer.nextOffset(contentWidth, offsetLimit, false) : lineBreakMeasurer.nextOffset(contentWidth, Integer.MAX_VALUE, false);
                lineBreakMeasurer.setPosition(nextOffset);
                int lineEnd = nextOffset;
                Line line = new Line(new AttributedString(iterator, lineStart, lineEnd));
                line.setWidth(contentWidth);
                line.setX(totalIndent);
                line.setY(lineOffset);
                line.layout(fontRenderContext);
                lineOffset += line.getHeight();
                this.add(line);
                for (LinkSpan linkSpan : this.linkSpans) {
                    if (!linkSpan.getSpan().intersectsWith(new Span(lineStart, lineEnd))) continue;
                    LinkSpan croppedSpan = linkSpan.crop(lineStart, lineEnd);
                    int linkStartIndex = croppedSpan.getSpan().getStartIndex() - lineStart;
                    int linkEndIndex = croppedSpan.getSpan().getEndIndex() - lineStart;
                    line.addLink(linkSpan, linkStartIndex, linkEndIndex);
                }
            }
            int iconHeight = this.getIconHeight();
            int contentHeight = iconHeight > (textHeight = lineOffset) ? iconHeight : textHeight;
            this.setHeight(this.getInsetsTop() + contentHeight + this.getInsetsBottom());
        }
    }

    private int getBulletWidth() {
        return this.bulletIcon == null ? 0 : this.bulletIcon.getIconWidth() + 4;
    }

    private int getIconWidth() {
        return this.icon != null ? this.icon.getIconWidth() + 5 : 0;
    }

    private int getIconHeight() {
        return this.icon != null ? this.icon.getIconHeight() : 0;
    }

    @Override
    protected void paintContent(Graphics2D g2) {
        List<PageObject> children;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.bulletIcon != null && !(children = this.getChildren()).isEmpty()) {
            int firstChildHeight = children.get(0).getHeight();
            this.bulletIcon.paintIcon(null, g2, 0, firstChildHeight / 2 - this.bulletIcon.getIconHeight() / 2);
        }
        if (this.icon != null) {
            this.icon.paintIcon(null, g2, this.getBulletWidth(), 0);
        }
    }

    private void highlightLinks(AttributedString as) {
        for (LinkSpan linkSpan : this.linkSpans) {
            if (!this.highlightedLinkSpan.contains(linkSpan) && linkSpan.getLink().isRollOverLink()) continue;
            as.addAttribute(TextAttribute.FOREGROUND, Color.BLUE, linkSpan.getSpan().getStartIndex(), linkSpan.getSpan().getEndIndex());
            as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL, linkSpan.getSpan().getStartIndex(), linkSpan.getSpan().getEndIndex());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Paragraph(");
        sb.append(this.plainText);
        sb.append(")");
        return sb.toString();
    }
}

