/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.styledstring;

import com.google.common.collect.ImmutableList;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import org.protege.editor.owl.ui.renderer.styledstring.StyledString;
import org.protege.editor.owl.ui.renderer.styledstring.TextLayoutCache;

public class StyledStringLayout {
    private final ImmutableList<TextLayoutCache> textLayoutLines;

    public StyledStringLayout(StyledString styledString) {
        this.textLayoutLines = StyledStringLayout.createLines(styledString);
    }

    private static ImmutableList<TextLayoutCache> createLines(StyledString styledString) {
        if (styledString.isEmpty()) {
            return ImmutableList.of();
        }
        String[] lines = styledString.getString().split("\\n");
        int lineStart = 0;
        ImmutableList.Builder textLayoutLinesBuilder = ImmutableList.builder();
        for (String line : lines) {
            int lineEnd = lineStart + line.length();
            if (line.length() == 0) continue;
            AttributedCharacterIterator iterator = styledString.toAttributedString().getIterator();
            AttributedString attributedLine = new AttributedString(iterator, lineStart, lineEnd);
            textLayoutLinesBuilder.add((Object)new TextLayoutCache(attributedLine));
            lineStart = lineEnd + 1;
        }
        return textLayoutLinesBuilder.build();
    }

    public float getWidth(FontRenderContext fontRenderContext) {
        float maxWidth = 0.0f;
        for (TextLayoutCache cache : this.textLayoutLines) {
            float visibleAdvance = cache.getVisibleAdvance(fontRenderContext);
            if (!(visibleAdvance > maxWidth)) continue;
            maxWidth = visibleAdvance;
        }
        return maxWidth;
    }

    public float getHeight(FontRenderContext fontRenderContext) {
        float height = 0.0f;
        for (TextLayoutCache textLayoutCache : this.textLayoutLines) {
            height += textLayoutCache.getHeight(fontRenderContext);
        }
        return height;
    }

    public void draw(Graphics2D g2, float x, float y) {
        float yOffset = y;
        float leading = 0.0f;
        float ascent = 0.0f;
        float descent = 0.0f;
        for (TextLayoutCache cache : this.textLayoutLines) {
            FontRenderContext frc = g2.getFontRenderContext();
            TextLayout textLayout = cache.getTextLayout(frc);
            leading = textLayout.getLeading();
            ascent = textLayout.getAscent();
            textLayout.draw(g2, x, yOffset += leading + ascent + descent);
            descent = textLayout.getDescent();
        }
    }
}

