/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.styledstring;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.protege.editor.owl.ui.renderer.styledstring.StyledString;

public class StyledStringSelection
implements Transferable {
    public static final String RTF_MIME_TYPE = "application/rtf";
    public static final String HTML_MIME_TYPE = "text/html";
    public static final String PLAIN_TEXT_MIME_TYPE = "text/plain";
    public static final DataFlavor RTF_DATA_FLAVOR = new DataFlavor("application/rtf", "Rich Text Format (RTF)");
    public static final DataFlavor HTML_DATA_FLAVOR = new DataFlavor("text/html", "Hyper Text Markup Language (HTML)");
    public static final DataFlavor PLAIN_TEXT_DATA_FLAVOR = new DataFlavor("text/plain", "Plain Text");
    private static DataFlavor[] DATA_FLAVORS = new DataFlavor[]{RTF_DATA_FLAVOR, HTML_DATA_FLAVOR, PLAIN_TEXT_DATA_FLAVOR};
    private StyledString styledString;

    public StyledStringSelection(StyledString styledString) {
        this.styledString = styledString;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return DATA_FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        String mimeType = flavor.getMimeType();
        return flavor.isMimeTypeEqual(RTF_MIME_TYPE) || flavor.isMimeTypeEqual(HTML_MIME_TYPE) || flavor.isMimeTypeEqual(PLAIN_TEXT_MIME_TYPE);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        String textRepresentation = flavor.isMimeTypeEqual(RTF_MIME_TYPE) ? this.styledString.toRTF() : (flavor.isMimeTypeEqual(HTML_MIME_TYPE) ? this.styledString.toHTML() : this.styledString.toPlainText());
        if (flavor.getRepresentationClass().equals(String.class)) {
            return textRepresentation;
        }
        if (flavor.getRepresentationClass().equals(InputStream.class)) {
            return new ByteArrayInputStream(textRepresentation.getBytes());
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

