/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.search.SearchResult;
import org.protege.editor.owl.model.search.SearchResultComparator;
import org.protege.editor.owl.model.search.SearchResultSet;

public class SearchResultsTableModel
extends AbstractTableModel {
    public static final int DEFAULT_CATEGORY_SIZE_LIMIT = 10;
    private OWLEditorKit editorKit;
    private int categorySizeLimit = 10;
    private List<ResultsTableModelRow> rows = new ArrayList<ResultsTableModelRow>();

    public SearchResultsTableModel(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
    }

    public void clear() {
        this.rows.clear();
        this.fireTableDataChanged();
    }

    public int getCategorySizeLimit() {
        return this.categorySizeLimit;
    }

    public void setCategorySizeLimit(int categorySizeLimit) {
        if (categorySizeLimit != this.categorySizeLimit) {
            this.categorySizeLimit = categorySizeLimit;
            this.fireTableDataChanged();
        }
    }

    public void clearCategorySizeLimit() {
        if (this.categorySizeLimit != Integer.MAX_VALUE) {
            this.categorySizeLimit = Integer.MAX_VALUE;
            this.fireTableDataChanged();
        }
    }

    public SearchResult getSearchResultAt(int row) {
        ResultsTableModelRow modelRow = this.rows.get(row);
        return modelRow.getSearchResult();
    }

    public void setResultList(Collection<SearchResult> resultList) {
        this.rows.clear();
        SearchResultSet resultSet = new SearchResultSet(resultList);
        for (String category : resultSet.getCategories()) {
            List<SearchResult> categoryResult = resultSet.getCategoryResults(category);
            Collections.sort(categoryResult, new SearchResultComparator(this.editorKit));
            int count = 0;
            int categoryResultsCount = resultSet.getCategoryResultsCount(category);
            for (SearchResult searchResult : categoryResult) {
                this.rows.add(new ResultsTableModelRow(searchResult, count, categoryResultsCount));
                if (++count != this.categorySizeLimit) continue;
                break;
            }
            if (categoryResultsCount <= this.categorySizeLimit) continue;
            this.rows.add(new PlaceHolderRow(categoryResultsCount));
        }
        this.fireTableDataChanged();
    }

    public ResultsTableModelRow getRow(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    public SearchResult getSearchResult(int rowIndex) {
        ResultsTableModelRow row = this.rows.get(rowIndex);
        return row.searchResult;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Found in";
        }
        if (column == 1) {
            return "Entity";
        }
        if (column == 2) {
            return "Match";
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ResultsTableModelRow row = this.rows.get(rowIndex);
        return row.getRenderableObject(columnIndex);
    }

    public boolean isFirstRowInCategory(int rowIndex) {
        return this.rows.get(rowIndex).isFirstRowInCategory();
    }

    private class PlaceHolderRow
    extends ResultsTableModelRow {
        private PlaceHolderRow(int categoryResultCount) {
            super(null, 0, categoryResultCount);
        }

        @Override
        public Object getRenderableObject(int columnIndex) {
            if (columnIndex == 1) {
                return "    + " + (this.getCategoryResultCount() - SearchResultsTableModel.this.categorySizeLimit) + " more results...";
            }
            return "";
        }

        @Override
        public boolean isFirstRowInCategory() {
            return false;
        }
    }

    private class ResultsTableModelRow {
        private SearchResult searchResult;
        private int categoryRowIndex;
        private int categoryResultCount;

        private ResultsTableModelRow(SearchResult searchResult, int categoryRowIndex, int categoryResultCount) {
            this.searchResult = searchResult;
            this.categoryRowIndex = categoryRowIndex;
            this.categoryResultCount = categoryResultCount;
        }

        public SearchResult getSearchResult() {
            return this.searchResult;
        }

        public boolean isFirstRowInCategory() {
            return this.categoryRowIndex == 0;
        }

        public int getCategoryResultCount() {
            return this.categoryResultCount;
        }

        public Object getRenderableObject(int columnIndex) {
            if (columnIndex == 0) {
                return this.searchResult.getGroupDescription();
            }
            if (columnIndex == 1) {
                return this.searchResult.getSubject();
            }
            if (columnIndex == 2) {
                return this.searchResult.getSearchString();
            }
            return "";
        }
    }
}

