/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.HasAnnotations;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.OWLObjectWalker;

public class StructureWalker<O extends OWLObject>
implements OWLObjectVisitor {
    protected final OWLObjectWalker<O> walkerCallback;
    protected final Set<OWLObject> visited = new HashSet<OWLObject>();
    protected final AnnotationWalkingControl annotationWalkFlag;

    public StructureWalker(OWLObjectWalker<O> owlObjectWalker) {
        this(owlObjectWalker, AnnotationWalkingControl.WALK_ONTOLOGY_ANNOTATIONS_ONLY);
    }

    public StructureWalker(OWLObjectWalker<O> owlObjectWalker, AnnotationWalkingControl annotationWalkFlag) {
        this.walkerCallback = owlObjectWalker;
        this.annotationWalkFlag = annotationWalkFlag;
    }

    protected void process(@Nonnull OWLObject object) {
        if (object instanceof OWLAxiom) {
            this.walkerCallback.setAxiom((OWLAxiom)object);
        }
        if (object instanceof OWLAnnotation) {
            this.walkerCallback.setAnnotation((OWLAnnotation)object);
        }
        if (!this.walkerCallback.visitDuplicates) {
            if (!this.visited.contains(object)) {
                this.visited.add(object);
                this.walkerCallback.passToVisitor(object);
            }
        } else {
            this.walkerCallback.passToVisitor(object);
        }
        if (object instanceof HasAnnotations) {
            HasAnnotations hasAnnotations = (HasAnnotations)((Object)object);
            switch (this.annotationWalkFlag) {
                case DONT_WALK_ANNOTATIONS: {
                    break;
                }
                case WALK_ONTOLOGY_ANNOTATIONS_ONLY: {
                    if (!(object instanceof OWLOntology)) break;
                }
                case WALK_ANNOTATIONS: {
                    for (OWLAnnotation anno : hasAnnotations.getAnnotations()) {
                        anno.accept(this);
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void visit(IRI iri) {
        this.process(iri);
    }

    @Override
    public void visit(OWLOntology ontology) {
        this.walkerCallback.ontology = ontology;
        this.walkerCallback.ax = null;
        this.process(ontology);
        for (OWLAxiom a : ontology.getAxioms()) {
            a.accept(this);
        }
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        axiom.getIndividual().accept(this);
        axiom.getClassExpression().accept(this);
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        axiom.getSubject().accept(this);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLLiteral)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        axiom.getDomain().accept(this);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        ((OWLDataRange)axiom.getRange()).accept(this);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        axiom.getEntity().accept(this);
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        for (OWLIndividual ind : axiom.getIndividuals()) {
            ind.accept(this);
        }
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        for (OWLClassExpression desc : axiom.getClassExpressions()) {
            desc.accept(this);
        }
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        for (OWLDataPropertyExpression prop : axiom.getProperties()) {
            prop.accept(this);
        }
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
            prop.accept(this);
        }
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        axiom.getOWLClass().accept(this);
        for (OWLClassExpression desc : axiom.getClassExpressions()) {
            desc.accept(this);
        }
    }

    @Override
    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        axiom.getSubject().accept(this);
        axiom.getAnnotation().accept(this);
    }

    @Override
    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        axiom.getProperty().accept(this);
        axiom.getDomain().accept(this);
    }

    @Override
    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        axiom.getProperty().accept(this);
        axiom.getRange().accept(this);
    }

    @Override
    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        axiom.getSubProperty().accept(this);
        axiom.getSuperProperty().accept(this);
    }

    @Override
    public void visit(OWLAnnotation node) {
        this.process(node);
        this.walkerCallback.setAnnotation(node);
        node.getProperty().accept(this);
        node.getValue().accept(this);
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        for (OWLClassExpression desc : axiom.getClassExpressions()) {
            desc.accept(this);
        }
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        for (OWLDataPropertyExpression prop : axiom.getProperties()) {
            prop.accept(this);
        }
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
            prop.accept(this);
        }
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        axiom.getFirstProperty().accept(this);
        axiom.getSecondProperty().accept(this);
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        axiom.getSubject().accept(this);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLLiteral)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        axiom.getSubject().accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLIndividual)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        axiom.getSubject().accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLIndividual)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        for (OWLObjectPropertyExpression prop : axiom.getPropertyChain()) {
            prop.accept(this);
        }
        axiom.getSuperProperty().accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        axiom.getDomain().accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLClassExpression)axiom.getRange()).accept(this);
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        for (OWLIndividual ind : axiom.getIndividuals()) {
            ind.accept(this);
        }
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        axiom.getSubClass().accept(this);
        axiom.getSuperClass().accept(this);
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(SWRLRule rule) {
        this.process(rule);
        this.walkerCallback.ax = rule;
        for (SWRLAtom at : rule.getBody()) {
            at.accept(this);
        }
        for (SWRLAtom at : rule.getHead()) {
            at.accept(this);
        }
    }

    @Override
    public void visit(OWLHasKeyAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        axiom.getClassExpression().accept(this);
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : axiom.getObjectPropertyExpressions()) {
            oWLObjectPropertyExpression.accept(this);
        }
        for (OWLDataPropertyExpression oWLDataPropertyExpression : axiom.getDataPropertyExpressions()) {
            oWLDataPropertyExpression.accept(this);
        }
    }

    @Override
    public void visit(OWLClass ce) {
        this.walkerCallback.pushClassExpression(ce);
        this.process(ce);
        ce.getIRI().accept(this);
        this.walkerCallback.popClassExpression();
    }

    @Override
    public void visit(OWLDataAllValuesFrom ce) {
        this.walkerCallback.pushClassExpression(ce);
        this.process(ce);
        ce.getProperty().accept(this);
        ((OWLDataRange)ce.getFiller()).accept(this);
        this.walkerCallback.popClassExpression();
    }

    @Override
    public void visit(OWLDataExactCardinality ce) {
        this.walkerCallback.pushClassExpression(ce);
        this.process(ce);
        ce.getProperty().accept(this);
        ((OWLDataRange)ce.getFiller()).accept(this);
        this.walkerCallback.popClassExpression();
    }

    @Override
    public void visit(OWLDataMaxCardinality ce) {
        this.walkerCallback.pushClassExpression(ce);
        this.process(ce);
        ce.getProperty().accept(this);
        ((OWLDataRange)ce.getFiller()).accept(this);
        this.walkerCallback.popClassExpression();
    }

    @Override
    public void visit(OWLDataMinCardinality ce) {
        this.walkerCallback.pushClassExpression(ce);
        this.process(ce);
        ce.getProperty().accept(this);
        ((OWLDataRange)ce.getFiller()).accept(this);
        this.walkerCallback.popClassExpression();
    }

    @Override
    public void visit(OWLDataSomeValuesFrom ce) {
        this.walkerCallback.pushClassExpression(ce);
        this.process(ce);
        ce.getProperty().accept(this);
        ((OWLDataRange)ce.getFiller()).accept(this);
        this.walkerCallback.popClassExpression();
    }

    @Override
    public void visit(OWLDataHasValue ce) {
        this.walkerCallback.pushClassExpression(ce);
        this.process(ce);
        ce.getProperty().accept(this);
        ((OWLLiteral)ce.getFiller()).accept(this);
        this.walkerCallback.popClassExpression();
    }

    @Override
    public void visit(OWLObjectAllValuesFrom ce) {
        this.walkerCallback.pushClassExpression(ce);
        this.process(ce);
        ce.getProperty().accept(this);
        ((OWLClassExpression)ce.getFiller()).accept(this);
        this.walkerCallback.popClassExpression();
    }

    @Override
    public void visit(OWLObjectComplementOf ce) {
        this.walkerCallback.pushClassExpression(ce);
        this.process(ce);
        ce.getOperand().accept(this);
        this.walkerCallback.popClassExpression();
    }

    @Override
    public void visit(OWLObjectExactCardinality ce) {
        this.walkerCallback.pushClassExpression(ce);
        this.process(ce);
        ce.getProperty().accept(this);
        ((OWLClassExpression)ce.getFiller()).accept(this);
        this.walkerCallback.popClassExpression();
    }

    @Override
    public void visit(OWLObjectIntersectionOf ce) {
        this.walkerCallback.pushClassExpression(ce);
        this.process(ce);
        for (OWLClassExpression op : ce.getOperands()) {
            op.accept(this);
        }
        this.walkerCallback.popClassExpression();
    }

    @Override
    public void visit(OWLObjectMaxCardinality ce) {
        this.walkerCallback.pushClassExpression(ce);
        this.process(ce);
        ce.getProperty().accept(this);
        ((OWLClassExpression)ce.getFiller()).accept(this);
        this.walkerCallback.popClassExpression();
    }

    @Override
    public void visit(OWLObjectMinCardinality ce) {
        this.walkerCallback.pushClassExpression(ce);
        this.process(ce);
        ce.getProperty().accept(this);
        ((OWLClassExpression)ce.getFiller()).accept(this);
        this.walkerCallback.popClassExpression();
    }

    @Override
    public void visit(OWLObjectOneOf ce) {
        this.walkerCallback.pushClassExpression(ce);
        this.process(ce);
        for (OWLIndividual ind : ce.getIndividuals()) {
            ind.accept(this);
        }
        this.walkerCallback.popClassExpression();
    }

    @Override
    public void visit(OWLObjectHasSelf ce) {
        this.walkerCallback.pushClassExpression(ce);
        this.process(ce);
        ce.getProperty().accept(this);
        this.walkerCallback.popClassExpression();
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom ce) {
        this.walkerCallback.pushClassExpression(ce);
        this.process(ce);
        ce.getProperty().accept(this);
        ((OWLClassExpression)ce.getFiller()).accept(this);
        this.walkerCallback.popClassExpression();
    }

    @Override
    public void visit(OWLObjectUnionOf ce) {
        this.walkerCallback.pushClassExpression(ce);
        this.process(ce);
        for (OWLClassExpression op : ce.getOperands()) {
            op.accept(this);
        }
        this.walkerCallback.popClassExpression();
    }

    @Override
    public void visit(OWLObjectHasValue ce) {
        this.walkerCallback.pushClassExpression(ce);
        this.process(ce);
        ce.getProperty().accept(this);
        ((OWLIndividual)ce.getFiller()).accept(this);
        this.walkerCallback.popClassExpression();
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.walkerCallback.pushDataRange(node);
        this.process(node);
        node.getDataRange().accept(this);
        this.walkerCallback.popDataRange();
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.walkerCallback.pushDataRange(node);
        this.process(node);
        for (OWLLiteral con : node.getValues()) {
            con.accept(this);
        }
        this.walkerCallback.popDataRange();
    }

    @Override
    public void visit(OWLDataIntersectionOf node) {
        this.walkerCallback.pushDataRange(node);
        this.process(node);
        for (OWLDataRange rng : node.getOperands()) {
            rng.accept(this);
        }
        this.walkerCallback.popDataRange();
    }

    @Override
    public void visit(OWLDataUnionOf node) {
        this.walkerCallback.pushDataRange(node);
        this.process(node);
        for (OWLDataRange rng : node.getOperands()) {
            rng.accept(this);
        }
        this.walkerCallback.popDataRange();
    }

    @Override
    public void visit(OWLFacetRestriction node) {
        this.process(node);
        node.getFacetValue().accept(this);
    }

    @Override
    public void visit(OWLDatatypeRestriction node) {
        this.walkerCallback.pushDataRange(node);
        this.process(node);
        node.getDatatype().accept(this);
        for (OWLFacetRestriction fr : node.getFacetRestrictions()) {
            fr.accept(this);
        }
        this.walkerCallback.popDataRange();
    }

    @Override
    public void visit(OWLDatatype node) {
        this.walkerCallback.pushDataRange(node);
        this.process(node);
        this.walkerCallback.popDataRange();
    }

    @Override
    public void visit(OWLLiteral node) {
        this.process(node);
        node.getDatatype().accept(this);
        this.walkerCallback.popDataRange();
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
        this.process(property);
        property.getIRI().accept(this);
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.process(property);
        property.getIRI().accept(this);
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.process(property);
        property.getIRI().accept(this);
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        this.process(property);
        property.getInverse().accept(this);
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        this.process(individual);
        individual.getIRI().accept(this);
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
        this.process(individual);
    }

    @Override
    public void visit(SWRLLiteralArgument node) {
        this.process(node);
        node.getLiteral().accept(this);
    }

    @Override
    public void visit(SWRLVariable node) {
        this.process(node);
    }

    @Override
    public void visit(SWRLIndividualArgument node) {
        this.process(node);
        node.getIndividual().accept(this);
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        this.process(node);
        for (SWRLDArgument at : node.getArguments()) {
            at.accept(this);
        }
    }

    @Override
    public void visit(SWRLClassAtom node) {
        this.process(node);
        ((SWRLIArgument)node.getArgument()).accept(this);
        node.getPredicate().accept(this);
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        this.process(node);
        ((SWRLDArgument)node.getArgument()).accept(this);
        node.getPredicate().accept(this);
    }

    @Override
    public void visit(SWRLDataPropertyAtom node) {
        this.process(node);
        node.getPredicate().accept(this);
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        ((SWRLDArgument)node.getSecondArgument()).accept(this);
    }

    @Override
    public void visit(SWRLDifferentIndividualsAtom node) {
        this.process(node);
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        this.process(node);
        node.getPredicate().accept(this);
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
    }

    @Override
    public void visit(SWRLSameIndividualAtom node) {
        this.process(node);
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
    }

    @Override
    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        this.process(axiom);
        this.walkerCallback.ax = axiom;
        axiom.getDatatype().accept(this);
        axiom.getDataRange().accept(this);
    }

    public static enum AnnotationWalkingControl {
        DONT_WALK_ANNOTATIONS,
        WALK_ONTOLOGY_ANNOTATIONS_ONLY,
        WALK_ANNOTATIONS;

    }
}

