/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.common;

import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.log4j.Logger;
import org.zaproxy.zap.control.ControlOverrides;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public abstract class AbstractParam
implements Cloneable {
    private static final Logger logger = Logger.getLogger(AbstractParam.class);
    private FileConfiguration config = null;

    public void load(FileConfiguration config) {
        this.config = config;
        try {
            this.parse();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void load(String filePath) {
        this.load(filePath, null);
    }

    public void load(String filePath, ControlOverrides overrides) {
        try {
            this.config = new ZapXmlConfiguration(filePath);
            if (overrides != null) {
                for (Map.Entry<String, String> entry : overrides.getOrderedConfigs().entrySet()) {
                    logger.info((Object)("Setting config " + entry.getKey() + " = " + entry.getValue() + " was " + this.config.getString(entry.getKey())));
                    this.config.setProperty(entry.getKey(), (Object)entry.getValue());
                }
            }
            this.parse();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public AbstractParam clone() {
        try {
            AbstractParam clone = (AbstractParam)super.clone();
            clone.load((FileConfiguration)ConfigurationUtils.cloneConfiguration((Configuration)this.config));
            return clone;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected abstract void parse();

    public void reset() {
    }

    protected String getString(String key, String defaultValue) {
        try {
            return this.getConfig().getString(key, defaultValue);
        }
        catch (ConversionException e) {
            AbstractParam.logConversionException(key, e);
            return defaultValue;
        }
    }

    protected static void logConversionException(String key, ConversionException e) {
        logger.warn((Object)("Failed to read '" + key + "'"), (Throwable)e);
    }

    protected boolean getBoolean(String key, boolean defaultValue) {
        try {
            return this.getConfig().getBoolean(key, defaultValue);
        }
        catch (ConversionException e) {
            AbstractParam.logConversionException(key, e);
            return defaultValue;
        }
    }

    protected int getInt(String key, int defaultValue) {
        try {
            return this.getConfig().getInt(key, defaultValue);
        }
        catch (ConversionException e) {
            AbstractParam.logConversionException(key, e);
            return defaultValue;
        }
    }

    protected Integer getInteger(String key, Integer defaultValue) {
        try {
            return this.getConfig().getInteger(key, defaultValue);
        }
        catch (ConversionException e) {
            AbstractParam.logConversionException(key, e);
            return defaultValue;
        }
    }
}

