/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import org.apache.log4j.Logger;
import org.zaproxy.zap.utils.DisplayUtils;

public abstract class AbstractFrame
extends JFrame {
    private static final long serialVersionUID = 6751593232255236597L;
    private static final String PREF_WINDOW_STATE = "window.state";
    private static final String PREF_WINDOW_SIZE = "window.size";
    private static final String PREF_WINDOW_POSITION = "window.position";
    private static final int WINDOW_DEFAULT_WIDTH = 800;
    private static final int WINDOW_DEFAULT_HEIGHT = 600;
    private final Preferences preferences;
    private final String prefnzPrefix = this.getClass().getSimpleName() + ".";
    private final Logger logger = Logger.getLogger(AbstractFrame.class);

    public AbstractFrame() {
        this.preferences = Preferences.userNodeForPackage(this.getClass());
        this.initialize();
    }

    private void initialize() {
        Point point;
        this.setIconImages(DisplayUtils.getZapIconImages());
        this.setVisible(false);
        this.setTitle("OWASP ZAP");
        Dimension dim = this.restoreWindowSize();
        if (dim == null) {
            this.setSize(800, 600);
        }
        if ((point = this.restoreWindowLocation()) == null) {
            this.centerFrame();
        }
        this.restoreWindowState();
        this.addWindowStateListener(new FrameWindowStateListener());
        this.addComponentListener(new FrameResizedListener());
    }

    public void centerFrame() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    private void saveWindowState(int windowstate) {
        if ((windowstate & 1) == 1) {
            this.preferences.put(this.prefnzPrefix + PREF_WINDOW_STATE, SimpleWindowState.ICONFIED.toString());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Saving preference window.state=" + (Object)((Object)SimpleWindowState.ICONFIED)));
            }
        }
        if ((windowstate & 6) == 6) {
            this.preferences.put(this.prefnzPrefix + PREF_WINDOW_STATE, SimpleWindowState.MAXIMIZED.toString());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Saving preference window.state=" + (Object)((Object)SimpleWindowState.MAXIMIZED)));
            }
        }
        if (windowstate == 0) {
            this.preferences.put(this.prefnzPrefix + PREF_WINDOW_STATE, SimpleWindowState.NORMAL.toString());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Saving preference window.state=" + (Object)((Object)SimpleWindowState.NORMAL)));
            }
        }
    }

    private SimpleWindowState restoreWindowState() {
        SimpleWindowState laststate = null;
        String statestr = this.preferences.get(this.prefnzPrefix + PREF_WINDOW_STATE, null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Restoring preference window.state=" + statestr));
        }
        if (statestr != null) {
            SimpleWindowState state = null;
            try {
                state = SimpleWindowState.valueOf(statestr);
            }
            catch (IllegalArgumentException e) {
                state = null;
            }
            if (state != null) {
                switch (state) {
                    case ICONFIED: {
                        this.setExtendedState(1);
                        break;
                    }
                    case NORMAL: {
                        this.setExtendedState(0);
                        break;
                    }
                    case MAXIMIZED: {
                        this.setExtendedState(6);
                        break;
                    }
                    default: {
                        this.logger.error((Object)("Invalid window state (nothing will changed): " + statestr));
                    }
                }
            }
            laststate = state;
        }
        return laststate;
    }

    private void saveWindowSize(Dimension size) {
        if (size != null) {
            if (this.getExtendedState() == 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Saving preference window.size=" + size.width + "," + size.height));
                }
                this.preferences.put(this.prefnzPrefix + PREF_WINDOW_SIZE, size.width + "," + size.height);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Preference window.size not saved, cause window state is not 'normal'.");
            }
        }
    }

    private Dimension restoreWindowSize() {
        Dimension result = null;
        String sizestr = this.preferences.get(this.prefnzPrefix + PREF_WINDOW_SIZE, null);
        if (sizestr != null) {
            int width = 0;
            int height = 0;
            String[] sizes = sizestr.split("[,]");
            try {
                width = Integer.parseInt(sizes[0].trim());
                height = Integer.parseInt(sizes[1].trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (width > 0 && height > 0) {
                result = new Dimension(width, height);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Restoring preference window.size=" + result.width + "," + result.height));
                }
                this.setSize(result);
            }
        }
        return result;
    }

    private void saveWindowLocation(Point point) {
        if (point != null) {
            if (this.getExtendedState() == 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Saving preference window.position=" + point.x + "," + point.y));
                }
                this.preferences.put(this.prefnzPrefix + PREF_WINDOW_POSITION, point.x + "," + point.y);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Preference window.position not saved, cause window state is not 'normal'.");
            }
        }
    }

    private Point restoreWindowLocation() {
        Point result = null;
        String sizestr = this.preferences.get(this.prefnzPrefix + PREF_WINDOW_POSITION, null);
        if (sizestr != null) {
            int x = 0;
            int y = 0;
            String[] sizes = sizestr.split("[,]");
            try {
                x = Integer.parseInt(sizes[0].trim());
                y = Integer.parseInt(sizes[1].trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (x > 0 && y > 0) {
                result = new Point(x, y);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Restoring preference window.position=" + result.x + "," + result.y));
                }
                this.setLocation(result);
            }
        }
        return result;
    }

    @Deprecated
    protected List<Image> loadIconImages() {
        return new ArrayList<Image>(DisplayUtils.getZapIconImages());
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            this.logger.error((Object)"Error while saving the preferences", (Throwable)e);
        }
    }

    private static enum SimpleWindowState {
        ICONFIED,
        NORMAL,
        MAXIMIZED;

    }

    private final class FrameResizedListener
    extends ComponentAdapter {
        private FrameResizedListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (e.getComponent() != null) {
                AbstractFrame.this.saveWindowSize(e.getComponent().getSize());
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            if (e.getComponent() != null) {
                AbstractFrame.this.saveWindowLocation(e.getComponent().getLocation());
            }
        }
    }

    private final class FrameWindowStateListener
    implements WindowStateListener {
        private FrameWindowStateListener() {
        }

        @Override
        public void windowStateChanged(WindowEvent e) {
            AbstractFrame.this.saveWindowState(e.getNewState());
        }
    }
}

