/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.log4j.Logger;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.RecordableTextAction;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.menus.SyntaxMenu;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.menus.ViewMenu;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.view.HighlightSearchEntry;
import org.zaproxy.zap.view.HighlighterManager;

public abstract class HttpPanelSyntaxHighlightTextArea
extends RSyntaxTextArea
implements Observer {
    private static final long serialVersionUID = -9082089105656842054L;
    private static Logger log = Logger.getLogger(HttpPanelSyntaxHighlightTextArea.class);
    public static final String PLAIN_SYNTAX_LABEL = Constant.messages.getString("http.panel.view.syntaxtext.syntax.plain");
    private static final String ANTI_ALIASING = "aa";
    private static final String SHOW_LINE_NUMBERS = "linenumbers";
    private static final String CODE_FOLDING = "codefolding";
    private static final String WORD_WRAP = "wordwrap";
    private static final String HIGHLIGHT_CURRENT_LINE = "highlightline";
    private static final String FADE_CURRENT_HIGHLIGHT_LINE = "fadehighlightline";
    private static final String SHOW_WHITESPACE_CHARACTERS = "whitespaces";
    private static final String SHOW_NEWLINE_CHARACTERS = "newlines";
    private static final String MARK_OCCURRENCES = "markocurrences";
    private static final String ROUNDED_SELECTION_EDGES = "roundedselection";
    private static final String BRACKET_MATCHING = "bracketmatch";
    private static final String ANIMATED_BRACKET_MATCHING = "animatedbracketmatch";
    private Message message;
    private Vector<SyntaxStyle> syntaxStyles;
    private boolean codeFoldingAllowed;
    private static SyntaxMenu syntaxMenu = null;
    private static ViewMenu viewMenu = null;
    private static TextAreaMenuItem cutAction = null;
    private static TextAreaMenuItem copyAction = null;
    private static TextAreaMenuItem pasteAction = null;
    private static TextAreaMenuItem deleteAction = null;
    private static TextAreaMenuItem undoAction = null;
    private static TextAreaMenuItem redoAction = null;
    private static TextAreaMenuItem selectAllAction = null;

    public HttpPanelSyntaxHighlightTextArea() {
        ((RSyntaxDocument)this.getDocument()).setTokenMakerFactory((TokenMakerFactory)this.getTokenMakerFactory());
        this.setSyntaxEditingStyle("text/plain");
        this.syntaxStyles = new Vector();
        this.addSyntaxStyle(PLAIN_SYNTAX_LABEL, "text/plain");
        if (syntaxMenu == null) {
            HttpPanelSyntaxHighlightTextArea.initActions();
        }
        this.setPopupMenu(null);
        this.message = null;
        this.setHyperlinksEnabled(false);
        this.setAntiAliasingEnabled(true);
        this.setLineWrap(true);
        this.setHighlightCurrentLine(false);
        this.setFadeCurrentLineHighlight(false);
        this.setWhitespaceVisible(false);
        this.setEOLMarkersVisible(false);
        this.setMarkOccurrences(false);
        this.setBracketMatchingEnabled(false);
        this.setAnimateBracketMatching(false);
        this.setAutoIndentEnabled(false);
        this.setCloseCurlyBraces(false);
        this.setCloseMarkupTags(false);
        this.setClearWhitespaceLinesEnabled(false);
        Font font = !FontUtils.isDefaultFontSet() ? FontUtils.getFont(this.getFont().getFontName()) : FontUtils.getFont(0);
        this.setFont(font);
        this.initHighlighter();
    }

    protected void setCodeFoldingAllowed(boolean codeFoldingAllowed) {
        this.codeFoldingAllowed = codeFoldingAllowed;
    }

    public boolean isCodeFoldingAllowed() {
        return this.codeFoldingAllowed;
    }

    protected JPopupMenu createPopupMenu() {
        return null;
    }

    private void initHighlighter() {
        HighlighterManager highlighter = HighlighterManager.getInstance();
        highlighter.addObserver(this);
        if (this.message != null) {
            this.highlightAll();
        }
    }

    private void highlightAll() {
        HighlighterManager highlighter = HighlighterManager.getInstance();
        LinkedList<HighlightSearchEntry> highlights = highlighter.getHighlights();
        for (HighlightSearchEntry entry : highlights) {
            this.highlightEntryParser(entry);
        }
    }

    private void highlightEntryParser(HighlightSearchEntry entry) {
        int lastPos = 0;
        String text = this.getText();
        Highlighter hilite = this.getHighlighter();
        DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(entry.getColor());
        while ((lastPos = text.indexOf(entry.getToken(), lastPos)) > -1) {
            try {
                hilite.addHighlight(lastPos, lastPos + entry.getToken().length(), painter);
                lastPos += entry.getToken().length();
            }
            catch (BadLocationException e) {
                log.warn((Object)"Could not highlight entry", (Throwable)e);
            }
        }
    }

    public void setText(String s) {
        super.setText(s);
        this.highlightAll();
    }

    public abstract void search(Pattern var1, List<SearchMatch> var2);

    public abstract void highlight(SearchMatch var1);

    protected void highlight(int start, int end) {
        Highlighter hilite = this.getHighlighter();
        DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.LIGHT_GRAY);
        try {
            this.removeAllHighlights();
            hilite.addHighlight(start, end, painter);
            this.setCaretPosition(start);
        }
        catch (BadLocationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Object highlight(int start, int end, Highlighter.HighlightPainter painter) {
        try {
            Object highlightReference = this.getHighlighter().addHighlight(start, end, painter);
            this.setCaretPosition(start);
            return highlightReference;
        }
        catch (BadLocationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void removeHighlight(Object highlightReference) {
        this.getHighlighter().removeHighlight(highlightReference);
    }

    private void removeAllHighlights() {
        Highlighter hilite = this.getHighlighter();
        hilite.removeAllHighlights();
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg1 == null) {
            this.removeAllHighlights();
            this.highlightAll();
        } else {
            HighlightSearchEntry token = (HighlightSearchEntry)arg1;
            this.highlightEntryParser(token);
        }
        this.invalidate();
    }

    public void setMessage(Message aMessage) {
        this.message = aMessage;
    }

    public Message getMessage() {
        return this.message;
    }

    public void loadConfiguration(String key, FileConfiguration fileConfiguration) {
        this.setAntiAliasingEnabled(fileConfiguration.getBoolean(key + ANTI_ALIASING, this.getAntiAliasingEnabled()));
        Container c = this.getParent();
        if (c instanceof JViewport && (c = c.getParent()) instanceof RTextScrollPane) {
            RTextScrollPane scrollPane = (RTextScrollPane)c;
            scrollPane.setLineNumbersEnabled(fileConfiguration.getBoolean(key + SHOW_LINE_NUMBERS, scrollPane.getLineNumbersEnabled()));
            if (this.isCodeFoldingAllowed()) {
                this.setCodeFoldingEnabled(fileConfiguration.getBoolean(key + CODE_FOLDING, this.isCodeFoldingEnabled()));
                scrollPane.setFoldIndicatorEnabled(this.isCodeFoldingEnabled());
            }
        }
        this.setLineWrap(fileConfiguration.getBoolean(key + WORD_WRAP, this.getLineWrap()));
        this.setHighlightCurrentLine(fileConfiguration.getBoolean(key + HIGHLIGHT_CURRENT_LINE, this.getHighlightCurrentLine()));
        this.setFadeCurrentLineHighlight(fileConfiguration.getBoolean(key + FADE_CURRENT_HIGHLIGHT_LINE, this.getFadeCurrentLineHighlight()));
        this.setWhitespaceVisible(fileConfiguration.getBoolean(key + SHOW_WHITESPACE_CHARACTERS, this.isWhitespaceVisible()));
        this.setEOLMarkersVisible(fileConfiguration.getBoolean(key + SHOW_NEWLINE_CHARACTERS, this.getEOLMarkersVisible()));
        this.setMarkOccurrences(fileConfiguration.getBoolean(key + MARK_OCCURRENCES, this.getMarkOccurrences()));
        this.setRoundedSelectionEdges(fileConfiguration.getBoolean(key + ROUNDED_SELECTION_EDGES, this.getRoundedSelectionEdges()));
        this.setBracketMatchingEnabled(fileConfiguration.getBoolean(key + BRACKET_MATCHING, this.isBracketMatchingEnabled()));
        this.setAnimateBracketMatching(fileConfiguration.getBoolean(key + ANIMATED_BRACKET_MATCHING, this.getAnimateBracketMatching()));
    }

    public void saveConfiguration(String key, FileConfiguration fileConfiguration) {
        fileConfiguration.setProperty(key + ANTI_ALIASING, (Object)this.getAntiAliasingEnabled());
        Container c = this.getParent();
        if (c instanceof JViewport && (c = c.getParent()) instanceof RTextScrollPane) {
            RTextScrollPane scrollPane = (RTextScrollPane)c;
            fileConfiguration.setProperty(key + SHOW_LINE_NUMBERS, (Object)scrollPane.getLineNumbersEnabled());
            if (this.isCodeFoldingAllowed()) {
                fileConfiguration.setProperty(key + CODE_FOLDING, (Object)this.isCodeFoldingEnabled());
            }
        }
        fileConfiguration.setProperty(key + WORD_WRAP, (Object)this.getLineWrap());
        fileConfiguration.setProperty(key + HIGHLIGHT_CURRENT_LINE, (Object)this.getHighlightCurrentLine());
        fileConfiguration.setProperty(key + FADE_CURRENT_HIGHLIGHT_LINE, (Object)this.getFadeCurrentLineHighlight());
        fileConfiguration.setProperty(key + SHOW_WHITESPACE_CHARACTERS, (Object)this.isWhitespaceVisible());
        fileConfiguration.setProperty(key + SHOW_NEWLINE_CHARACTERS, (Object)this.getEOLMarkersVisible());
        fileConfiguration.setProperty(key + MARK_OCCURRENCES, (Object)this.getMarkOccurrences());
        fileConfiguration.setProperty(key + ROUNDED_SELECTION_EDGES, (Object)this.getRoundedSelectionEdges());
        fileConfiguration.setProperty(key + BRACKET_MATCHING, (Object)this.isBracketMatchingEnabled());
        fileConfiguration.setProperty(key + ANIMATED_BRACKET_MATCHING, (Object)this.getAnimateBracketMatching());
    }

    public Vector<SyntaxStyle> getSyntaxStyles() {
        return this.syntaxStyles;
    }

    protected void addSyntaxStyle(String label, String styleKey) {
        this.syntaxStyles.add(new SyntaxStyle(label, styleKey));
    }

    protected abstract CustomTokenMakerFactory getTokenMakerFactory();

    private static synchronized void initActions() {
        if (syntaxMenu == null) {
            syntaxMenu = new SyntaxMenu();
            viewMenu = new ViewMenu();
            undoAction = new TextAreaMenuItem(6, true, false);
            redoAction = new TextAreaMenuItem(4, false, true);
            cutAction = new TextAreaMenuItem(1, false, false);
            copyAction = new TextAreaMenuItem(0, false, false);
            pasteAction = new TextAreaMenuItem(3, false, false);
            deleteAction = new TextAreaMenuItem(2, false, true);
            selectAllAction = new TextAreaMenuItem(5, false, false);
            Vector<JMenuItem> mainPopupMenuItems = View.getSingleton().getPopupList();
            mainPopupMenuItems.add(syntaxMenu);
            mainPopupMenuItems.add(viewMenu);
            mainPopupMenuItems.add(undoAction);
            mainPopupMenuItems.add(redoAction);
            mainPopupMenuItems.add(cutAction);
            mainPopupMenuItems.add(copyAction);
            mainPopupMenuItems.add(pasteAction);
            mainPopupMenuItems.add(deleteAction);
            mainPopupMenuItems.add(selectAllAction);
        }
    }

    private static class TextAreaMenuItem
    extends ExtensionPopupMenuItem {
        private static final long serialVersionUID = -8369459846515841057L;
        private int actionId;
        private boolean precedeWithSeparator;
        private boolean succeedWithSeparator;

        public TextAreaMenuItem(int actionId, boolean precedeWithSeparator, boolean succeedWithSeparator) throws IllegalArgumentException {
            this.actionId = actionId;
            this.precedeWithSeparator = precedeWithSeparator;
            this.succeedWithSeparator = succeedWithSeparator;
            RecordableTextAction action = RTextArea.getAction((int)actionId);
            if (action == null) {
                throw new IllegalArgumentException("Action not found with id: " + actionId);
            }
            this.setAction((Action)action);
        }

        @Override
        public boolean isEnableForComponent(Component invoker) {
            if (invoker instanceof HttpPanelSyntaxHighlightTextArea) {
                HttpPanelSyntaxHighlightTextArea httpPanelTextArea = (HttpPanelSyntaxHighlightTextArea)((Object)invoker);
                switch (this.actionId) {
                    case 1: {
                        if (httpPanelTextArea.isEditable()) break;
                        this.setEnabled(false);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.setEnabled(httpPanelTextArea.isEditable());
                        break;
                    }
                    case 5: {
                        this.setEnabled(httpPanelTextArea.getDocument().getLength() != 0);
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean precedeWithSeparator() {
            return this.precedeWithSeparator;
        }

        @Override
        public boolean succeedWithSeparator() {
            return this.succeedWithSeparator;
        }

        @Override
        public boolean isSafe() {
            return true;
        }
    }

    protected static class CustomTokenMakerFactory
    extends AbstractTokenMakerFactory {
        protected CustomTokenMakerFactory() {
        }

        protected void initTokenMakerMap() {
            String pkg = "org.fife.ui.rsyntaxtextarea.modes.";
            this.putMapping("text/plain", pkg + "PlainTextTokenMaker");
        }
    }

    public static class SyntaxStyle {
        private String label;
        private String styleKey;

        public SyntaxStyle(String label, String styleKey) {
            this.label = label;
            this.styleKey = styleKey;
        }

        public String getLabel() {
            return this.label;
        }

        public String getStyleKey() {
            return this.styleKey;
        }
    }
}

