/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.option;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.utils.LocaleUtils;
import org.zaproxy.zap.view.ViewLocale;

public class OptionsLocalePanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JPanel panelMisc = null;
    private JComboBox<ViewLocale> localeSelect = null;
    private JLabel localeLabel = null;
    private JLabel localeChangeLabel = null;

    public OptionsLocalePanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("view.options.title"));
        this.add((Component)this.getPanelMisc(), this.getPanelMisc().getName());
    }

    private JPanel getPanelMisc() {
        if (this.panelMisc == null) {
            this.panelMisc = new JPanel();
            this.panelMisc.setLayout(new GridBagLayout());
            this.panelMisc.setSize(114, 132);
            this.panelMisc.setName(Constant.messages.getString("view.options.misc.title"));
            GridBagConstraints gbc0 = new GridBagConstraints();
            GridBagConstraints gbc1_0 = new GridBagConstraints();
            GridBagConstraints gbc1_1 = new GridBagConstraints();
            GridBagConstraints gbc2 = new GridBagConstraints();
            GridBagConstraints gbcX = new GridBagConstraints();
            gbc0.gridx = 0;
            gbc0.gridy = 0;
            gbc0.ipadx = 0;
            gbc0.ipady = 0;
            gbc0.insets = new Insets(2, 2, 2, 2);
            gbc0.anchor = 18;
            gbc0.fill = 2;
            gbc0.weightx = 1.0;
            gbc0.gridwidth = 2;
            gbc1_0.gridx = 0;
            gbc1_0.gridy = 1;
            gbc1_0.ipadx = 0;
            gbc1_0.ipady = 0;
            gbc1_0.insets = new Insets(2, 2, 2, 2);
            gbc1_0.anchor = 18;
            gbc1_0.fill = 2;
            gbc1_0.weightx = 1.0;
            gbc1_1.gridx = 1;
            gbc1_1.gridy = 1;
            gbc1_1.ipadx = 0;
            gbc1_1.ipady = 0;
            gbc1_1.insets = new Insets(2, 2, 2, 2);
            gbc1_1.anchor = 18;
            gbc1_1.fill = 2;
            gbc1_1.weightx = 1.0;
            gbc2.gridx = 0;
            gbc2.gridy = 2;
            gbc2.ipadx = 0;
            gbc2.ipady = 0;
            gbc2.insets = new Insets(2, 2, 2, 2);
            gbc2.anchor = 18;
            gbc2.fill = 2;
            gbc2.weightx = 1.0;
            gbc2.weighty = 1.0;
            gbc2.gridwidth = 2;
            gbcX.gridx = 0;
            gbcX.gridy = 3;
            gbcX.ipadx = 0;
            gbcX.ipady = 0;
            gbcX.insets = new Insets(2, 2, 2, 2);
            gbcX.anchor = 18;
            gbcX.fill = 2;
            gbcX.weightx = 1.0;
            gbcX.weighty = 1.0;
            this.localeLabel = new JLabel(Constant.messages.getString("locale.options.label.language"));
            this.localeChangeLabel = new JLabel(Constant.messages.getString("locale.options.label.change"));
            this.panelMisc.add((Component)this.localeLabel, gbc1_0);
            this.panelMisc.add(this.getLocaleSelect(), gbc1_1);
            this.panelMisc.add((Component)this.localeChangeLabel, gbc2);
            this.panelMisc.add((Component)new JLabel(), gbcX);
        }
        return this.panelMisc;
    }

    private JComboBox<ViewLocale> getLocaleSelect() {
        if (this.localeSelect == null) {
            this.localeSelect = new JComboBox();
            for (ViewLocale locale : LocaleUtils.getAvailableViewLocales()) {
                this.localeSelect.addItem(locale);
            }
            this.localeSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ViewLocale selectedLocale = (ViewLocale)OptionsLocalePanel.this.localeSelect.getSelectedItem();
                    if (selectedLocale != null) {
                        Constant.setLocale(selectedLocale.getLocale());
                        OptionsLocalePanel.this.localeLabel.setText(Constant.messages.getString("locale.options.label.language"));
                        OptionsLocalePanel.this.localeChangeLabel.setText(Constant.messages.getString("locale.options.label.change"));
                    }
                }
            });
        }
        return this.localeSelect;
    }

    @Override
    public void initParam(Object obj) {
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam options = (OptionsParam)obj;
        ViewLocale selectedLocale = (ViewLocale)this.localeSelect.getSelectedItem();
        if (selectedLocale != null) {
            options.getViewParam().setLocale(selectedLocale.getLocale());
        }
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.locale";
    }
}

