/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.parosproxy.paros.Constant;

public class SpiderPanelTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -6380136823410869457L;
    private static final String[] COLUMN_NAMES = new String[]{Constant.messages.getString("spider.table.header.inScope"), Constant.messages.getString("spider.table.header.method"), Constant.messages.getString("spider.table.header.uri"), Constant.messages.getString("spider.table.header.flags")};
    private static final int COLUMN_COUNT = COLUMN_NAMES.length;
    private List<SpiderScanResult> scanResults;
    private boolean incFlags;

    public SpiderPanelTableModel() {
        this(true);
        this.scanResults = new ArrayList<SpiderScanResult>();
    }

    public SpiderPanelTableModel(boolean incFlags) {
        this.incFlags = incFlags;
        this.scanResults = new ArrayList<SpiderScanResult>();
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public int getColumnCount() {
        if (this.incFlags) {
            return COLUMN_COUNT;
        }
        return COLUMN_COUNT - 1;
    }

    @Override
    public int getRowCount() {
        return this.scanResults.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        SpiderScanResult result = this.scanResults.get(row);
        switch (col) {
            case 0: {
                return result.processed;
            }
            case 1: {
                return result.method;
            }
            case 2: {
                return result.uri;
            }
            case 3: {
                return result.flags;
            }
        }
        return null;
    }

    public void removeAllElements() {
        this.scanResults.clear();
        this.fireTableDataChanged();
    }

    public void addScanResult(String uri, String method, String flags, boolean skipped) {
        SpiderScanResult result = new SpiderScanResult(uri, method, flags, !skipped);
        this.scanResults.add(result);
        this.fireTableRowsInserted(this.scanResults.size() - 1, this.scanResults.size() - 1);
    }

    public void removesScanResult(String uri, String method) {
        SpiderScanResult toRemove = new SpiderScanResult(uri, method);
        int index = this.scanResults.indexOf(toRemove);
        if (index >= 0) {
            this.scanResults.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        return null;
    }

    public List<String> getAddedNodes() {
        ArrayList<String> list = new ArrayList<String>(this.scanResults.size());
        for (SpiderScanResult res : this.scanResults) {
            list.add(res.uri);
        }
        return list;
    }

    private static class SpiderScanResult {
        protected String uri;
        protected String method;
        protected String flags;
        protected boolean processed;

        protected SpiderScanResult(String uri, String method) {
            this.uri = uri;
            this.method = method;
        }

        protected SpiderScanResult(String uri, String method, String flags, boolean processed) {
            this.uri = uri;
            this.method = method;
            this.flags = flags;
            this.processed = processed;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            SpiderScanResult other = (SpiderScanResult)obj;
            if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
                return false;
            }
            return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
        }
    }
}

