/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.view.ContextListTableModel;
import org.zaproxy.zap.view.LayoutHelper;

public class ContextListPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = -8337361808959321380L;
    private JPanel panelContext = null;
    private JTable tableExt = null;
    private JScrollPane jScrollPane = null;
    private ContextListTableModel model = new ContextListTableModel();

    public ContextListPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("context.list"));
        this.add((Component)this.getPanelSession(), this.getPanelSession().getName());
    }

    private JPanel getPanelSession() {
        if (this.panelContext == null) {
            this.panelContext = new JPanel();
            this.panelContext.setLayout(new GridBagLayout());
            this.panelContext.setName(Constant.messages.getString("context.list"));
            if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
                this.panelContext.setSize(180, 101);
            }
            this.panelContext.add((Component)this.getJScrollPane(), LayoutHelper.getGBC(0, 0, 4, 1.0, 1.0));
        }
        return this.panelContext;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTableExtension());
            this.jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        }
        return this.jScrollPane;
    }

    private JTable getTableExtension() {
        if (this.tableExt == null) {
            this.tableExt = new JTable();
            this.tableExt.setModel(this.model);
            this.tableExt.getColumnModel().getColumn(0).setPreferredWidth(30);
            this.tableExt.getColumnModel().getColumn(1).setPreferredWidth(320);
            this.tableExt.getColumnModel().getColumn(2).setPreferredWidth(50);
            this.tableExt.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        }
        return this.tableExt;
    }

    @Override
    public void initParam(Object obj) {
        Session session = (Session)obj;
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        List<Context> contexts = session.getContexts();
        for (Context context : contexts) {
            values.add(new Object[]{context.getIndex(), context.getName(), context.isInScope()});
        }
        this.model.setValues(values);
    }

    @Override
    public void saveParam(Object obj) throws Exception {
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.contexts";
    }
}

