/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Dialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SortOrder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.AbstractFormDialog;
import org.zaproxy.zap.view.AbstractMultipleOptionsBaseTableModel;
import org.zaproxy.zap.view.AbstractMultipleOptionsBaseTablePanel;

public class MultipleRegexesOptionsPanel
extends AbstractMultipleOptionsBaseTablePanel<String> {
    private static final long serialVersionUID = 1041782873016590998L;
    private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("multiple.options.regexes.dialog.remove.regex.title");
    private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("multiple.options.regexes.dialog.remove.regex.text");
    private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("multiple.options.regexes.dialog.remove.regex.button.confirm");
    private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("multiple.options.regexes.dialog.remove.regex.button.cancel");
    private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("multiple.options.regexes.dialog.remove.regex.checkbox.label");
    private DialogAddRegex addDialog;
    private DialogModifyRegex modifyDialog;
    private final Dialog owner;

    public MultipleRegexesOptionsPanel(Dialog owner) {
        this(owner, new RegexesTableModel());
    }

    public MultipleRegexesOptionsPanel(Dialog owner, RegexesTableModel model) {
        super(model);
        this.owner = owner;
        this.getTable().setSortOrder(0, SortOrder.ASCENDING);
    }

    public void setRegexes(List<String> regexes) {
        ((RegexesTableModel)this.getMultipleOptionsModel()).setElements(regexes);
    }

    public List<String> getRegexes() {
        return ((RegexesTableModel)this.getMultipleOptionsModel()).getElements();
    }

    @Override
    public String showAddDialogue() {
        if (this.addDialog == null) {
            this.addDialog = new DialogAddRegex(this.owner);
            this.addDialog.pack();
        }
        this.addDialog.setVisible(true);
        String regex = this.addDialog.getRegex();
        this.addDialog.clear();
        return regex;
    }

    @Override
    public String showModifyDialogue(String e) {
        if (this.modifyDialog == null) {
            this.modifyDialog = new DialogModifyRegex(this.owner);
            this.modifyDialog.pack();
        }
        this.modifyDialog.setRegex(e);
        this.modifyDialog.setVisible(true);
        String regex = this.modifyDialog.getRegex();
        this.modifyDialog.clear();
        if (!regex.equals(e)) {
            return regex;
        }
        return null;
    }

    @Override
    public boolean showRemoveDialogue(String e) {
        JCheckBox removeWithoutConfirmationCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
        Object[] messages = new Object[]{REMOVE_DIALOG_TEXT, " ", removeWithoutConfirmationCheckBox};
        int option = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), messages, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
        if (option == 0) {
            this.setRemoveWithoutConfirmation(removeWithoutConfirmationCheckBox.isSelected());
            return true;
        }
        return false;
    }

    protected static class RegexesTableModel
    extends AbstractMultipleOptionsBaseTableModel<String> {
        private static final long serialVersionUID = -7644711449311289615L;
        private static final String[] COLUMN_NAMES = new String[]{Constant.messages.getString("multiple.options.regexes.table.header.regex")};
        private static final int COLUMN_COUNT = COLUMN_NAMES.length;
        private List<String> elements = new ArrayList<String>();

        @Override
        public String getColumnName(int col) {
            return COLUMN_NAMES[col];
        }

        @Override
        public int getColumnCount() {
            return COLUMN_COUNT;
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.elements.size();
        }

        @Override
        public String getValueAt(int rowIndex, int columnIndex) {
            return this.elements.get(rowIndex);
        }

        @Override
        public List<String> getElements() {
            return this.elements;
        }

        public void setElements(List<String> regexes) {
            this.elements = new ArrayList<String>(regexes);
            this.fireTableDataChanged();
        }
    }

    protected static class DialogModifyRegex
    extends DialogAddRegex {
        private static final long serialVersionUID = 3803499933691686617L;
        private static final String DIALOG_TITLE = Constant.messages.getString("multiple.options.regexes.dialog.modify.regex.title");
        private static final String CONFIRM_BUTTON_LABEL = Constant.messages.getString("multiple.options.regexes.dialog.modify.regex.button.confirm");

        protected DialogModifyRegex(Dialog owner) {
            super(owner, DIALOG_TITLE);
        }

        @Override
        protected String getConfirmButtonLabel() {
            return CONFIRM_BUTTON_LABEL;
        }

        public void setRegex(String regex) {
            this.regex = regex;
        }

        @Override
        protected void init() {
            this.getRegexTextField().setText(this.regex);
            this.getRegexTextField().discardAllEdits();
        }
    }

    protected static class DialogAddRegex
    extends AbstractFormDialog {
        private static final long serialVersionUID = 9172864521259395417L;
        private static final String DIALOG_TITLE = Constant.messages.getString("multiple.options.regexes.dialog.add.regex.title");
        private static final String CONFIRM_BUTTON_LABEL = Constant.messages.getString("multiple.options.regexes.dialog.add.regex.button.confirm");
        private static final String REGEX_FIELD_LABEL = Constant.messages.getString("multiple.options.regexes.dialog.regex.label");
        private static final String TITLE_INVALID_REGEX_DIALOG = Constant.messages.getString("multiple.options.regexes.dialog.regex.invalid.title");
        private static final String TEXT_INVALID_REGEX_DIALOG = Constant.messages.getString("multiple.options.regexes.dialog.regex.invalid.text");
        private ZapTextField regexTextField;
        protected String regex;

        public DialogAddRegex(Dialog owner) {
            super(owner, DIALOG_TITLE);
        }

        protected DialogAddRegex(Dialog owner, String title) {
            super(owner, title);
        }

        @Override
        protected JPanel getFieldsPanel() {
            JPanel fieldsPanel = new JPanel();
            GroupLayout layout = new GroupLayout(fieldsPanel);
            fieldsPanel.setLayout(layout);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            JLabel regexLabel = new JLabel(REGEX_FIELD_LABEL);
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(regexLabel).addComponent(this.getRegexTextField()));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(regexLabel).addComponent(this.getRegexTextField()));
            return fieldsPanel;
        }

        @Override
        protected String getConfirmButtonLabel() {
            return CONFIRM_BUTTON_LABEL;
        }

        @Override
        protected void init() {
            this.getRegexTextField().setText("");
            this.regex = null;
        }

        @Override
        protected boolean validateFields() {
            try {
                Pattern.compile(this.getRegexTextField().getText(), 2);
            }
            catch (PatternSyntaxException e) {
                JOptionPane.showMessageDialog(this, MessageFormat.format(TEXT_INVALID_REGEX_DIALOG, e.getLocalizedMessage()), TITLE_INVALID_REGEX_DIALOG, 1);
                this.getRegexTextField().requestFocusInWindow();
                return false;
            }
            return true;
        }

        @Override
        protected void performAction() {
            this.regex = this.getRegexTextField().getText();
        }

        @Override
        protected void clearFields() {
            this.getRegexTextField().setText("");
            this.getRegexTextField().discardAllEdits();
        }

        public String getRegex() {
            return this.regex;
        }

        protected ZapTextField getRegexTextField() {
            if (this.regexTextField == null) {
                this.regexTextField = new ZapTextField(30);
                this.regexTextField.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.checkAndEnableConfirmButton();
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.checkAndEnableConfirmButton();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.checkAndEnableConfirmButton();
                    }

                    private void checkAndEnableConfirmButton() {
                        this.setConfirmButtonEnabled(this.getRegexTextField().getDocument().getLength() > 0);
                    }
                });
            }
            return this.regexTextField;
        }

        public void clear() {
            this.regex = null;
        }
    }
}

