/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.fx.ui;

import com.sun.deploy.uitoolkit.impl.fx.FXPreloader;
import com.sun.deploy.uitoolkit.impl.fx.ui.resources.ResourceManager;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.StyleableStringProperty;
import com.sun.javafx.css.Stylesheet;
import com.sun.javafx.css.converters.StringConverter;
import com.sun.javafx.css.parser.CSSParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.application.HostServices;
import javafx.application.Preloader;
import javafx.beans.property.StringProperty;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.util.Duration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FXDefaultPreloader
extends Preloader {
    static final double FADE_DURATION = 2000.0;
    Stage stage;
    FXPreloaderPane pane;
    double currentWidth = 0.0;
    double currentHeight = 0.0;
    boolean isEmbedded;

    @Override
    public void init() {
        this.pane = new FXPreloaderPane();
    }

    @Override
    public void start(Stage stage) {
        this.stage = stage;
        this.stage.setTitle("JavaFX Application Preview");
        this.isEmbedded = stage.getWidth() >= 0.0 && stage.getHeight() >= 0.0;
    }

    private void showIfNeeded() {
        if (!this.stage.isShowing()) {
            this.stage.setScene(new FXPreloaderScene(this.pane));
            this.stage.show();
            ((FXPreloaderScene)this.stage.getScene()).loadStylesheets();
            this.stage.toFront();
            FXPreloader.hideSplash();
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void handleStateChangeNotification(Preloader.StateChangeNotification evt) {
        switch (evt.getType()) {
            case BEFORE_START: {
                if (this.stage.isShowing()) {
                    if (this.isEmbedded) {
                        FadeTransition ft = new FadeTransition(Duration.millis(2000.0), this.pane);
                        ft.setFromValue(1.0);
                        ft.setToValue(0.0);
                        ft.setOnFinished(new FadeOutFinisher(this.stage));
                        ft.play();
                        break;
                    }
                    this.stage.hide();
                    break;
                }
                FXPreloader.hideSplash();
                break;
            }
        }
    }

    @Override
    public boolean handleErrorNotification(Preloader.ErrorNotification evt) {
        if (this.stage != null && this.stage.isShowing() && !this.isEmbedded) {
            this.stage.hide();
        } else if (this.isEmbedded) {
            FXPreloader.hideSplash();
        }
        return false;
    }

    @Override
    public void handleProgressNotification(Preloader.ProgressNotification evt) {
        if (evt.getProgress() != 1.0) {
            this.showIfNeeded();
        }
        if (this.stage.isShowing()) {
            this.pane.setProgress(evt.getProgress());
        }
    }

    public List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    class FXPreloaderPane
    extends Pane {
        ProgressBar progressBar;
        Label status;
        Label percent;
        Label graphic;
        private StringProperty preloaderText = new StyleableStringProperty(){

            public Object getBean() {
                return FXPreloaderPane.this;
            }

            public String getName() {
                return "preloaderText";
            }

            public StyleableProperty getStyleableProperty() {
                return StyleableProperties.PRELOADER_TEXT;
            }
        };
        private StringProperty preloaderGraphicUrl = new StyleableStringProperty(){

            protected void invalidated() {
                if (this.getValue() != null) {
                    if (FXPreloaderPane.this.graphic == null) {
                        FXPreloaderPane.this.graphic = new Label();
                        FXPreloaderPane.this.getChildren().add(FXPreloaderPane.this.graphic);
                    }
                    FXPreloaderPane.this.graphic.setGraphic(new ImageView(new Image(this.getValue())));
                }
            }

            public Object getBean() {
                return FXPreloaderPane.this;
            }

            public String getName() {
                return "preloaderGraphicUrl";
            }

            public StyleableProperty getStyleableProperty() {
                return StyleableProperties.PRELOADER_GRAPHIC;
            }
        };

        FXPreloaderPane() {
            this.getStyleClass().setAll((String[])new String[]{"default-preloader"});
            String style = FXDefaultPreloader.this.getParameters().getNamed().get("javafx.default.preloader.style");
            if (style != null) {
                this.setStyle(style);
            }
            this.progressBar = new ProgressBar();
            this.status = new Label(ResourceManager.getMessage("preloader.loading"));
            this.status.setId("preloader-status-label");
            this.percent = new Label("");
            this.percent.setId("preloader-percent-label");
            this.getChildren().addAll((Node[])new Node[]{this.progressBar, this.status, this.percent});
        }

        public void layoutChildren() {
            if (FXDefaultPreloader.this.currentWidth == this.getWidth() && FXDefaultPreloader.this.currentHeight == this.getHeight()) {
                return;
            }
            FXDefaultPreloader.this.currentWidth = this.getWidth();
            FXDefaultPreloader.this.currentHeight = this.getHeight();
            this.setPrefHeight(FXDefaultPreloader.this.currentHeight);
            this.setPrefWidth(FXDefaultPreloader.this.currentWidth);
            if (FXDefaultPreloader.this.currentWidth > 40.0 && FXDefaultPreloader.this.currentHeight > 21.0) {
                this.percent.autosize();
                if (FXDefaultPreloader.this.currentWidth < 100.0 || FXDefaultPreloader.this.currentHeight < 100.0) {
                    this.graphic.setVisible(false);
                    this.progressBar.setVisible(false);
                    this.status.setVisible(false);
                    this.percent.relocate((FXDefaultPreloader.this.currentWidth - this.percent.getWidth()) / 2.0, (FXDefaultPreloader.this.currentHeight - this.percent.getHeight()) / 2.0);
                } else {
                    if (this.graphic != null) {
                        this.graphic.setVisible(true);
                        this.graphic.autosize();
                        this.graphic.relocate((FXDefaultPreloader.this.currentWidth - this.graphic.getWidth()) / 2.0, (FXDefaultPreloader.this.currentHeight / 2.0 - this.graphic.getHeight()) / 2.0);
                    }
                    this.status.setVisible(true);
                    this.status.autosize();
                    float progressWidthProportion = FXDefaultPreloader.this.currentWidth < 240.0 ? 0.75f : 0.65f;
                    this.progressBar.setVisible(true);
                    this.progressBar.setPrefWidth(FXDefaultPreloader.this.currentWidth * (double)progressWidthProportion);
                    this.progressBar.resize(this.progressBar.prefWidth(-1.0), this.progressBar.prefHeight(-1.0));
                    this.progressBar.relocate((FXDefaultPreloader.this.currentWidth - this.progressBar.getWidth()) / 2.0, FXDefaultPreloader.this.currentHeight / 2.0 - this.progressBar.getHeight());
                    this.status.relocate(this.progressBar.getLayoutX(), this.progressBar.getLayoutY() + this.progressBar.getHeight() + 4.0);
                    this.percent.relocate(this.progressBar.getLayoutX() + this.progressBar.getWidth() - this.percent.getWidth(), this.progressBar.getLayoutY() - this.percent.getHeight() - 4.0);
                }
            }
        }

        void setProgress(double progress) {
            this.progressBar.setProgress(progress);
            this.percent.setText(String.format("%.0f%%", progress * 100.0));
            this.percent.autosize();
            this.percent.setLayoutX(this.progressBar.getLayoutX() + this.progressBar.getPrefWidth() - this.percent.getWidth());
        }
    }

    private class FXPreloaderScene
    extends Scene {
        FXPreloaderScene(Parent parent) {
            super(parent, 600.0, 400.0);
            Scene s = new Scene(new Pane(), 0.0, 0.0);
            this.setRoot(parent);
            this.getStylesheets().addAll((String[])new String[]{FXDefaultPreloader.class.getResource("deploydialogs.css").toExternalForm()});
        }

        private void loadStylesheets() {
            String stylesheetParam = FXDefaultPreloader.this.getParameters().getNamed().get("javafx.default.preloader.stylesheet");
            if (stylesheetParam != null) {
                HostServices services = FXDefaultPreloader.this.getHostServices();
                String base = services.getDocumentBase();
                if (stylesheetParam.matches(".*\\.[bc]ss$")) {
                    String url = stylesheetParam.startsWith("jar:") ? "jar:" + services.resolveURI(base, stylesheetParam.substring(4)) : services.resolveURI(base, stylesheetParam);
                    this.getStylesheets().add(url);
                } else {
                    try {
                        Stylesheet stylesheet = CSSParser.getInstance().parse(base, stylesheetParam);
                        StyleManager.getInstance().replaceStylesheet(this, stylesheet);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FadeOutFinisher
    implements EventHandler<ActionEvent> {
        Stage stage;

        FadeOutFinisher(Stage stage) {
            this.stage = stage;
        }

        @Override
        public void handle(ActionEvent t) {
            if (this.stage.isShowing()) {
                this.stage.hide();
            }
        }
    }

    private static class StyleableProperties {
        private static StyleableProperty<FXPreloaderPane, String> PRELOADER_TEXT = new StyleableProperty<FXPreloaderPane, String>("-fx-preloader-text", (StyleConverter)StringConverter.getInstance()){

            @Override
            public boolean isSettable(FXPreloaderPane n) {
                return true;
            }

            @Override
            public WritableValue<String> getWritableValue(FXPreloaderPane n) {
                return n.preloaderText;
            }
        };
        private static StyleableProperty<FXPreloaderPane, String> PRELOADER_GRAPHIC = new StyleableProperty<FXPreloaderPane, String>("-fx-preloader-graphic", (StyleConverter)StringConverter.getInstance()){

            @Override
            public boolean isSettable(FXPreloaderPane n) {
                return true;
            }

            @Override
            public WritableValue<String> getWritableValue(FXPreloaderPane n) {
                return n.preloaderGraphicUrl;
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList();
            Collections.addAll(styleables, PRELOADER_TEXT, PRELOADER_GRAPHIC);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

