/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.applet;

import com.sun.applet2.Applet2;
import com.sun.applet2.Applet2Context;
import com.sun.applet2.preloader.event.ErrorEvent;
import com.sun.deploy.uitoolkit.impl.fx.DeployPerfLogger;
import com.sun.deploy.uitoolkit.impl.fx.FXPreloader;
import com.sun.deploy.uitoolkit.impl.fx.FXWindow;
import com.sun.deploy.uitoolkit.impl.fx.Utils;
import com.sun.javafx.application.ParametersImpl;
import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.perf.PerformanceTracker;
import java.security.AllPermission;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.stage.Stage;
import sun.misc.PerformanceLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FXApplet2
implements Applet2 {
    static final int SANDBOXAPP_DESTROY_TIMEOUT = 200;
    static final String JAVFX_APPLICATION_PARAM = "javafx.application";
    private Application application;
    private Applet2Context a2c;
    private FXWindow window;
    private Class<? extends Application> applicationClass = null;
    private boolean isAborted = false;

    public FXApplet2(Class<? extends Application> mainClass, FXWindow window) {
        this.applicationClass = mainClass;
        this.window = window;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Applet2Context ac) {
        FXApplet2 fXApplet2 = this;
        synchronized (fXApplet2) {
            if (this.isAborted) {
                return;
            }
        }
        DeployPerfLogger.timestamp("(start) application constructor");
        try {
            this.application = this.applicationClass.newInstance();
        }
        catch (Throwable e) {
            e.printStackTrace();
            FXPreloader.notifyCurrentPreloaderOnError(new ErrorEvent(null, "Failed to instantiate application.", e));
            if (e instanceof ClassCastException) {
                throw new UnsupportedOperationException("In the JavaFX mode we only support applications extending JavaFX Application class.", e);
            }
            throw new RuntimeException(e);
        }
        this.a2c = ac;
        DeployPerfLogger.timestamp("(done) application constructor");
        String[] unnamed = Utils.getUnnamed(this.a2c);
        Map<String, String> named = Utils.getNamedParameters(this.a2c);
        ParametersImpl.registerParameters(this.application, new ParametersImpl(named, unnamed));
        DeployPerfLogger.timestamp("(start) application.init()");
        try {
            this.application.init();
        }
        catch (Throwable e) {
            e.printStackTrace();
            FXPreloader.notifyCurrentPreloaderOnError(new ErrorEvent(null, "Failed to init application.", e));
            throw new RuntimeException(e);
        }
        DeployPerfLogger.timestamp("(done) application.init()");
    }

    public Application getApplication() {
        return this.application;
    }

    public synchronized void abortLaunch() {
        this.isAborted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        FXApplet2 fXApplet2 = this;
        synchronized (fXApplet2) {
            if (this.isAborted) {
                return;
            }
        }
        Platform.runLater(new Runnable(){

            public void run() {
                if (FXApplet2.this.application != null) {
                    DeployPerfLogger.timestamp("(start) application stage");
                    Stage appletStage = FXApplet2.this.window == null ? new Stage() : FXApplet2.this.window.getAppletStage();
                    DeployPerfLogger.timestamp("(done) application stage");
                    DeployPerfLogger.timestamp("(start) application.start()");
                    try {
                        String str;
                        FXApplet2.this.application.start(appletStage);
                        if (PerformanceTracker.isLoggingEnabled() && (str = FXApplet2.this.application.getParameters().getNamed().get("sun_perflog_fx_launchtime")) != null && !str.equals("")) {
                            long launchT = Long.parseLong(str);
                            PerformanceLogger.setStartTime((String)"LaunchTime", (long)launchT);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        FXPreloader.notifyCurrentPreloaderOnError(new ErrorEvent(null, "Failed to start application.", e));
                        throw new RuntimeException(e);
                    }
                    DeployPerfLogger.timestamp("(done) application.start()");
                } else {
                    System.err.println("application is null?");
                }
            }
        });
    }

    public void stop() {
    }

    private boolean isSandboxApplication() {
        try {
            ProtectionDomain pd = this.applicationClass.getProtectionDomain();
            if (pd.getPermissions().implies(new AllPermission())) {
                return false;
            }
        }
        catch (SecurityException se) {
            se.printStackTrace();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        FXApplet2 fXApplet2 = this;
        synchronized (fXApplet2) {
            if (this.isAborted) {
                return;
            }
        }
        PlatformImpl.runAndWait(new Runnable(){

            public void run() {
                if (FXApplet2.this.isSandboxApplication()) {
                    Timer exitTimer = new Timer("Exit timer", true);
                    TimerTask exitTask = new TimerTask(){

                        public void run() {
                            System.exit(0);
                        }
                    };
                    exitTimer.schedule(exitTask, 200L);
                }
                try {
                    FXApplet2.this.application.stop();
                    FXPreloader.notfiyCurrentPreloaderOnExit();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    FXPreloader.notifyCurrentPreloaderOnError(new ErrorEvent(null, "Failed to stop application.", e));
                }
            }
        });
    }
}

