/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.png;

import com.sun.javafx.iio.ImageFormatDescription;
import com.sun.javafx.iio.ImageLoader;
import com.sun.javafx.iio.ImageLoaderFactory;
import com.sun.javafx.iio.png.PNGDescriptor;
import com.sun.javafx.iio.png.PNGImageLoader;
import com.sun.javafx.iio.png.PNGImageLoader2;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class PNGImageLoaderFactory
implements ImageLoaderFactory {
    private static final String selectorPropertyName = "prism.useOldPNG";
    private static boolean useOldPngLoader = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean(PNGImageLoaderFactory.selectorPropertyName);
        }
    });
    private static final PNGImageLoaderFactory theInstance = new PNGImageLoaderFactory();

    private PNGImageLoaderFactory() {
    }

    public static final ImageLoaderFactory getInstance() {
        return theInstance;
    }

    @Override
    public ImageFormatDescription getFormatDescription() {
        return PNGDescriptor.getInstance();
    }

    @Override
    public ImageLoader createImageLoader(InputStream inputStream) throws IOException {
        return useOldPngLoader ? new PNGImageLoader(inputStream) : new PNGImageLoader2(inputStream);
    }
}

