/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import com.sun.javafx.collections.ListListenerHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public abstract class ReadOnlyUnbackedObservableList<T>
implements ObservableList<T> {
    private ListListenerHelper<T> listenerHelper;

    @Override
    public abstract T get(int var1);

    @Override
    public abstract int size();

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        this.listenerHelper = ListListenerHelper.addListener(this.listenerHelper, invalidationListener);
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        this.listenerHelper = ListListenerHelper.removeListener(this.listenerHelper, invalidationListener);
    }

    @Override
    public void addListener(ListChangeListener<? super T> listChangeListener) {
        this.listenerHelper = ListListenerHelper.addListener(this.listenerHelper, listChangeListener);
    }

    @Override
    public void removeListener(ListChangeListener<? super T> listChangeListener) {
        this.listenerHelper = ListListenerHelper.removeListener(this.listenerHelper, listChangeListener);
    }

    public void callObservers(ListChangeListener.Change<T> change) {
        ListListenerHelper.fireValueChangedEvent(this.listenerHelper, change);
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            return -1;
        }
        for (int i = 0; i < this.size(); ++i) {
            T t = this.get(i);
            if (!object.equals(t)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (object == null) {
            return -1;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            T t = this.get(i);
            if (!object.equals(t)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new SelectionListIterator(this);
    }

    @Override
    public ListIterator<T> listIterator(int n) {
        return new SelectionListIterator(this, n);
    }

    @Override
    public Iterator<T> iterator() {
        return new SelectionListIterator(this);
    }

    @Override
    public List<T> subList(final int n, final int n2) {
        if (n >= n2) {
            return Collections.emptyList();
        }
        final ReadOnlyUnbackedObservableList readOnlyUnbackedObservableList = this;
        return new ReadOnlyUnbackedObservableList<T>(){

            @Override
            public T get(int n3) {
                return readOnlyUnbackedObservableList.get(n3 + n);
            }

            @Override
            public int size() {
                return n2 - n;
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            objectArray[i] = this.get(i);
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Object[] objectArray = TArray;
        if (objectArray.length < this.size()) {
            objectArray = new Object[this.size()];
        }
        for (int i = 0; i < this.size(); ++i) {
            objectArray[i] = this.get(i);
        }
        return objectArray;
    }

    public String toString() {
        Iterator<T> iterator = this.iterator();
        if (!iterator.hasNext()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        while (true) {
            T t;
            stringBuilder.append((Object)((t = iterator.next()) == this ? "(this Collection)" : t));
            if (!iterator.hasNext()) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
        }
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void add(int n, T t) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean addAll(int n, Collection<? extends T> collection) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean addAll(T ... TArray) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public T set(int n, T t) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean setAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean setAll(T ... TArray) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public T remove(int n) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void remove(int n, int n2) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean removeAll(T ... TArray) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean retainAll(T ... TArray) {
        throw new UnsupportedOperationException("Not supported.");
    }

    private static class SelectionListIterator<T>
    implements ListIterator<T> {
        private int pos;
        private final ReadOnlyUnbackedObservableList<T> list;

        public SelectionListIterator(ReadOnlyUnbackedObservableList<T> readOnlyUnbackedObservableList) {
            this(readOnlyUnbackedObservableList, 0);
        }

        public SelectionListIterator(ReadOnlyUnbackedObservableList<T> readOnlyUnbackedObservableList, int n) {
            this.list = readOnlyUnbackedObservableList;
            this.pos = n;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.list.size();
        }

        @Override
        public T next() {
            return this.list.get(this.pos++);
        }

        @Override
        public boolean hasPrevious() {
            return this.pos > 0;
        }

        @Override
        public T previous() {
            return this.list.get(this.pos--);
        }

        @Override
        public int nextIndex() {
            return this.pos + 1;
        }

        @Override
        public int previousIndex() {
            return this.pos - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public void set(T t) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public void add(T t) {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

