/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.BaseNode;
import com.sun.javafx.sg.PGNode;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;

public abstract class BaseCacheFilter {
    protected ImageData cachedImageData;
    private Affine2D cachedXform = new Affine2D();
    private double cachedScaleX;
    private double cachedScaleY;
    private double cachedRotate;
    protected double cachedX;
    protected double cachedY;
    protected BaseNode node;
    protected Affine2D screenXform = new Affine2D();
    private boolean scaleHint;
    private boolean rotateHint;
    private PGNode.CacheHint cacheHint;
    private boolean wasUnsupported = false;
    private static final double EPSILON = 1.0E-7;

    protected BaseCacheFilter(BaseNode baseNode, PGNode.CacheHint cacheHint) {
        this.node = baseNode;
        this.setHint(cacheHint);
    }

    public void setHint(PGNode.CacheHint cacheHint) {
        this.cacheHint = cacheHint;
        this.scaleHint = cacheHint == PGNode.CacheHint.SCALE || cacheHint == PGNode.CacheHint.SCALE_AND_ROTATE;
        this.rotateHint = cacheHint == PGNode.CacheHint.ROTATE || cacheHint == PGNode.CacheHint.SCALE_AND_ROTATE;
    }

    boolean matchesHint(PGNode.CacheHint cacheHint) {
        return this.cacheHint == cacheHint;
    }

    protected abstract ImageData impl_createImageData(FilterContext var1, BaseTransform var2);

    protected abstract void impl_renderNodeToScreen(Object var1, BaseTransform var2);

    protected abstract void impl_renderCacheToScreen(Object var1, Filterable var2, double var3, double var5);

    public void render(Object object, BaseTransform baseTransform, FilterContext filterContext) {
        Object object2;
        double d = baseTransform.getMxx();
        double d2 = baseTransform.getMyx();
        double d3 = baseTransform.getMxy();
        double d4 = baseTransform.getMyy();
        double d5 = baseTransform.getMxt();
        double d6 = baseTransform.getMyt();
        double[] dArray = this.unmatrix(baseTransform);
        boolean bl = this.unsupported(dArray);
        if (this.needToRenderCache(filterContext, baseTransform, dArray)) {
            this.invalidate();
            this.cachedXform.setTransform(d, d2, d3, d4, 0.0, 0.0);
            this.cachedScaleX = dArray[0];
            this.cachedScaleY = dArray[1];
            this.cachedRotate = dArray[2];
            this.cachedImageData = this.impl_createImageData(filterContext, this.cachedXform);
            object2 = this.cachedImageData.getUntransformedBounds();
            this.cachedX = ((Rectangle)object2).x;
            this.cachedY = ((Rectangle)object2).y;
            this.screenXform.setTransform(BaseTransform.IDENTITY_TRANSFORM);
        } else if (bl) {
            this.screenXform.setTransform(BaseTransform.IDENTITY_TRANSFORM);
        } else {
            this.updateScreenXform(dArray);
        }
        this.wasUnsupported = bl;
        object2 = this.cachedImageData.getUntransformedImage();
        if (object2 == null) {
            this.impl_renderNodeToScreen(object, baseTransform);
        } else {
            this.impl_renderCacheToScreen(object, (Filterable)object2, d5, d6);
        }
    }

    boolean unsupported(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        return (d3 > 1.0E-7 || d3 < -1.0E-7) && (d > d2 + 1.0E-7 || d2 > d + 1.0E-7 || d < d2 - 1.0E-7 || d2 < d - 1.0E-7 || this.cachedScaleX > this.cachedScaleY + 1.0E-7 || this.cachedScaleY > this.cachedScaleX + 1.0E-7 || this.cachedScaleX < this.cachedScaleY - 1.0E-7 || this.cachedScaleY < this.cachedScaleX - 1.0E-7);
    }

    boolean needToRenderCache(FilterContext filterContext, BaseTransform baseTransform, double[] dArray) {
        if (this.cachedImageData == null || !this.cachedImageData.validate(filterContext)) {
            return true;
        }
        if (this.cachedXform.getMxx() == baseTransform.getMxx() && this.cachedXform.getMyy() == baseTransform.getMyy() && this.cachedXform.getMxy() == baseTransform.getMxy() && this.cachedXform.getMyx() == baseTransform.getMyx()) {
            return false;
        }
        if (this.wasUnsupported || this.unsupported(dArray)) {
            return true;
        }
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        if (this.scaleHint) {
            if (this.rotateHint) {
                return false;
            }
            return !(this.cachedRotate - 1.0E-7 < d3) || !(d3 < this.cachedRotate + 1.0E-7);
        }
        if (this.rotateHint) {
            return !(this.cachedScaleX - 1.0E-7 < d) || !(d < this.cachedScaleX + 1.0E-7) || !(this.cachedScaleY - 1.0E-7 < d2) || !(d2 < this.cachedScaleY + 1.0E-7);
        }
        return true;
    }

    void updateScreenXform(double[] dArray) {
        if (this.scaleHint) {
            if (this.rotateHint) {
                double d = dArray[0] / this.cachedScaleX;
                double d2 = dArray[1] / this.cachedScaleY;
                double d3 = dArray[2] - this.cachedRotate;
                this.screenXform.setToScale(d, d2);
                this.screenXform.rotate(d3);
            } else {
                double d = dArray[0] / this.cachedScaleX;
                double d4 = dArray[1] / this.cachedScaleY;
                this.screenXform.setToScale(d, d4);
            }
        } else if (this.rotateHint) {
            double d = dArray[2] - this.cachedRotate;
            this.screenXform.setToRotation(d, 0.0, 0.0);
        } else {
            this.screenXform.setTransform(BaseTransform.IDENTITY_TRANSFORM);
        }
    }

    public void invalidate() {
        if (this.cachedImageData != null) {
            this.cachedImageData.unref();
            this.cachedImageData = null;
        }
    }

    public void dispose() {
        this.invalidate();
        this.node = null;
    }

    double[] unmatrix(BaseTransform baseTransform) {
        double[] dArray = new double[3];
        double[][] dArrayArray = new double[][]{{baseTransform.getMxx(), baseTransform.getMxy()}, {baseTransform.getMyx(), baseTransform.getMyy()}};
        double d = this.v2length(dArrayArray[0]);
        this.v2scale(dArrayArray[0], 1.0);
        double d2 = this.v2dot(dArrayArray[0], dArrayArray[1]);
        this.v2combine(dArrayArray[1], dArrayArray[0], dArrayArray[1], 1.0, -d2);
        double d3 = this.v2length(dArrayArray[1]);
        this.v2scale(dArrayArray[1], 1.0);
        d2 /= d3;
        if (dArrayArray[0][0] * dArrayArray[1][1] - dArrayArray[0][1] * dArrayArray[1][0] < 0.0) {
            d *= -1.0;
            d3 *= -1.0;
            double[] dArray2 = dArrayArray[0];
            dArray2[0] = dArray2[0] * -1.0;
            double[] dArray3 = dArrayArray[0];
            dArray3[1] = dArray3[1] * -1.0;
            double[] dArray4 = dArrayArray[1];
            dArray4[0] = dArray4[0] * -1.0;
            double[] dArray5 = dArrayArray[1];
            dArray5[1] = dArray5[1] * -1.0;
        }
        double d4 = dArrayArray[1][0];
        double d5 = dArrayArray[0][0];
        double d6 = 0.0;
        d6 = d4 >= 0.0 ? Math.acos(d5) : (d5 > 0.0 ? Math.PI * 2 + Math.asin(d4) : Math.PI + Math.acos(-d5));
        dArray[0] = d;
        dArray[1] = d3;
        dArray[2] = d6;
        return dArray;
    }

    void v2combine(double[] dArray, double[] dArray2, double[] dArray3, double d, double d2) {
        dArray3[0] = d * dArray[0] + d2 * dArray2[0];
        dArray3[1] = d * dArray[1] + d2 * dArray2[1];
    }

    double v2dot(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1];
    }

    double[] v2scale(double[] dArray, double d) {
        double d2 = this.v2length(dArray);
        double[] dArray2 = dArray;
        if (d2 != 0.0) {
            dArray[0] = dArray[0] * (d / d2);
            dArray[1] = dArray[1] * (d / d2);
        }
        return dArray2;
    }

    double v2length(double[] dArray) {
        return Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
    }
}

