/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.StyleableProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.event.ActionEvent;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;

public class Hyperlink
extends ButtonBase {
    private BooleanProperty visited;
    private static final String DEFAULT_STYLE_CLASS = "hyperlink";
    private static final String PSEUDO_CLASS_VISITED = "visited";
    private static final long VISITED_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("visited");

    public Hyperlink() {
        this.initialize();
    }

    public Hyperlink(String string) {
        super(string);
        this.initialize();
    }

    public Hyperlink(String string, Node node) {
        super(string, node);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        StyleableProperty styleableProperty = StyleableProperty.getStyleableProperty(this.cursorProperty());
        styleableProperty.set(this, Cursor.HAND);
    }

    public final BooleanProperty visitedProperty() {
        if (this.visited == null) {
            this.visited = new BooleanPropertyBase(){

                @Override
                protected void invalidated() {
                    Hyperlink.this.impl_pseudoClassStateChanged(Hyperlink.PSEUDO_CLASS_VISITED);
                }

                @Override
                public Object getBean() {
                    return Hyperlink.this;
                }

                @Override
                public String getName() {
                    return Hyperlink.PSEUDO_CLASS_VISITED;
                }
            };
        }
        return this.visited;
    }

    public final void setVisited(boolean bl) {
        this.visitedProperty().set(bl);
    }

    public final boolean isVisited() {
        return this.visited == null ? false : this.visited.get();
    }

    @Override
    public void fire() {
        if (this.visited == null || !this.visited.isBound()) {
            this.setVisited(true);
        }
        this.fireEvent(new ActionEvent());
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        if (this.isVisited()) {
            l |= VISITED_PSEUDOCLASS_STATE;
        }
        return l;
    }

    @Override
    @Deprecated
    protected Cursor impl_cssGetCursorInitialValue() {
        return Cursor.HAND;
    }
}

