/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.rounding.DateTimeUnit;
import org.elasticsearch.common.rounding.Rounding;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.MultiBucketConsumerService;
import org.elasticsearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.internal.SearchContext;
import org.joda.time.DateTimeZone;

public class AutoDateHistogramAggregationBuilder
extends ValuesSourceAggregationBuilder<ValuesSource.Numeric, AutoDateHistogramAggregationBuilder> {
    public static final String NAME = "auto_date_histogram";
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(AutoDateHistogramAggregationBuilder.class));
    public static final ParseField NUM_BUCKETS_FIELD = new ParseField("buckets", new String[0]);
    private static final ObjectParser<AutoDateHistogramAggregationBuilder, Void> PARSER = new ObjectParser("auto_date_histogram");
    private int numBuckets = 10;

    static RoundingInfo[] buildRoundings(DateTimeZone timeZone) {
        RoundingInfo[] roundings = new RoundingInfo[]{new RoundingInfo(AutoDateHistogramAggregationBuilder.createRounding(DateTimeUnit.SECOND_OF_MINUTE, timeZone), 1000L, "s", 1, 5, 10, 30), new RoundingInfo(AutoDateHistogramAggregationBuilder.createRounding(DateTimeUnit.MINUTES_OF_HOUR, timeZone), 60000L, "m", 1, 5, 10, 30), new RoundingInfo(AutoDateHistogramAggregationBuilder.createRounding(DateTimeUnit.HOUR_OF_DAY, timeZone), 3600000L, "h", 1, 3, 12), new RoundingInfo(AutoDateHistogramAggregationBuilder.createRounding(DateTimeUnit.DAY_OF_MONTH, timeZone), 86400000L, "d", 1, 7), new RoundingInfo(AutoDateHistogramAggregationBuilder.createRounding(DateTimeUnit.MONTH_OF_YEAR, timeZone), 2592000000L, "M", 1, 3), new RoundingInfo(AutoDateHistogramAggregationBuilder.createRounding(DateTimeUnit.YEAR_OF_CENTURY, timeZone), 31536000000L, "y", 1, 5, 10, 20, 50, 100)};
        return roundings;
    }

    public static AutoDateHistogramAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        return (AutoDateHistogramAggregationBuilder)PARSER.parse(parser, (Object)new AutoDateHistogramAggregationBuilder(aggregationName), null);
    }

    public AutoDateHistogramAggregationBuilder(String name) {
        super(name, ValuesSourceType.NUMERIC, ValueType.DATE);
    }

    public AutoDateHistogramAggregationBuilder(StreamInput in) throws IOException {
        super(in, ValuesSourceType.NUMERIC, ValueType.DATE);
        this.numBuckets = in.readVInt();
    }

    protected AutoDateHistogramAggregationBuilder(AutoDateHistogramAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.numBuckets = clone.numBuckets;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new AutoDateHistogramAggregationBuilder(this, factoriesBuilder, metaData);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.numBuckets);
    }

    @Override
    public String getType() {
        return NAME;
    }

    public AutoDateHistogramAggregationBuilder setNumBuckets(int numBuckets) {
        if (numBuckets <= 0) {
            throw new IllegalArgumentException(NUM_BUCKETS_FIELD.getPreferredName() + " must be greater than 0 for [" + this.name + "]");
        }
        this.numBuckets = numBuckets;
        return this;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    @Override
    protected ValuesSourceAggregatorFactory<ValuesSource.Numeric, ?> innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource.Numeric> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        RoundingInfo[] roundings = AutoDateHistogramAggregationBuilder.buildRoundings(this.timeZone());
        int maxRoundingInterval = Arrays.stream(roundings, 0, roundings.length - 1).map(rounding -> rounding.innerIntervals).flatMapToInt(Arrays::stream).boxed().reduce(Integer::max).get();
        Settings settings = context.getQueryShardContext().getIndexSettings().getNodeSettings();
        int maxBuckets = MultiBucketConsumerService.MAX_BUCKET_SETTING.get(settings);
        if (maxBuckets >= 0) {
            int bucketCeiling = maxBuckets / maxRoundingInterval;
            if (this.numBuckets > bucketCeiling) {
                throw new IllegalArgumentException(NUM_BUCKETS_FIELD.getPreferredName() + " must be less than " + bucketCeiling);
            }
        } else if (this.numBuckets > 10000 / maxRoundingInterval) {
            DEPRECATION_LOGGER.deprecated("This request will fail in 7.x, because number of buckets, " + this.numBuckets + ", is greater than default max buckets (" + 10000 + ") divided by the max rounding interval (" + maxRoundingInterval + ").", new Object[0]);
        }
        return new AutoDateHistogramAggregatorFactory(this.name, config, this.numBuckets, roundings, context, parent, subFactoriesBuilder, this.metaData);
    }

    static Rounding createRounding(DateTimeUnit interval, DateTimeZone timeZone) {
        Rounding.Builder tzRoundingBuilder = Rounding.builder(interval);
        if (timeZone != null) {
            tzRoundingBuilder.timeZone(timeZone);
        }
        Rounding rounding = tzRoundingBuilder.build();
        return rounding;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(NUM_BUCKETS_FIELD.getPreferredName(), this.numBuckets);
        return builder;
    }

    @Override
    protected int innerHashCode() {
        return Objects.hash(this.numBuckets);
    }

    @Override
    protected boolean innerEquals(Object obj) {
        AutoDateHistogramAggregationBuilder other = (AutoDateHistogramAggregationBuilder)obj;
        return Objects.equals(this.numBuckets, other.numBuckets);
    }

    static {
        ValuesSourceParserHelper.declareNumericFields(PARSER, true, true, true);
        PARSER.declareInt(AutoDateHistogramAggregationBuilder::setNumBuckets, NUM_BUCKETS_FIELD);
    }

    public static class RoundingInfo
    implements Writeable {
        final Rounding rounding;
        final int[] innerIntervals;
        final long roughEstimateDurationMillis;
        final String unitAbbreviation;

        public RoundingInfo(Rounding rounding, long roughEstimateDurationMillis, String unitAbbreviation, int ... innerIntervals) {
            this.rounding = rounding;
            this.roughEstimateDurationMillis = roughEstimateDurationMillis;
            this.unitAbbreviation = unitAbbreviation;
            this.innerIntervals = innerIntervals;
        }

        public RoundingInfo(StreamInput in) throws IOException {
            this.rounding = Rounding.Streams.read(in);
            this.roughEstimateDurationMillis = in.readVLong();
            this.innerIntervals = in.readIntArray();
            this.unitAbbreviation = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            Rounding.Streams.write(this.rounding, out);
            out.writeVLong(this.roughEstimateDurationMillis);
            out.writeIntArray(this.innerIntervals);
            out.writeString(this.unitAbbreviation);
        }

        public int getMaximumInnerInterval() {
            return this.innerIntervals[this.innerIntervals.length - 1];
        }

        public long getRoughEstimateDurationMillis() {
            return this.roughEstimateDurationMillis;
        }

        public int hashCode() {
            return Objects.hash(this.rounding, Arrays.hashCode(this.innerIntervals));
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            RoundingInfo other = (RoundingInfo)obj;
            return Objects.equals(this.rounding, other.rounding) && Objects.deepEquals(this.innerIntervals, other.innerIntervals);
        }
    }
}

