/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableDoubleProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.animation.TimelineBuilder;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class StackedBarChart<X, Y>
extends XYChart<X, Y> {
    private Map<XYChart.Series, Map<String, XYChart.Data<X, Y>>> seriesCategoryMap = new HashMap<XYChart.Series, Map<String, XYChart.Data<X, Y>>>();
    private Legend legend = new Legend();
    private final Orientation orientation;
    private CategoryAxis categoryAxis;
    private ValueAxis valueAxis;
    private int seriesDefaultColorIndex = 0;
    private Map<XYChart.Series<X, Y>, String> seriesDefaultColorMap = new HashMap<XYChart.Series<X, Y>, String>();
    private DoubleProperty categoryGap = new StyleableDoubleProperty(10.0){

        @Override
        protected void invalidated() {
            this.get();
            StackedBarChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return StackedBarChart.this;
        }

        @Override
        public String getName() {
            return "categoryGap";
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.CATEGORY_GAP;
        }
    };

    public double getCategoryGap() {
        return this.categoryGap.getValue();
    }

    public void setCategoryGap(double d) {
        this.categoryGap.setValue(d);
    }

    public DoubleProperty categoryGapProperty() {
        return this.categoryGap;
    }

    public StackedBarChart(Axis<X> axis, Axis<Y> axis2) {
        this(axis, axis2, FXCollections.observableArrayList());
    }

    public StackedBarChart(Axis<X> axis, Axis<Y> axis2, ObservableList<XYChart.Series<X, Y>> observableList) {
        super(axis, axis2);
        this.getStyleClass().add("stacked-bar-chart");
        this.setLegend(this.legend);
        if (!(axis instanceof ValueAxis && axis2 instanceof CategoryAxis || axis2 instanceof ValueAxis && axis instanceof CategoryAxis)) {
            throw new IllegalArgumentException("Axis type incorrect, one of X,Y should be CategoryAxis and the other NumberAxis");
        }
        if (axis instanceof CategoryAxis) {
            this.categoryAxis = (CategoryAxis)axis;
            this.valueAxis = (ValueAxis)axis2;
            this.orientation = Orientation.VERTICAL;
        } else {
            this.categoryAxis = (CategoryAxis)axis2;
            this.valueAxis = (ValueAxis)axis;
            this.orientation = Orientation.HORIZONTAL;
        }
        this.setData(observableList);
    }

    public StackedBarChart(Axis<X> axis, Axis<Y> axis2, ObservableList<XYChart.Series<X, Y>> observableList, double d) {
        this(axis, axis2);
        this.setData(observableList);
        this.setCategoryGap(d);
    }

    @Override
    protected void dataItemAdded(XYChart.Series<X, Y> series, int n, XYChart.Data<X, Y> data) {
        String string = this.orientation == Orientation.VERTICAL ? (String)data.getXValue() : (String)data.getYValue();
        Map<String, XYChart.Data<X, Y>> map = this.seriesCategoryMap.get(series);
        if (map == null) {
            map = new HashMap<String, XYChart.Data<X, Y>>();
            this.seriesCategoryMap.put(series, map);
        }
        map.put(string, data);
        Node node = this.createBar(series, this.getData().indexOf(series), data, n);
        if (this.shouldAnimate()) {
            this.animateDataAdd(data, node);
        } else {
            this.getPlotChildren().add(node);
        }
    }

    @Override
    protected void dataItemRemoved(final XYChart.Data<X, Y> data, final XYChart.Series<X, Y> series) {
        Node node = data.getNode();
        if (this.shouldAnimate()) {
            Timeline timeline = this.createDataRemoveTimeline(data, node, series);
            timeline.setOnFinished(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    StackedBarChart.this.removeDataItemFromDisplay(series, data);
                }
            });
            timeline.play();
        } else {
            this.getPlotChildren().remove(node);
            this.removeDataItemFromDisplay(series, data);
        }
    }

    @Override
    protected void dataItemChanged(XYChart.Data<X, Y> data) {
        double d;
        double d2;
        if (this.orientation == Orientation.VERTICAL) {
            d2 = ((Number)data.getYValue()).doubleValue();
            d = ((Number)this.getCurrentDisplayedYValue(data)).doubleValue();
        } else {
            d2 = ((Number)data.getXValue()).doubleValue();
            d = ((Number)this.getCurrentDisplayedXValue(data)).doubleValue();
        }
        if (d > 0.0 && d2 < 0.0) {
            data.getNode().getStyleClass().add("negative");
        } else if (d < 0.0 && d2 > 0.0) {
            data.getNode().getStyleClass().add("negative");
        }
    }

    private void animateDataAdd(XYChart.Data<X, Y> data, Node node) {
        if (this.orientation == Orientation.VERTICAL) {
            double d = ((Number)data.getYValue()).doubleValue();
            if (d < 0.0) {
                node.getStyleClass().add("negative");
            }
            data.setYValue(this.getYAxis().toRealValue(this.getYAxis().getZeroPosition()));
            this.setCurrentDisplayedYValue(data, this.getYAxis().toRealValue(this.getYAxis().getZeroPosition()));
            this.getPlotChildren().add(node);
            data.setYValue(this.getYAxis().toRealValue(d));
            this.animate(TimelineBuilder.create().keyFrames(new KeyFrame(Duration.ZERO, new KeyValue(this.currentDisplayedYValueProperty(data), this.getCurrentDisplayedYValue(data))), new KeyFrame(Duration.millis(700.0), new KeyValue(this.currentDisplayedYValueProperty(data), data.getYValue(), Interpolator.EASE_BOTH))).build());
        } else {
            double d = ((Number)data.getXValue()).doubleValue();
            if (d < 0.0) {
                node.getStyleClass().add("negative");
            }
            data.setXValue(this.getXAxis().toRealValue(this.getXAxis().getZeroPosition()));
            this.setCurrentDisplayedXValue(data, this.getXAxis().toRealValue(this.getXAxis().getZeroPosition()));
            this.getPlotChildren().add(node);
            data.setXValue(this.getXAxis().toRealValue(d));
            this.animate(TimelineBuilder.create().keyFrames(new KeyFrame(Duration.ZERO, new KeyValue(this.currentDisplayedXValueProperty(data), this.getCurrentDisplayedXValue(data))), new KeyFrame(Duration.millis(700.0), new KeyValue(this.currentDisplayedXValueProperty(data), data.getXValue(), Interpolator.EASE_BOTH))).build());
        }
    }

    @Override
    protected void seriesAdded(XYChart.Series<X, Y> series, int n) {
        String string = "default-color" + this.seriesDefaultColorIndex % 8;
        this.seriesDefaultColorMap.put(series, string);
        ++this.seriesDefaultColorIndex;
        HashMap<String, XYChart.Data> hashMap = new HashMap<String, XYChart.Data>();
        for (int i = 0; i < series.getData().size(); ++i) {
            XYChart.Data data = (XYChart.Data)series.getData().get(i);
            Node node = this.createBar(series, n, data, i);
            String string2 = this.orientation == Orientation.VERTICAL ? (String)data.getXValue() : (String)data.getYValue();
            hashMap.put(string2, data);
            if (this.shouldAnimate()) {
                this.animateDataAdd(data, node);
                continue;
            }
            this.getPlotChildren().add(node);
        }
        if (hashMap.size() > 0) {
            this.seriesCategoryMap.put(series, hashMap);
        }
    }

    private Timeline createDataRemoveTimeline(XYChart.Data<X, Y> data, final Node node, XYChart.Series<X, Y> series) {
        Timeline timeline = new Timeline();
        if (this.orientation == Orientation.VERTICAL) {
            data.setYValue(this.getYAxis().toRealValue(this.getYAxis().getZeroPosition()));
            timeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue(this.currentDisplayedYValueProperty(data), this.getCurrentDisplayedYValue(data))), new KeyFrame(Duration.millis(700.0), new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    StackedBarChart.this.getPlotChildren().remove(node);
                }
            }, new KeyValue(this.currentDisplayedYValueProperty(data), data.getYValue(), Interpolator.EASE_BOTH))});
        } else {
            data.setXValue(this.getXAxis().toRealValue(this.getXAxis().getZeroPosition()));
            timeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue(this.currentDisplayedXValueProperty(data), this.getCurrentDisplayedXValue(data))), new KeyFrame(Duration.millis(700.0), new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    StackedBarChart.this.getPlotChildren().remove(node);
                }
            }, new KeyValue(this.currentDisplayedXValueProperty(data), data.getXValue(), Interpolator.EASE_BOTH))});
        }
        return timeline;
    }

    @Override
    protected void seriesRemoved(final XYChart.Series<X, Y> series) {
        if (this.shouldAnimate()) {
            ParallelTransition parallelTransition = new ParallelTransition();
            parallelTransition.setOnFinished(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    StackedBarChart.this.removeSeriesFromDisplay(series);
                }
            });
            for (XYChart.Data data : series.getData()) {
                final Node node = data.getNode();
                if (this.getSeriesSize() > 1) {
                    for (int i = 0; i < series.getData().size(); ++i) {
                        XYChart.Data data2 = (XYChart.Data)series.getData().get(i);
                        Timeline timeline = this.createDataRemoveTimeline(data2, node, series);
                        parallelTransition.getChildren().add(timeline);
                    }
                    continue;
                }
                FadeTransition fadeTransition = new FadeTransition(Duration.millis(700.0), node);
                fadeTransition.setFromValue(1.0);
                fadeTransition.setToValue(0.0);
                fadeTransition.setOnFinished(new EventHandler<ActionEvent>(){

                    @Override
                    public void handle(ActionEvent actionEvent) {
                        StackedBarChart.this.getPlotChildren().remove(node);
                    }
                });
                parallelTransition.getChildren().add(fadeTransition);
            }
            parallelTransition.play();
        } else {
            for (XYChart.Data data : series.getData()) {
                Node node = data.getNode();
                this.getPlotChildren().remove(node);
            }
            this.removeSeriesFromDisplay(series);
        }
    }

    @Override
    protected void updateAxisRange() {
        XYChart.Data data;
        XYChart.Series series;
        Iterator iterator;
        double d;
        int n;
        int n2;
        ArrayList<Object> arrayList;
        Axis axis = this.getXAxis();
        Axis axis2 = this.getYAxis();
        if (axis.isAutoRanging()) {
            arrayList = new ArrayList<Object>();
            if (axis instanceof CategoryAxis) {
                arrayList.addAll(this.categoryAxis.getCategories());
            } else {
                n2 = 0;
                for (String string : this.categoryAxis.getCategories()) {
                    n = 0;
                    d = 0.0;
                    iterator = this.getDisplayedSeriesIterator();
                    while (iterator.hasNext()) {
                        series = iterator.next();
                        data = this.getDataItem(series, n, n2, string);
                        d += axis.toNumericValue(data.getXValue());
                    }
                    arrayList.add(d);
                    ++n2;
                }
            }
            axis.invalidateRange(arrayList);
        }
        if (axis2.isAutoRanging()) {
            arrayList = new ArrayList();
            if (axis2 instanceof CategoryAxis) {
                arrayList.addAll(this.categoryAxis.getCategories());
            } else {
                n2 = 0;
                for (String string : this.categoryAxis.getCategories()) {
                    n = 0;
                    d = 0.0;
                    iterator = this.getDisplayedSeriesIterator();
                    while (iterator.hasNext()) {
                        series = iterator.next();
                        data = this.getDataItem(series, n, n2, string);
                        if (data == null) continue;
                        d += axis2.toNumericValue(data.getYValue());
                    }
                    arrayList.add(d);
                    ++n2;
                }
            }
            axis2.invalidateRange(arrayList);
        }
    }

    @Override
    protected void layoutPlotChildren() {
        double d;
        double d2 = this.categoryAxis.getCategorySpacing();
        double d3 = d = d2 - this.getCategoryGap();
        double d4 = -((d2 - this.getCategoryGap()) / 2.0);
        double d5 = this.valueAxis.getZeroPosition();
        int n = 0;
        for (String string : this.categoryAxis.getCategories()) {
            int n2 = 0;
            int n3 = 0;
            Iterator iterator = this.getDisplayedSeriesIterator();
            while (iterator.hasNext()) {
                double d6;
                double d7;
                XYChart.Series series = iterator.next();
                XYChart.Data data = this.getDataItem(series, n2, n, string);
                if (data == null) continue;
                Node node = data.getNode();
                if (this.orientation == Orientation.VERTICAL) {
                    d7 = this.getXAxis().getDisplayPosition(this.getCurrentDisplayedXValue(data));
                    d6 = this.getYAxis().getDisplayPosition(this.getCurrentDisplayedYValue(data));
                } else {
                    d7 = this.getYAxis().getDisplayPosition(this.getCurrentDisplayedYValue(data));
                    d6 = this.getXAxis().getDisplayPosition(this.getCurrentDisplayedXValue(data));
                }
                double d8 = (double)n3 + Math.min(d6, d5);
                double d9 = (double)n3 + Math.max(d6, d5);
                if (this.orientation == Orientation.VERTICAL) {
                    node.resizeRelocate(d7 + d4, d8, d3, d9 - d8);
                } else {
                    node.resizeRelocate(d8, d7 + d4, d9 - d8, d3);
                }
                n3 = (int)((double)n3 - (d9 - d8));
                ++n2;
            }
            ++n;
        }
    }

    @Override
    int getSeriesSize() {
        int n = 0;
        Iterator iterator = this.getDisplayedSeriesIterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        return n;
    }

    @Override
    protected void updateLegend() {
        this.legend.getItems().clear();
        if (this.getData() != null) {
            for (int i = 0; i < this.getData().size(); ++i) {
                XYChart.Series series = (XYChart.Series)this.getData().get(i);
                Legend.LegendItem legendItem = new Legend.LegendItem(series.getName());
                String string = this.seriesDefaultColorMap.get(series);
                legendItem.getSymbol().getStyleClass().addAll((String[])new String[]{"chart-bar", "series" + i, "bar-legend-symbol", string});
                this.legend.getItems().add(legendItem);
            }
        }
        if (this.legend.getItems().size() > 0) {
            if (this.getLegend() == null) {
                this.setLegend(this.legend);
            }
        } else {
            this.setLegend(null);
        }
    }

    private Node createBar(XYChart.Series series, int n, XYChart.Data data, int n2) {
        Node node = data.getNode();
        if (node == null) {
            node = new StackPane();
            data.setNode(node);
        }
        String string = this.seriesDefaultColorMap.get(series);
        node.getStyleClass().setAll((String[])new String[]{"chart-bar", "series" + n, "data" + n2, string});
        return node;
    }

    private XYChart.Data<X, Y> getDataItem(XYChart.Series<X, Y> series, int n, int n2, String string) {
        Map<String, XYChart.Data<X, Y>> map = this.seriesCategoryMap.get(series);
        return map.get(string);
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return StackedBarChart.impl_CSS_STYLEABLES();
    }

    private static class StyleableProperties {
        private static final StyleableProperty<StackedBarChart, Number> CATEGORY_GAP = new StyleableProperty<StackedBarChart, Number>("-fx-category-gap", (StyleConverter)SizeConverter.getInstance(), (Number)10.0){

            @Override
            public boolean isSettable(StackedBarChart stackedBarChart) {
                return stackedBarChart.categoryGap == null || !stackedBarChart.categoryGap.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(StackedBarChart stackedBarChart) {
                return stackedBarChart.categoryGapProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(XYChart.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, CATEGORY_GAP);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

