/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.AbsolutePathFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultCurrentFileCollectionFingerprint;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskFingerprintUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskFingerprintUtil.class);

    public static ImmutableSortedMap<String, CurrentFileCollectionFingerprint> fingerprintAfterOutputsGenerated(final @Nullable ImmutableSortedMap<String, FileCollectionFingerprint> previous, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> current, SortedSet<? extends TaskFilePropertySpec> outputProperties, boolean hasOverlappingOutputs, TaskInternal task, FileCollectionFingerprinterRegistry fingerprinterRegistry) {
        final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> outputFilesAfter = TaskFingerprintUtil.fingerprintTaskFiles(task, outputProperties, fingerprinterRegistry);
        if (!hasOverlappingOutputs) {
            return outputFilesAfter;
        }
        return ImmutableSortedMap.copyOfSorted((SortedMap)Maps.transformEntries(current, (Maps.EntryTransformer)new Maps.EntryTransformer<String, CurrentFileCollectionFingerprint, CurrentFileCollectionFingerprint>(){

            public CurrentFileCollectionFingerprint transformEntry(String propertyName, CurrentFileCollectionFingerprint beforeExecution) {
                CurrentFileCollectionFingerprint afterExecution = (CurrentFileCollectionFingerprint)outputFilesAfter.get((Object)propertyName);
                FileCollectionFingerprint afterPreviousExecution = TaskFingerprintUtil.getFingerprintAfterPreviousExecution((ImmutableSortedMap<String, FileCollectionFingerprint>)previous, propertyName);
                return TaskFingerprintUtil.filterOutputFingerprint(afterPreviousExecution, beforeExecution, afterExecution);
            }
        }));
    }

    public static ImmutableSortedMap<String, CurrentFileCollectionFingerprint> fingerprintTaskFiles(TaskInternal task, SortedSet<? extends TaskFilePropertySpec> fileProperties, FileCollectionFingerprinterRegistry fingerprinterRegistry) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (TaskFilePropertySpec taskFilePropertySpec : fileProperties) {
            FileCollectionFingerprinter fingerprinter = fingerprinterRegistry.getFingerprinter(taskFilePropertySpec.getNormalizer());
            LOGGER.debug("Fingerprinting property {} for {}", (Object)taskFilePropertySpec, (Object)task);
            CurrentFileCollectionFingerprint result = fingerprinter.fingerprint(taskFilePropertySpec.getPropertyFiles());
            builder.put((Object)taskFilePropertySpec.getPropertyName(), (Object)result);
        }
        return builder.build();
    }

    private static FileCollectionFingerprint getFingerprintAfterPreviousExecution(@Nullable ImmutableSortedMap<String, FileCollectionFingerprint> previous, String propertyName) {
        FileCollectionFingerprint afterPreviousExecution;
        if (previous != null && (afterPreviousExecution = (FileCollectionFingerprint)previous.get((Object)propertyName)) != null) {
            return afterPreviousExecution;
        }
        return FileCollectionFingerprint.EMPTY;
    }

    public static CurrentFileCollectionFingerprint filterOutputFingerprint(@Nullable FileCollectionFingerprint afterPreviousExecution, CurrentFileCollectionFingerprint beforeExecution, CurrentFileCollectionFingerprint afterExecution) {
        CurrentFileCollectionFingerprint filesFingerprint;
        final Map<String, FileSystemLocationSnapshot> beforeExecutionSnapshots = TaskFingerprintUtil.getAllSnapshots(beforeExecution);
        if (!beforeExecution.getFingerprints().isEmpty() && !afterExecution.getFingerprints().isEmpty()) {
            Object afterPreviousFingerprints = afterPreviousExecution != null ? afterPreviousExecution.getFingerprints() : ImmutableMap.of();
            ArrayList newRoots = new ArrayList();
            MutableBoolean hasBeenFiltered = new MutableBoolean(false);
            afterExecution.accept(new FileSystemSnapshotVisitor((Map)afterPreviousFingerprints, hasBeenFiltered, newRoots){
                private MerkleDirectorySnapshotBuilder merkleBuilder;
                private boolean currentRootFiltered = false;
                private DirectorySnapshot currentRoot;
                final /* synthetic */ Map val$afterPreviousFingerprints;
                final /* synthetic */ MutableBoolean val$hasBeenFiltered;
                final /* synthetic */ List val$newRoots;
                {
                    this.val$afterPreviousFingerprints = map2;
                    this.val$hasBeenFiltered = mutableBoolean;
                    this.val$newRoots = list;
                }

                public boolean preVisitDirectory(DirectorySnapshot directorySnapshot) {
                    if (this.merkleBuilder == null) {
                        this.merkleBuilder = MerkleDirectorySnapshotBuilder.noSortingRequired();
                        this.currentRoot = directorySnapshot;
                        this.currentRootFiltered = false;
                    }
                    this.merkleBuilder.preVisitDirectory(directorySnapshot);
                    return true;
                }

                public void visit(FileSystemLocationSnapshot fileSnapshot) {
                    if (!TaskFingerprintUtil.isOutputEntry(fileSnapshot, beforeExecutionSnapshots, this.val$afterPreviousFingerprints)) {
                        this.val$hasBeenFiltered.set(true);
                        this.currentRootFiltered = true;
                        return;
                    }
                    if (this.merkleBuilder == null) {
                        this.val$newRoots.add(fileSnapshot);
                    } else {
                        this.merkleBuilder.visit(fileSnapshot);
                    }
                }

                public void postVisitDirectory(DirectorySnapshot directorySnapshot) {
                    boolean isOutputDir = TaskFingerprintUtil.isOutputEntry((FileSystemLocationSnapshot)directorySnapshot, beforeExecutionSnapshots, this.val$afterPreviousFingerprints);
                    boolean includedDir = this.merkleBuilder.postVisitDirectory(isOutputDir);
                    if (!includedDir) {
                        this.currentRootFiltered = true;
                        this.val$hasBeenFiltered.set(true);
                    }
                    if (this.merkleBuilder.isRoot()) {
                        FileSystemLocationSnapshot result = this.merkleBuilder.getResult();
                        if (result != null) {
                            this.val$newRoots.add(this.currentRootFiltered ? result : this.currentRoot);
                        }
                        this.merkleBuilder = null;
                        this.currentRoot = null;
                    }
                }
            });
            filesFingerprint = !hasBeenFiltered.get() ? afterExecution : DefaultCurrentFileCollectionFingerprint.from(newRoots, (FingerprintingStrategy)AbsolutePathFingerprintingStrategy.IGNORE_MISSING);
        } else {
            filesFingerprint = afterExecution;
        }
        return filesFingerprint;
    }

    private static Map<String, FileSystemLocationSnapshot> getAllSnapshots(CurrentFileCollectionFingerprint fingerprint) {
        GetAllSnapshotsVisitor afterExecutionVisitor = new GetAllSnapshotsVisitor();
        fingerprint.accept((FileSystemSnapshotVisitor)afterExecutionVisitor);
        return afterExecutionVisitor.getSnapshots();
    }

    private static boolean isOutputEntry(FileSystemLocationSnapshot snapshot, Map<String, FileSystemLocationSnapshot> beforeSnapshots, Map<String, FileSystemLocationFingerprint> afterPreviousFingerprints) {
        if (snapshot.getType() == FileType.Missing) {
            return false;
        }
        FileSystemLocationSnapshot beforeSnapshot = beforeSnapshots.get(snapshot.getAbsolutePath());
        if (beforeSnapshot == null) {
            return true;
        }
        if (!snapshot.isContentAndMetadataUpToDate(beforeSnapshot)) {
            return true;
        }
        return afterPreviousFingerprints.containsKey(snapshot.getAbsolutePath());
    }

    private static class GetAllSnapshotsVisitor
    implements FileSystemSnapshotVisitor {
        private final Map<String, FileSystemLocationSnapshot> snapshots = new HashMap<String, FileSystemLocationSnapshot>();

        private GetAllSnapshotsVisitor() {
        }

        public boolean preVisitDirectory(DirectorySnapshot directorySnapshot) {
            this.snapshots.put(directorySnapshot.getAbsolutePath(), (FileSystemLocationSnapshot)directorySnapshot);
            return true;
        }

        public void visit(FileSystemLocationSnapshot fileSnapshot) {
            this.snapshots.put(fileSnapshot.getAbsolutePath(), fileSnapshot);
        }

        public void postVisitDirectory(DirectorySnapshot directorySnapshot) {
        }

        public Map<String, FileSystemLocationSnapshot> getSnapshots() {
            return this.snapshots;
        }
    }
}

