/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.plugins;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.ide.visualstudio.VisualStudioExtension;
import org.gradle.ide.visualstudio.VisualStudioProject;
import org.gradle.ide.visualstudio.VisualStudioRootExtension;
import org.gradle.ide.visualstudio.VisualStudioSolution;
import org.gradle.ide.visualstudio.internal.CppApplicationVisualStudioTargetBinary;
import org.gradle.ide.visualstudio.internal.CppSharedLibraryVisualStudioTargetBinary;
import org.gradle.ide.visualstudio.internal.CppStaticLibraryVisualStudioTargetBinary;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioExtension;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioRootExtension;
import org.gradle.ide.visualstudio.internal.VisualStudioExtensionInternal;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectInternal;
import org.gradle.ide.visualstudio.internal.VisualStudioSolutionInternal;
import org.gradle.ide.visualstudio.plugins.VisualStudioPluginRules;
import org.gradle.ide.visualstudio.tasks.GenerateFiltersFileTask;
import org.gradle.ide.visualstudio.tasks.GenerateProjectFileTask;
import org.gradle.ide.visualstudio.tasks.GenerateSolutionFileTask;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.language.cpp.CppApplication;
import org.gradle.language.cpp.CppComponent;
import org.gradle.language.cpp.CppExecutable;
import org.gradle.language.cpp.CppLibrary;
import org.gradle.language.cpp.CppSharedLibrary;
import org.gradle.language.cpp.CppStaticLibrary;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.plugins.ide.internal.IdePlugin;

@Incubating
public class VisualStudioPlugin
extends IdePlugin {
    private static final String LIFECYCLE_TASK_NAME = "visualStudio";
    private final Instantiator instantiator;
    private final FileResolver fileResolver;
    private final IdeArtifactRegistry artifactRegistry;
    private CollectionCallbackActionDecorator collectionCallbackActionDecorator;

    @Inject
    public VisualStudioPlugin(Instantiator instantiator, FileResolver fileResolver, IdeArtifactRegistry artifactRegistry, CollectionCallbackActionDecorator collectionCallbackActionDecorator) {
        this.instantiator = instantiator;
        this.fileResolver = fileResolver;
        this.artifactRegistry = artifactRegistry;
        this.collectionCallbackActionDecorator = collectionCallbackActionDecorator;
    }

    protected String getLifecycleTaskName() {
        return LIFECYCLE_TASK_NAME;
    }

    protected void onApply(Project target) {
        VisualStudioExtensionInternal extension;
        this.project.getPluginManager().apply(LifecycleBasePlugin.class);
        if (this.isRoot()) {
            extension = (VisualStudioExtensionInternal)this.project.getExtensions().create(VisualStudioRootExtension.class, LIFECYCLE_TASK_NAME, DefaultVisualStudioRootExtension.class, new Object[]{this.project.getName(), this.instantiator, target.getObjects(), this.fileResolver, this.artifactRegistry, this.collectionCallbackActionDecorator});
            final VisualStudioSolution solution = ((VisualStudioRootExtension)((Object)extension)).getSolution();
            this.getLifecycleTask().configure((Action)new Action<Task>(){

                public void execute(Task task) {
                    task.dependsOn(new Object[]{solution});
                }
            });
            this.addWorkspace(solution);
        } else {
            extension = (VisualStudioExtensionInternal)this.project.getExtensions().create(VisualStudioExtension.class, LIFECYCLE_TASK_NAME, DefaultVisualStudioExtension.class, new Object[]{this.instantiator, this.fileResolver, this.artifactRegistry, this.collectionCallbackActionDecorator});
            this.getLifecycleTask().configure((Action)new Action<Task>(){

                public void execute(Task task) {
                    task.dependsOn(new Object[]{extension.getProjects()});
                }
            });
        }
        this.includeBuildFileInProject(extension);
        this.createTasksForVisualStudio(extension);
        this.applyVisualStudioCurrentModelRules(extension);
        this.applyVisualStudioSoftwareModelRules();
    }

    private void applyVisualStudioCurrentModelRules(final VisualStudioExtensionInternal extension) {
        this.project.getComponents().withType(CppApplication.class).all((Action)new Action<CppApplication>(){

            public void execute(final CppApplication cppApplication) {
                cppApplication.getBinaries().whenElementFinalized(CppExecutable.class, (Action)new Action<CppExecutable>(){

                    public void execute(CppExecutable executable) {
                        extension.getProjectRegistry().addProjectConfiguration(new CppApplicationVisualStudioTargetBinary(VisualStudioPlugin.this.project.getName(), VisualStudioPlugin.this.project.getPath(), (CppComponent)cppApplication, executable));
                    }
                });
            }
        });
        this.project.getComponents().withType(CppLibrary.class).all((Action)new Action<CppLibrary>(){

            public void execute(final CppLibrary cppLibrary) {
                cppLibrary.getBinaries().whenElementFinalized(CppSharedLibrary.class, (Action)new Action<CppSharedLibrary>(){

                    public void execute(CppSharedLibrary library) {
                        extension.getProjectRegistry().addProjectConfiguration(new CppSharedLibraryVisualStudioTargetBinary(VisualStudioPlugin.this.project.getName(), VisualStudioPlugin.this.project.getPath(), (CppComponent)cppLibrary, library));
                    }
                });
                cppLibrary.getBinaries().whenElementFinalized(CppStaticLibrary.class, (Action)new Action<CppStaticLibrary>(){

                    public void execute(CppStaticLibrary library) {
                        extension.getProjectRegistry().addProjectConfiguration(new CppStaticLibraryVisualStudioTargetBinary(VisualStudioPlugin.this.project.getName(), VisualStudioPlugin.this.project.getPath(), (CppComponent)cppLibrary, library));
                    }
                });
            }
        });
    }

    private void applyVisualStudioSoftwareModelRules() {
        this.project.getPluginManager().apply(VisualStudioPluginRules.VisualStudioExtensionRules.class);
        if (this.isRoot()) {
            this.project.getPluginManager().apply(VisualStudioPluginRules.VisualStudioPluginRootRules.class);
        }
        this.project.getPlugins().withType(ComponentModelBasePlugin.class).all((Action)new Action<ComponentModelBasePlugin>(){

            public void execute(ComponentModelBasePlugin componentModelBasePlugin) {
                VisualStudioPlugin.this.project.getPluginManager().apply(VisualStudioPluginRules.VisualStudioPluginProjectRules.class);
            }
        });
    }

    private void includeBuildFileInProject(VisualStudioExtensionInternal extension) {
        extension.getProjectRegistry().all((Action)new Action<DefaultVisualStudioProject>(){

            public void execute(DefaultVisualStudioProject vsProject) {
                if (VisualStudioPlugin.this.project.getBuildFile() != null) {
                    vsProject.addSourceFile(VisualStudioPlugin.this.project.getBuildFile());
                }
            }
        });
    }

    private void createTasksForVisualStudio(VisualStudioExtensionInternal extension) {
        extension.getProjectRegistry().all((Action)new Action<DefaultVisualStudioProject>(){

            public void execute(DefaultVisualStudioProject vsProject) {
                VisualStudioPlugin.this.addTasksForVisualStudioProject(vsProject);
            }
        });
        if (this.isRoot()) {
            VisualStudioRootExtension rootExtension = (VisualStudioRootExtension)((Object)extension);
            VisualStudioSolutionInternal vsSolution = (VisualStudioSolutionInternal)rootExtension.getSolution();
            vsSolution.builtBy(this.createSolutionTask(vsSolution));
        }
        this.configureCleanTask();
    }

    private void addTasksForVisualStudioProject(VisualStudioProjectInternal vsProject) {
        vsProject.builtBy(this.createProjectsFileTask(vsProject), this.createFiltersFileTask(vsProject));
        Task lifecycleTask = (Task)this.project.getTasks().maybeCreate(vsProject.getComponentName() + "VisualStudio");
        lifecycleTask.dependsOn(new Object[]{vsProject});
    }

    private void configureCleanTask() {
        TaskProvider cleanTask = this.getCleanTask();
        cleanTask.configure((Action)new Action<Delete>(){

            public void execute(Delete cleanTask) {
                cleanTask.delete(new Object[]{VisualStudioPlugin.this.project.getTasks().withType(GenerateSolutionFileTask.class)});
                cleanTask.delete(new Object[]{VisualStudioPlugin.this.project.getTasks().withType(GenerateFiltersFileTask.class)});
                cleanTask.delete(new Object[]{VisualStudioPlugin.this.project.getTasks().withType(GenerateProjectFileTask.class)});
            }
        });
    }

    private Task createSolutionTask(VisualStudioSolution solution) {
        GenerateSolutionFileTask solutionFileTask = (GenerateSolutionFileTask)this.project.getTasks().create(solution.getName() + "VisualStudioSolution", GenerateSolutionFileTask.class);
        solutionFileTask.setVisualStudioSolution(solution);
        return solutionFileTask;
    }

    private Task createProjectsFileTask(VisualStudioProject vsProject) {
        GenerateProjectFileTask task = (GenerateProjectFileTask)this.project.getTasks().create(vsProject.getName() + "VisualStudioProject", GenerateProjectFileTask.class);
        task.setVisualStudioProject(vsProject);
        task.initGradleCommand();
        return task;
    }

    private Task createFiltersFileTask(VisualStudioProject vsProject) {
        GenerateFiltersFileTask task = (GenerateFiltersFileTask)this.project.getTasks().create(vsProject.getName() + "VisualStudioFilters", GenerateFiltersFileTask.class);
        task.setVisualStudioProject(vsProject);
        return task;
    }
}

