/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.SB;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;

class UhbdReader
extends VolumeFileReader {
    private int planeCount;
    private int voxelCount;
    int pt;

    UhbdReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2VFR(surfaceGenerator, bufferedReader);
        if (this.params.thePlane == null) {
            this.params.insideOut = !this.params.insideOut;
        }
        this.isAngstroms = true;
        this.nSurfaces = 1;
    }

    @Override
    protected void readParameters() throws Exception {
        this.rd();
        this.jvxlFileHeaderBuffer = SB.newS(this.line);
        this.jvxlFileHeaderBuffer.append("UHBD format ").append(this.line).append("\n");
        this.jvxlFileHeaderBuffer.append("see http://sourceforge.net/p/apbs/code/ci/9527462a39126fb6cd880924b3cc4880ec4b78a9/tree/src/mg/vgrid.c\n");
        this.rd();
        this.rd();
        this.voxelCounts[0] = this.parseIntStr(this.line.substring(0, 7));
        this.voxelCounts[1] = this.parseIntStr(this.line.substring(7, 14));
        this.voxelCounts[2] = this.parseIntStr(this.line.substring(14, 21));
        float f = this.parseFloatStr(this.line.substring(21, 33));
        this.volumetricOrigin.set(this.parseFloatStr(this.line.substring(33, 45)), this.parseFloatStr(this.line.substring(45, 57)), this.parseFloatStr(this.line.substring(57, 69)));
        this.volumetricVectors[0].set(0.0f, 0.0f, f);
        this.volumetricVectors[1].set(0.0f, f, 0.0f);
        this.volumetricVectors[2].set(f, 0.0f, 0.0f);
        this.planeCount = this.voxelCounts[0] * this.voxelCounts[1];
        this.rd();
        this.rd();
    }

    @Override
    protected float nextVoxel() throws Exception {
        if (this.voxelCount % this.planeCount == 0) {
            this.rd();
            this.pt = 0;
        }
        if (this.pt % 78 == 0) {
            this.rd();
            this.pt = 0;
        }
        ++this.voxelCount;
        float f = this.parseFloatStr(this.line.substring(this.pt, this.pt + 13));
        this.pt += 13;
        return f;
    }
}

