/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.Index;

public class MetaStateService
extends AbstractComponent {
    private final NodeEnvironment nodeEnv;
    private final NamedXContentRegistry namedXContentRegistry;

    public MetaStateService(Settings settings, NodeEnvironment nodeEnv, NamedXContentRegistry namedXContentRegistry) {
        super(settings);
        this.nodeEnv = nodeEnv;
        this.namedXContentRegistry = namedXContentRegistry;
    }

    MetaData loadFullState() throws IOException {
        MetaData globalMetaData = this.loadGlobalState();
        MetaData.Builder metaDataBuilder = globalMetaData != null ? MetaData.builder(globalMetaData) : MetaData.builder();
        for (String indexFolderName : this.nodeEnv.availableIndexFolders()) {
            IndexMetaData indexMetaData = IndexMetaData.FORMAT.loadLatestState(this.logger, this.namedXContentRegistry, this.nodeEnv.resolveIndexFolder(indexFolderName));
            if (indexMetaData != null) {
                metaDataBuilder.put(indexMetaData, false);
                continue;
            }
            this.logger.debug("[{}] failed to find metadata for existing index location", (Object)indexFolderName);
        }
        return metaDataBuilder.build();
    }

    @Nullable
    public IndexMetaData loadIndexState(Index index) throws IOException {
        return IndexMetaData.FORMAT.loadLatestState(this.logger, this.namedXContentRegistry, this.nodeEnv.indexPaths(index));
    }

    List<IndexMetaData> loadIndicesStates(Predicate<String> excludeIndexPathIdsPredicate) throws IOException {
        ArrayList<IndexMetaData> indexMetaDataList = new ArrayList<IndexMetaData>();
        for (String indexFolderName : this.nodeEnv.availableIndexFolders(excludeIndexPathIdsPredicate)) {
            assert (!excludeIndexPathIdsPredicate.test(indexFolderName)) : "unexpected folder " + indexFolderName + " which should have been excluded";
            IndexMetaData indexMetaData = IndexMetaData.FORMAT.loadLatestState(this.logger, this.namedXContentRegistry, this.nodeEnv.resolveIndexFolder(indexFolderName));
            if (indexMetaData != null) {
                String indexPathId = indexMetaData.getIndex().getUUID();
                if (indexFolderName.equals(indexPathId)) {
                    indexMetaDataList.add(indexMetaData);
                    continue;
                }
                throw new IllegalStateException("[" + indexFolderName + "] invalid index folder name, rename to [" + indexPathId + "]");
            }
            this.logger.debug("[{}] failed to find metadata for existing index location", (Object)indexFolderName);
        }
        return indexMetaDataList;
    }

    MetaData loadGlobalState() throws IOException {
        return MetaData.FORMAT.loadLatestState(this.logger, this.namedXContentRegistry, this.nodeEnv.nodeDataPaths());
    }

    public void writeIndex(String reason, IndexMetaData indexMetaData) throws IOException {
        Index index = indexMetaData.getIndex();
        this.logger.trace("[{}] writing state, reason [{}]", (Object)index, (Object)reason);
        try {
            IndexMetaData.FORMAT.write(indexMetaData, this.nodeEnv.indexPaths(indexMetaData.getIndex()));
            this.logger.trace("[{}] state written", (Object)index);
        }
        catch (Exception ex) {
            this.logger.warn(() -> new ParameterizedMessage("[{}]: failed to write index state", (Object)index), (Throwable)ex);
            throw new IOException("failed to write state for [" + index + "]", ex);
        }
    }

    void writeGlobalState(String reason, MetaData metaData) throws IOException {
        this.logger.trace("[_global] writing state, reason [{}]", (Object)reason);
        try {
            MetaData.FORMAT.write(metaData, this.nodeEnv.nodeDataPaths());
            this.logger.trace("[_global] state written");
        }
        catch (Exception ex) {
            this.logger.warn("[_global]: failed to write global state", (Throwable)ex);
            throw new IOException("failed to write global state", ex);
        }
    }
}

