/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import com.google.common.collect.Sets;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.component.ComponentWithCoordinates;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.provider.Provider;
import org.gradle.nativeplatform.TargetMachine;
import org.gradle.util.GUtil;

public class NativeVariantIdentity
implements SoftwareComponentInternal,
ComponentWithCoordinates {
    private final String name;
    private final Provider<String> baseName;
    private final Provider<String> group;
    private final Provider<String> version;
    private final boolean debuggable;
    private final boolean optimized;
    private final TargetMachine targetMachine;
    private final UsageContext linkUsage;
    private final UsageContext runtimeUsage;
    private final Set<UsageContext> usageContexts;

    public NativeVariantIdentity(String name, Provider<String> baseName, Provider<String> group, Provider<String> version, boolean debuggable, boolean optimized, TargetMachine targetMachine, UsageContext linkUsage, UsageContext runtimeUsage) {
        this.name = name;
        this.baseName = baseName;
        this.group = group;
        this.version = version;
        this.debuggable = debuggable;
        this.optimized = optimized;
        this.targetMachine = targetMachine;
        this.linkUsage = linkUsage;
        this.runtimeUsage = runtimeUsage;
        this.usageContexts = Sets.newLinkedHashSet();
        if (linkUsage != null) {
            this.usageContexts.add(linkUsage);
        }
        if (runtimeUsage != null) {
            this.usageContexts.add(runtimeUsage);
        }
    }

    public boolean isDebuggable() {
        return this.debuggable;
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    public TargetMachine getTargetMachine() {
        return this.targetMachine;
    }

    public ModuleVersionIdentifier getCoordinates() {
        return DefaultModuleVersionIdentifier.newId((String)((String)this.group.get()), (String)((String)this.baseName.get() + "_" + GUtil.toWords((CharSequence)this.name, (char)'_')), (String)((String)this.version.get()));
    }

    public Set<? extends UsageContext> getUsages() {
        return this.usageContexts;
    }

    public String getName() {
        return this.name;
    }

    public UsageContext getRuntimeUsageContext() {
        return this.runtimeUsage;
    }

    public UsageContext getLinkUsageContext() {
        return this.linkUsage;
    }
}

